/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;

public class FunctionCategoryType {
    public static final String MBGD = "mbgd";
    public static final String COG = "cog";
    public static final String KEGG = "kegg";
    public static final String TIGR = "tigr";
    public static final String[] FUNCTION_CATEGORY_TYPES = new String[]{"mbgd", "cog", "kegg", "tigr"};
    public static final String DISPLAY_MBGD = "MBGD";
    public static final String DISPLAY_COG = "COG";
    public static final String DISPLAY_KEGG = "KEGG";
    public static final String DISPLAY_TIGR = "TIGR";
    public static final String[] DISPLAY_LIST = new String[]{"MBGD", "COG", "KEGG", "TIGR"};

    public static String getType2Display(String string) {
        if (string.equals(MBGD)) {
            return DISPLAY_MBGD;
        }
        if (string.equals(COG)) {
            return DISPLAY_COG;
        }
        if (string.equals(KEGG)) {
            return DISPLAY_KEGG;
        }
        if (string.equals(TIGR)) {
            return DISPLAY_TIGR;
        }
        return null;
    }

    public static String getDisplay2Type(String string) {
        if (string.equals(DISPLAY_MBGD)) {
            return MBGD;
        }
        if (string.equals(DISPLAY_COG)) {
            return COG;
        }
        if (string.equals(DISPLAY_KEGG)) {
            return KEGG;
        }
        if (string.equals(DISPLAY_TIGR)) {
            return TIGR;
        }
        return null;
    }

    public static ClusterInfoTitle getClusterInfoTitle(String string) {
        if (FunctionCategoryType.isMBGD(string)) {
            return ClusterInfoFacade.getInfoTitle("CFuncMbgd");
        }
        if (FunctionCategoryType.isCOG(string)) {
            return ClusterInfoFacade.getInfoTitle("CFuncCog");
        }
        if (FunctionCategoryType.isKEGG(string)) {
            return ClusterInfoFacade.getInfoTitle("CFuncKegg");
        }
        if (FunctionCategoryType.isTIGR(string)) {
            return ClusterInfoFacade.getInfoTitle("CFuncTigr");
        }
        return null;
    }

    public static ClusterInfoTitle getSubClusterInfoTitle(String string) {
        if (FunctionCategoryType.isMBGD(string)) {
            return ClusterInfoFacade.getInfoTitle("SCFuncMbgd");
        }
        if (FunctionCategoryType.isCOG(string)) {
            return ClusterInfoFacade.getInfoTitle("SCFuncCog");
        }
        if (FunctionCategoryType.isKEGG(string)) {
            return ClusterInfoFacade.getInfoTitle("SCFuncKegg");
        }
        if (FunctionCategoryType.isTIGR(string)) {
            return ClusterInfoFacade.getInfoTitle("SCFuncTigr");
        }
        return null;
    }

    public static boolean isMBGD(String string) {
        return string.equals(MBGD);
    }

    public static boolean isCOG(String string) {
        return string.equals(COG);
    }

    public static boolean isKEGG(String string) {
        return string.equals(KEGG);
    }

    public static boolean isTIGR(String string) {
        return string.equals(TIGR);
    }
}

