/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.data.Position;
import cgdp.recog.gmap.GenomeMap;
import cgdp.recog.gmap.GenomeMapButton;
import cgdp.recog.gmap.GenomeMapCondition;
import cgdp.recog.gmap.GenomeMapOptionDialog;
import cgdp.recog.gmap.GenomeMapOptionItem;
import cgdp.recog.gmap.GenomeMapOptionTool;
import cgdp.recog.gmap.GenomeMapZoomInTool;
import cgdp.recog.gmap.GenomeMapZoomOutTool;
import cgdp.recog.gmap.GenomeScrollPane;
import cgdp.recog.gmap.MoveNextTool;
import cgdp.recog.gmap.MovePrevTool;
import cgdp.recog.gmap.PartialMap;
import cgdp.recog.gmap.PartialScrollPane;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationFrame;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class GenomeMapFrame
extends ApplicationFrame
implements ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GenomeMapFrame.class);
    private MediatorImpl m_mediatorImpl;
    private JTextField m_fromTxt;
    private JTextField m_toTxt;
    private GenomeMap genomeMap;
    private PartialMap partialMap;
    private PartialScrollPane partialScrollPane;
    private PageFormat pageFormat;
    private GenomeMapCondition genomeMapCondition = new GenomeMapCondition();

    public GenomeMapFrame(Frame frame, MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.m_mediatorImpl.register(this);
        this.setTitle("Genome Map");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GenomeMapFrame.this.m_mediatorImpl.closeGenomeMapFrame();
            }
        });
        this.createComponent();
        this.pack();
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (optionValues.getGenomeMapW() != 0 && optionValues.getGenomeMapH() != 0) {
            this.setBounds(optionValues.getGenomeMapX(), optionValues.getGenomeMapY(), optionValues.getGenomeMapW(), optionValues.getGenomeMapH());
        } else {
            this.setLocationRelativeTo(null);
        }
        this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
    }

    private void createComponent() {
        this.genomeMap = new GenomeMap(this, this.m_mediatorImpl);
        GenomeScrollPane genomeScrollPane = new GenomeScrollPane(this.m_mediatorImpl, this.genomeMap);
        this.partialMap = new PartialMap(this.m_mediatorImpl, this.genomeMap);
        this.partialScrollPane = new PartialScrollPane(this.m_mediatorImpl, this.partialMap, this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.createRangePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)genomeScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createControlPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.partialScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)jPanel, "Center");
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        class GenomeMapPrintMenu
        extends JMenuItem
        implements CommandImpl {
            GenomeMapPrintMenu() {
                super("Print");
            }

            @Override
            public void execute() {
                GenomeMapFrame.this.genomeMap.print(GenomeMapFrame.this.pageFormat);
            }
        }
        GenomeMapPrintMenu genomeMapPrintMenu = new GenomeMapPrintMenu();
        jMenu.add(genomeMapPrintMenu);
        genomeMapPrintMenu.addActionListener(this);
        class GenomeMapPageSetupMenu
        extends JMenuItem
        implements CommandImpl {
            GenomeMapPageSetupMenu() {
                super("Page Setup");
            }

            @Override
            public void execute() {
                GenomeMapFrame.this.pageFormat = PrinterJob.getPrinterJob().pageDialog(GenomeMapFrame.this.pageFormat);
            }
        }
        GenomeMapPageSetupMenu genomeMapPageSetupMenu = new GenomeMapPageSetupMenu();
        jMenu.add(genomeMapPageSetupMenu);
        genomeMapPageSetupMenu.addActionListener(this);
        JMenu jMenu2 = new JMenu("View");
        jMenuBar.add(jMenu2);
        jMenu2.add(new GenomeMapOptionItem(this, this));
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        GenomeMapOptionTool genomeMapOptionTool = new GenomeMapOptionTool(this, this);
        jToolBar.add(genomeMapOptionTool);
        return jToolBar;
    }

    private JPanel createRangePanel() {
        this.m_fromTxt = new JTextField(10);
        this.m_toTxt = new JTextField(10);
        GenomeMapButton genomeMapButton = new GenomeMapButton(this, this);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel("From:");
        JLabel jLabel2 = new JLabel("To:");
        jPanel.add(jLabel);
        jPanel.add(this.m_fromTxt);
        jPanel.add(jLabel2);
        jPanel.add(this.m_toTxt);
        jPanel.add(genomeMapButton);
        return jPanel;
    }

    private JPanel createControlPanel() {
        MovePrevTool movePrevTool = new MovePrevTool(this, this.m_mediatorImpl, this);
        GenomeMapZoomInTool genomeMapZoomInTool = new GenomeMapZoomInTool(this, this.m_mediatorImpl, this);
        GenomeMapZoomOutTool genomeMapZoomOutTool = new GenomeMapZoomOutTool(this, this.m_mediatorImpl, this);
        MoveNextTool moveNextTool = new MoveNextTool(this, this.m_mediatorImpl, this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBackground(Color.white);
        jPanel.add(movePrevTool);
        jPanel.add(genomeMapZoomInTool);
        jPanel.add(genomeMapZoomOutTool);
        jPanel.add(moveNextTool);
        return jPanel;
    }

    public void updateValue(String string) {
        this.updateCondtion(string);
        this.genomeMap.updateValue(this.genomeMapCondition);
        this.partialMap.updateValue(this.genomeMapCondition);
    }

    private void updateCondtion(String string) {
        this.genomeMapCondition.setDomClustId(string);
        ApplicationPropertyFacade.updateDomClustAccessable(string, this.genomeMapCondition);
    }

    public void setRange(int n, int n2) {
        this.m_fromTxt.setText(n != -1 ? String.valueOf(n) : "");
        this.m_toTxt.setText(n2 != -1 ? String.valueOf(n2) : "");
    }

    public void updateRange() {
        int n = 0;
        try {
            n = Integer.parseInt(this.m_fromTxt.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = 10000;
        try {
            n2 = Integer.parseInt(this.m_toTxt.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n3 = this.genomeMap.getLength();
        if (n > n3 && n2 > n3) {
            this.m_fromTxt.setText(String.valueOf(n3 - 10000));
            this.m_toTxt.setText(String.valueOf(n3));
        } else if (n > n3) {
            this.m_fromTxt.setText(String.valueOf(n3));
        } else if (n2 > n3) {
            this.m_toTxt.setText(String.valueOf(n3));
        }
    }

    public void zoomIn() {
        try {
            if (this.partialMap.getPosition() == null) {
                return;
            }
            int n = this.genomeMap.getLength();
            if (n == -1) {
                MessageManager.showErrorMessage((Component)this, "Please select a Chromosome.");
                return;
            }
            int n2 = this.partialMap.getLimitRange();
            if (n <= n2) {
                return;
            }
            int n3 = this.genomeMap.getId();
            boolean bl = this.genomeMap.isCircular();
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Position position = this.getPosition(n, bl);
            int n4 = position.getRange();
            if (n4 <= n2) {
                return;
            }
            OptionTbl optionTbl = OptionTbl.getInstance();
            n4 = optionTbl.getOptionValues().getZoomIn2(n4);
            n4 = n4 < n2 ? n2 : n4;
            int n5 = position.getStart() + position.getRange() / 2 - n4 / 2;
            if (bl) {
                if (n5 < 1) {
                    n5 += n;
                } else if (n5 > n) {
                    n5 -= n;
                }
            } else if (n5 < 1) {
                n5 = 1;
            } else if (n5 + n4 - 1 > n) {
                n5 = n - n4 + 1;
            }
            position.setStart(n5);
            position.setEnd(n5 + n4 - 1);
            this.genomeMap.setRange(position.getStart(), position.getEnd());
            this.partialMap.setDatas(n3, n, geneTbl, position);
        }
        catch (Exception exception) {
            String string = "Fail to zoom in on the genome map.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        catch (Error error) {
            String string = "Fail to zoom in on the genome map.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    public void zoomOut() {
        try {
            if (this.partialMap.getPosition() == null) {
                return;
            }
            int n = this.genomeMap.getLength();
            if (n == -1) {
                MessageManager.showErrorMessage((Component)this, "Please select a Chromosome.");
                return;
            }
            int n2 = this.partialMap.getLimitRange();
            if (n <= n2) {
                return;
            }
            int n3 = this.genomeMap.getId();
            boolean bl = this.genomeMap.isCircular();
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Position position = this.getPosition(n, bl);
            int n4 = position.getRange();
            if (n4 >= n) {
                return;
            }
            OptionTbl optionTbl = OptionTbl.getInstance();
            n4 = optionTbl.getOptionValues().getZoomOut2(n4);
            n4 = n4 > n ? n : n4;
            int n5 = position.getStart() + position.getRange() / 2 - n4 / 2;
            if (bl) {
                if (n5 < 1) {
                    n5 += n;
                } else if (n5 > n) {
                    n5 -= n;
                }
            } else if (n5 < 1) {
                n5 = 1;
            } else if (n5 + n4 - 1 > n) {
                n5 = n - n4 + 1;
            }
            position.setStart(n5);
            position.setEnd(n5 + n4 - 1);
            this.genomeMap.setRange(position.getStart(), position.getEnd());
            this.partialMap.setDatas(n3, n, geneTbl, position);
        }
        catch (Exception exception) {
            String string = "Fail to zoom out on the genome map.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        catch (Error error) {
            String string = "Fail to zoom out on the genome map.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    public void movePrev() {
        try {
            if (this.partialMap.getPosition() == null) {
                return;
            }
            int n = this.genomeMap.getLength();
            if (n == -1) {
                MessageManager.showErrorMessage((Component)this, "Please select a Chromosome.");
                return;
            }
            int n2 = this.genomeMap.getId();
            boolean bl = this.genomeMap.isCircular();
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Position position = this.getPosition(n, bl);
            int n3 = position.getRange();
            if (bl || !bl && position.getStart() > 1) {
                OptionTbl optionTbl = OptionTbl.getInstance();
                int n4 = optionTbl.getOptionValues().getMovePrev(n3);
                int n5 = position.getStart() - n4;
                if (bl) {
                    if (n5 < 1) {
                        n5 += n;
                    } else if (n5 > n) {
                        n5 -= n;
                    }
                } else if (n5 < 1) {
                    n5 = 1;
                } else if (n5 + n3 - 1 > n) {
                    n5 = n - n3 + 1;
                }
                position.setStart(n5);
                position.setEnd(n5 + n3 - 1);
                this.genomeMap.setRange(position.getStart(), position.getEnd());
                this.partialMap.setDatas(n2, n, geneTbl, position);
            }
        }
        catch (Exception exception) {
            String string = "Fail to move prev on the genome map.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        catch (Error error) {
            String string = "Fail to move prev on the genome map.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    public void moveNext() {
        try {
            if (this.partialMap.getPosition() == null) {
                return;
            }
            int n = this.genomeMap.getLength();
            if (n == -1) {
                MessageManager.showErrorMessage((Component)this, "Please select a Chromosome.");
                return;
            }
            int n2 = this.genomeMap.getId();
            boolean bl = this.genomeMap.isCircular();
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Position position = this.getPosition(n, bl);
            int n3 = position.getRange();
            if (bl || !bl && position.getEnd() < n) {
                OptionTbl optionTbl = OptionTbl.getInstance();
                int n4 = optionTbl.getOptionValues().getMoveNext(n3);
                int n5 = position.getStart() + n4;
                if (bl) {
                    if (n5 < 1) {
                        n5 += n;
                    } else if (n5 > n) {
                        n5 -= n;
                    }
                } else if (n5 < 1) {
                    n5 = 1;
                } else if (n5 + n3 - 1 > n) {
                    n5 = n - n3 + 1;
                }
                position.setStart(n5);
                position.setEnd(n5 + n3 - 1);
                this.genomeMap.setRange(position.getStart(), position.getEnd());
                this.partialMap.setDatas(n2, n, geneTbl, position);
            }
        }
        catch (Exception exception) {
            String string = "Fail to move next on the genome map.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        catch (Error error) {
            String string = "Fail to move next on the genome map.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    public void showRange() {
        try {
            int n = this.genomeMap.getLength();
            if (n == -1) {
                MessageManager.showErrorMessage((Component)this, "Please select a Chromosome.");
                return;
            }
            int n2 = this.genomeMap.getId();
            boolean bl = this.genomeMap.isCircular();
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Position position = this.getPosition(n, bl);
            this.genomeMap.setRange(position.getStart(), position.getEnd());
            this.partialMap.setDatas(n2, n, geneTbl, position);
        }
        catch (Exception exception) {
            String string = "Fail to show range on the genome map.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        catch (Error error) {
            String string = "Fail to show range on the genome map.";
            logger.warn(string, error);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    public void showRange(String string) {
        try {
            int n;
            GeneTbl geneTbl = this.genomeMap.getGeneTbl();
            Gene gene = (Gene)geneTbl.get(string);
            if (gene == null) {
                return;
            }
            int n2 = this.genomeMap.getId();
            if (gene.getChromId() != n2) {
                return;
            }
            int n3 = this.genomeMap.getLength();
            if (n3 == -1) {
                return;
            }
            int n4 = gene.getStart() - gene.getLength() * 2;
            if (n4 < 0) {
                n4 += n3;
            }
            if ((n = gene.getEnd() + gene.getLength() * 2) > n3) {
                n -= n3;
            }
            if (n4 > n) {
                n += n3;
            }
            Position position = new Position(n4, n);
            this.genomeMap.setRange(position.getStart(), position.getEnd());
            this.partialMap.setDatas(n2, n3, geneTbl, position);
        }
        catch (Exception exception) {
            String string2 = "Fail to show range on the genome map.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this, string2);
        }
        catch (Error error) {
            String string3 = "Fail to show range on the genome map.";
            logger.warn(string3, error);
            MessageManager.showErrorMessage((Component)this, string3);
        }
    }

    public void setChromosomeData(int n, String string, boolean bl, int n2, ClusterTbl clusterTbl) throws Exception {
        Organism organism = clusterTbl.getOrganism(string);
        this.genomeMap.setChromosomeData(n, organism, bl, n2, clusterTbl);
        this.partialMap.setChromosomeData(clusterTbl, organism);
    }

    public void setHighlightCluster(Collection collection) {
        Cluster cluster;
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        this.genomeMap.setHighlightCluster(collection);
        List list = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && CollectionUtil.isNull(list = (cluster = (Cluster)iterator.next()).getLocusTagWithoutDomainList(this.genomeMap.getOrganismCode()))) {
        }
        this.setViewRangePartialMap(list);
    }

    public void setHighlightLocusTag(String string, Collection collection) {
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        this.genomeMap.setHighlightLocusTag(string, collection);
        this.setViewRangePartialMap(collection);
    }

    private void setViewRangePartialMap(Collection collection) {
        if (CollectionUtil.isNull(collection)) {
            return;
        }
        String string = (String)collection.iterator().next();
        this.showRange(string);
    }

    public void clearClusterList() {
        this.genomeMap.clearHighlightLocustag();
    }

    public void resizeGenomeMap(Dimension dimension) {
        this.genomeMap.resizeGenomeMap(dimension);
    }

    Position getPosition(int n, boolean bl) throws Exception {
        String string = this.m_fromTxt.getText();
        if (StringTool.isNull(string)) {
            throw new Exception("Please input [From].");
        }
        String string2 = this.m_toTxt.getText();
        if (StringTool.isNull(string2)) {
            throw new Exception("Please input [To].");
        }
        Position position = new Position();
        try {
            position.setStart(Integer.parseInt(string));
        }
        catch (Exception exception) {
            throw new Exception("Please input a numerical value into [From].");
        }
        try {
            position.setEnd(Integer.parseInt(string2));
        }
        catch (Exception exception) {
            throw new Exception("Please input a numerical value into [To].");
        }
        if (bl) {
            if (position.getStart() < 1 || position.getStart() > n || position.getEnd() < 1 || position.getEnd() > n) {
                throw new Exception("Please input a position value from 1 to " + n + ".");
            }
            if (position.getStart() > position.getEnd()) {
                position.setEnd(position.getEnd() + n);
            }
            if (position.getRange() > n) {
                throw new Exception("Position value is too large.");
            }
        } else {
            if (position.getStart() > position.getEnd()) {
                throw new Exception("Please input a position value correctly.");
            }
            if (position.getStart() < 1 || position.getEnd() > n) {
                throw new Exception("Please input a position value from 1 to " + n + ".");
            }
        }
        return position;
    }

    void showGenomeMapOptionDialog() {
        GenomeMapOptionDialog genomeMapOptionDialog = new GenomeMapOptionDialog((Frame)this, this.m_mediatorImpl, this.genomeMapCondition);
        genomeMapOptionDialog.setVisible(true);
        if (!genomeMapOptionDialog.isCanceled()) {
            this.repaintAll();
        }
    }

    public void repaintFromColorTree() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.genomeMapCondition.isPPM()) {
            return;
        }
        this.repaintAll();
    }

    private void repaintAll() {
        this.genomeMap.updateGenomeMap();
        this.partialMap.updatePartialMap();
    }

    public void resizePartialMap() {
        Dimension dimension = this.partialScrollPane.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        this.partialMap.resizePartialMap(dimension);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

