/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.Commons;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.data.Position;
import cgdp.recog.data.ViewData;
import cgdp.recog.gmap.GenomeMap;
import cgdp.recog.gmap.GenomeMapCondition;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class PartialMap
extends JPanel
implements MouseListener,
ActionListener,
MouseMotionListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private GeneTbl m_geneTbl;
    private GenomeMap genomeMap;
    private Organism organism;
    private int m_id;
    private int m_length;
    private Position m_position;
    private Font m_font;
    private FontMetrics m_fm;
    private BufferedImage m_image;
    private Graphics m_g;
    private double m_width;
    private double m_height;
    private double m_margin;
    private DecimalFormat m_df;
    private List m_viewDataList;
    private GenomeMapCondition genomeMapCondition;

    public PartialMap(MediatorImpl mediatorImpl, GenomeMap genomeMap) {
        this.mediator = mediatorImpl;
        this.genomeMap = genomeMap;
        this.clear();
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void clear() {
        this.m_id = 0;
        this.m_length = 0;
        this.m_geneTbl = null;
        this.m_position = null;
        this.m_font = new Font("Monospaced", 0, 12);
        this.m_fm = this.getFontMetrics(this.m_font);
        this.m_image = null;
        this.m_g = null;
        this.m_df = new DecimalFormat();
        this.m_viewDataList = new ArrayList();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(',');
        this.m_df.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_df.setGroupingSize(3);
    }

    public void resizePartialMap(Dimension dimension) {
        if (this.m_image == null || dimension.width != this.m_image.getWidth() || dimension.height != this.m_image.getHeight()) {
            if (this.m_image != null) {
                this.m_image.flush();
                this.m_image = null;
            }
            this.m_image = new BufferedImage(dimension.width, dimension.height, 1);
            this.m_g = this.m_image.getGraphics();
            this.m_g.setFont(this.m_font);
        }
        this.m_width = dimension.width;
        this.m_height = dimension.height;
        this.draw();
        this.repaint();
    }

    void setChromosomeData(ClusterTbl clusterTbl, Organism organism) {
        this.clusterTbl = clusterTbl;
        this.organism = organism;
    }

    public void setDatas(int n, int n2, GeneTbl geneTbl, Position position) {
        this.m_id = n;
        this.m_length = n2;
        this.m_geneTbl = geneTbl;
        this.m_position = position;
        this.m_margin = (double)this.m_fm.stringWidth(this.m_df.format(this.m_length)) / 2.0;
        this.draw();
        this.repaint();
    }

    public Position getPosition() {
        return this.m_position;
    }

    public int getLimitRange() {
        return (int)((this.m_width - this.m_margin * 2.0) / (double)this.m_position.getRange());
    }

    private void draw() {
        int n;
        int n2;
        this.m_g.setColor(Color.white);
        this.m_g.fillRect(0, 0, this.m_image.getWidth(), this.m_image.getHeight());
        this.m_viewDataList.clear();
        if (this.m_geneTbl == null) {
            return;
        }
        double d = this.calcScale();
        if (d <= 0.0) {
            return;
        }
        ((Graphics2D)this.m_g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.m_position.getStart();
        int n4 = this.m_position.getEnd();
        int n5 = this.m_fm.getHeight() + 3 + 3;
        int n6 = n5 + this.m_fm.getHeight() + 10 + 3;
        for (Gene gene : this.m_geneTbl.values()) {
            int n7;
            if (gene.getStart() > gene.getEnd() || gene.getRange() > this.m_length || gene.getChromId() != this.m_id) continue;
            n2 = gene.getStart();
            n = gene.getEnd();
            if (n4 > this.m_length && n2 <= n4 - this.m_length) {
                n2 += this.m_length;
                n += this.m_length;
            }
            int n8 = (int)((double)(n2 - n3) * d + this.m_margin);
            int n9 = gene.getDirection() == 1 ? n5 + this.m_fm.getHeight() : n6 + this.m_fm.getHeight();
            int n10 = (int)((double)(n - n2 + 1) * d);
            n10 = n10 < 1 ? 1 : n10;
            int n11 = 10;
            int n12 = n7 = gene.isPositive() ? n5 + this.m_fm.getAscent() : n6 + this.m_fm.getAscent();
            if (n2 >= n3 && n2 <= n4) {
                this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
                this.drawLocusTag(this.m_g, gene.getLocusTag(), n8, n7);
                if (n - this.m_length < n3 || n - this.m_length > n4) continue;
                n2 -= this.m_length;
                n -= this.m_length;
                this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
                this.drawLocusTag((Graphics2D)this.m_g, gene.getLocusTag(), n8, n7);
                continue;
            }
            if (n >= n3 && n <= n4) {
                this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
                this.drawLocusTag(this.m_g, gene.getLocusTag(), n8, n7);
                if (n2 + this.m_length < n3 || n2 + this.m_length > n4) continue;
                n2 += this.m_length;
                n += this.m_length;
                this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
                n7 = gene.getDirection() == 1 ? n5 + this.m_fm.getAscent() : n6 + this.m_fm.getAscent();
                this.drawLocusTag(this.m_g, gene.getLocusTag(), n8, n7);
                continue;
            }
            if (n2 < n3 && n > n4) {
                this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
                this.drawLocusTag(this.m_g, gene.getLocusTag(), n8, n7);
                continue;
            }
            if (n - this.m_length < n3) continue;
            n2 -= this.m_length;
            n -= this.m_length;
            this.drawFeature((Graphics2D)this.m_g, n8, n9, n10, n11, n7, gene);
            this.drawLocusTag(this.m_g, gene.getLocusTag(), n8, n7);
        }
        this.m_g.setColor(Color.white);
        ((Graphics2D)this.m_g).fill(new Rectangle2D.Double(0.0, 0.0, this.m_margin, this.m_height));
        ((Graphics2D)this.m_g).fill(new Rectangle2D.Double(this.m_width - this.m_margin, 0.0, this.m_margin, this.m_height));
        int n13 = Commons.getInterval(this.m_position.getRange());
        int n14 = n13 - n3 % n13;
        n5 = this.m_fm.getHeight();
        n6 = this.m_fm.getHeight() + 3;
        this.m_g.setColor(Color.black);
        this.m_g.drawLine((int)this.m_margin, n6, (int)(this.m_width - this.m_margin), n6);
        for (n2 = n3 + n14; n2 < n4 && n2 <= this.m_length; n2 += n13) {
            n = (int)((double)(n2 - n3) * d + this.m_margin);
            this.m_g.drawLine(n, n5, n, n6);
            String string = this.m_df.format(n2);
            this.m_g.drawString(string, n - this.m_fm.stringWidth(string) / 2, this.m_fm.getAscent());
        }
        if (n4 > this.m_length) {
            n = 0;
            for (n2 = this.m_length + 1; n2 < n4; n2 += n13) {
                int n15 = (int)((double)(n2 - n - n3) * d + this.m_margin);
                this.m_g.drawLine(n15, n5, n15, n6);
                String string = this.m_df.format(n2 - n - this.m_length);
                this.m_g.drawString(string, n15 - this.m_fm.stringWidth(string) / 2, this.m_fm.getAscent());
                n = 1;
            }
        }
        ((Graphics2D)this.m_g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private double calcScale() {
        return (this.m_width - this.m_margin * 2.0) / (double)this.m_position.getRange();
    }

    private boolean isVisibleLocusTag() {
        double d = this.calcScale();
        return d >= 0.05;
    }

    private boolean isDrawGeneLine() {
        double d = this.calcScale();
        return d >= 0.003;
    }

    private void drawLocusTag(Graphics graphics, String string, int n, int n2) {
        if (!this.isVisibleLocusTag()) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawString(string, n, n2);
    }

    private void addViewDataList(int n, int n2, Shape shape, String string) {
        ViewData viewData = new ViewData();
        viewData.setObject(string);
        viewData.setPolygon(shape);
        viewData.setNameRect(new Rectangle(n, n2 - this.m_fm.getAscent(), this.m_fm.stringWidth(string), this.m_fm.getAscent()));
        this.m_viewDataList.add(viewData);
    }

    private List getGeneInfoList(String string) {
        ArrayList<GeneInformation> arrayList = new ArrayList<GeneInformation>();
        int n = 1;
        while (true) {
            String string2 = GeneUtil.combineLocusTagDomainNo(string, n);
            Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), string2);
            if (cluster == null) break;
            GeneInformation geneInformation = cluster.getGeneInformation(this.getOrganismCode(), string2);
            arrayList.add(geneInformation);
            ++n;
        }
        return arrayList;
    }

    private void drawFeature(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, Gene gene) {
        if (this.isDomain(gene.getLocusTag())) {
            List list = this.getGeneInfoList(gene.getLocusTag());
            int n6 = gene.isPositive() ? n : n + n3;
            for (int i = 0; i < list.size(); ++i) {
                GeneInformation geneInformation = (GeneInformation)list.get(i);
                double d = (double)geneInformation.getLength() / (double)gene.getLength();
                int n7 = (int)((double)n3 * d);
                if (gene.isNegative()) {
                    n6 -= n7;
                }
                Shape shape = i == list.size() - 1 ? this.createArrowShape(n6, n2, n7, n4, gene) : new Rectangle(n6, n2, n7, n4);
                Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), geneInformation.getLocusTag());
                Color color = this.genomeMapCondition.getColor(cluster, this.organism, gene, this.clusterTbl.isOutgroup());
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.setColor(color);
                graphics2D.fill(shape);
                graphics2D.setColor(Color.black);
                if (this.isDrawGeneLine()) {
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(new BasicStroke(0.1f));
                    graphics2D.draw(shape);
                    graphics2D.setStroke(stroke);
                }
                this.addViewDataList(n6, n5, shape, geneInformation.getLocusTag());
                if (!gene.isPositive()) continue;
                n6 += n7;
            }
        } else {
            Shape shape = this.createArrowShape(n, n2, n3, n4, gene);
            Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), gene.getLocusTag());
            Color color = this.genomeMapCondition.getColor(cluster, this.organism, gene, this.clusterTbl.isOutgroup());
            if (color == null) {
                color = Color.white;
            }
            graphics2D.setColor(color);
            graphics2D.fill(shape);
            graphics2D.setColor(Color.black);
            if (this.isDrawGeneLine()) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(0.1f));
                graphics2D.draw(shape);
                graphics2D.setStroke(stroke);
            }
            this.addViewDataList(n, n5, shape, gene.getLocusTag());
        }
    }

    private Shape createArrowShape(int n, int n2, int n3, int n4, Gene gene) {
        int n5 = (int)((double)n3 * 0.5);
        n5 = n5 > 12 ? 12 : n5;
        Polygon polygon = new Polygon();
        if (gene.isPositive()) {
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3 - n5, n2);
            polygon.addPoint(n + n3, n2 + n4 / 2);
            polygon.addPoint(n + n3 - n5, n2 + n4);
            polygon.addPoint(n, n2 + n4);
        } else {
            polygon.addPoint(n, n2 + n4 / 2);
            polygon.addPoint(n + n5, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n + n5, n2 + n4);
        }
        return polygon;
    }

    private boolean isDomain(String string) {
        Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), string);
        if (cluster != null) {
            return false;
        }
        cluster = this.clusterTbl.getCluster(this.getOrganismCode(), GeneUtil.combineLocusTagDomainNo(string, 1));
        return cluster != null;
    }

    void updateValue(GenomeMapCondition genomeMapCondition) {
        this.genomeMapCondition = genomeMapCondition;
        this.updatePartialMap();
    }

    void updatePartialMap() {
        this.draw();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if ((double)mouseEvent.getX() < this.m_margin || (double)mouseEvent.getX() > this.m_width - this.m_margin) {
            return;
        }
        String string = this.getLocusTag(mouseEvent.getPoint());
        if (StringTool.isNull(string)) {
            return;
        }
        this.mediator.selectClusterOnPPM(this.getOrganismCode(), string);
        this.genomeMap.setHighlightLocusTag(this.getOrganismCode(), string);
        Cluster cluster = this.clusterTbl.getCluster(this.getOrganismCode(), string);
        if (cluster != null) {
            this.mediator.selectOrthologGroupOnCoreGenome(cluster);
            this.mediator.selectOrthologGroupOnGlobalAlign(cluster);
        }
        if (mouseEvent.getClickCount() == 2) {
            String string2 = GeneUrlFacade.getDefaultUrl(this.clusterTbl, this.getOrganismCode(), GeneUtil.removeDomainNo(string));
            this.mediator.viewUrl(string2);
        }
    }

    private String getLocusTag(Point point) {
        for (int i = this.m_viewDataList.size() - 1; i >= 0; --i) {
            ViewData viewData = (ViewData)this.m_viewDataList.get(i);
            if (!viewData.getPolygon().contains(point.getX(), point.getY()) && !viewData.getNameRect().contains(point.getX(), point.getY())) continue;
            return (String)viewData.getObject();
        }
        return null;
    }

    private String getOrganismCode() {
        return this.organism.getOrganismCode();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
        }
    }

    private void showPopup(Point point) {
        String string = this.getLocusTag(point);
        if (StringTool.isNull(string)) {
            return;
        }
        string = GeneUtil.removeDomainNo(string);
        List list = GeneUrlFacade.createUrlMenuList(this, this.mediator, this.clusterTbl, this.getOrganismCode(), string);
        if (!CollectionUtil.isNull(list)) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if ((double)mouseEvent.getX() < this.m_margin || (double)mouseEvent.getX() > this.m_width - this.m_margin) {
            return;
        }
        String string = this.getLocusTag(mouseEvent.getPoint());
        if (!StringTool.isNull(string)) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

