/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.HClustImporter;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.TreeParser;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.ServerStatus;

abstract class AbstractHClustImporter
extends FileImporter
implements HClustImporter {
    protected static final String TITLE_HEADER_UPGMA = "UPGMA";
    private String filepath;
    protected TreeParser treeParser;
    private String version;
    private String phpatId;
    private String domClustId;
    private int nCluster = -1;
    private int nClusterDom = -1;
    private String execServer;
    private int execPort = 80;
    private String query;
    private String clusterViewId;
    private boolean targetFilteredClusterList;
    private boolean forModifiedCluster;

    protected AbstractHClustImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
        this.setExistParameter(true);
        this.treeParser = new TreeParser(){

            @Override
            protected Node createNode(int n, String string, double d) {
                ClusterNode clusterNode = new ClusterNode();
                clusterNode.setId(n);
                clusterNode.setName(string);
                clusterNode.setDist(d);
                return clusterNode;
            }
        };
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (ServerStatus.isFormatVer(string)) {
            this.setVersion(ServerStatus.getFormatVer(string));
            return true;
        }
        if (ServerStatus.isClusterId(string)) {
            this.setPhpatId(ServerStatus.getClusterId(string));
            return true;
        }
        if (ServerStatus.isDomClustId(string)) {
            this.setDomClustId(ServerStatus.getDomClustId(string));
            return true;
        }
        if (ServerStatus.isExecServer(string)) {
            this.setExecServer(ServerStatus.getExecServer(string));
            return true;
        }
        if (ServerStatus.isExecPort(string)) {
            this.setExecPort(ServerStatus.getExecPort(string));
            return true;
        }
        if (ServerStatus.isQuery(string)) {
            this.setQuery(ServerStatus.getQuery(string));
            return true;
        }
        if (ServerStatus.isClusterViewId(string)) {
            this.setClusterViewId(ServerStatus.getClusterViewId(string));
            return true;
        }
        if (ServerStatus.isNClusters(string)) {
            this.setNCluster(ServerStatus.getNClusters(string));
            return true;
        }
        if (ServerStatus.isNClustersDom(string)) {
            this.setNClusterDom(ServerStatus.getNClustersDom(string));
            return true;
        }
        if (ServerStatus.isTargetFilteredClusterList(string)) {
            this.setTargetFilteredClusterList(ServerStatus.getTargetFilteredClusterList(string));
            return true;
        }
        if (ServerStatus.isModifiedCluster(string)) {
            this.setForModifiedCluster(true);
            return true;
        }
        return false;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPhpatId() {
        return this.phpatId;
    }

    private void setPhpatId(String string) {
        this.phpatId = string;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    private void setNCluster(int n) {
        this.nCluster = n;
    }

    public int getNClusterDom() {
        return this.nClusterDom;
    }

    public void setNClusterDom(int n) {
        this.nClusterDom = n;
    }

    private int getNCluster() {
        return this.nCluster;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getExecServer() {
        return this.execServer;
    }

    public void setExecServer(String string) {
        this.execServer = string;
    }

    public int getExecPort() {
        return this.execPort;
    }

    public void setExecPort(int n) {
        this.execPort = n;
    }

    public String getClusterViewId() {
        return this.clusterViewId;
    }

    public void setClusterViewId(String string) {
        this.clusterViewId = string;
    }

    public boolean isTargetFilteredClusterList() {
        return this.targetFilteredClusterList;
    }

    public void setTargetFilteredClusterList(boolean bl) {
        this.targetFilteredClusterList = bl;
    }

    public boolean isForModifiedCluster() {
        return this.forModifiedCluster;
    }

    public void setForModifiedCluster(boolean bl) {
        this.forModifiedCluster = bl;
    }

    protected boolean isHeaderLine(String string) {
        return string.startsWith(TITLE_HEADER_UPGMA);
    }

    @Override
    protected void parseHeaderLine(String string) {
    }
}

