/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.ClusterNode;
import cgdp.recog.hcluster.ClusterTree;
import cgdp.recog.hcluster.DistFile;
import cgdp.recog.hcluster.DistMatrix;
import cgdp.recog.hcluster.ExecClustering;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.hcluster.Nlist;
import cgdp.recog.hcluster.NodeNbrList;
import cgdp.recog.hcluster.PairDist;
import cgdp.recog.hcluster.Trinary;
import java.util.LinkedList;

public class Hcluster {
    static double cutoff;
    DistMatrix dmat;
    int order;
    static double missDist;

    public Hcluster(DistMatrix distMatrix, double d) {
        this(distMatrix, d, d / 0.95);
    }

    public Hcluster(DistMatrix distMatrix, double d, double d2) {
        this.dmat = distMatrix;
        cutoff = d;
        missDist = d2;
        PairDist.initFreeList();
    }

    public void execute() {
        PairDist pairDist;
        while (!((pairDist = this.dmat.getBestData()) == null || cutoff > 0.0 && (double)pairDist.dist > cutoff)) {
            if (pairDist.isDeleted()) {
                pairDist.declRef();
                continue;
            }
            ExecClustering.verboseMessage("** Best: " + pairDist);
            this.mergeClusters(pairDist);
        }
    }

    public void output() {
        this.output(1);
    }

    public void output(int n) {
        ClusterTree.outputCluster(n);
    }

    void mergeClusters(PairDist pairDist) {
        Nlist nlist = new Nlist(this.dmat, pairDist);
        ClusterNode clusterNode = pairDist.mergeNodes();
        LinkedList<PairDist> linkedList = new LinkedList<PairDist>();
        LinkedList<PairDist> linkedList2 = new LinkedList<PairDist>();
        while (nlist.hasNext()) {
            Trinary trinary = nlist.next();
            double d = trinary.calcDist(pairDist);
            linkedList.add(PairDist.newInstance(trinary.n3, clusterNode, d));
            if (trinary.e1 != null) {
                linkedList2.add(trinary.e1);
            }
            if (trinary.e2 == null) continue;
            linkedList2.add(trinary.e2);
        }
        for (PairDist pairDist2 : linkedList) {
            this.dmat.add(pairDist2);
        }
        for (PairDist pairDist2 : linkedList2) {
            pairDist2.delete();
        }
        this.checkDeleted(pairDist.node1);
        this.checkDeleted(pairDist.node2);
    }

    void checkDeleted(ClusterNode clusterNode) {
        NodeNbrList nodeNbrList = this.dmat.findNeighbors(clusterNode);
        nodeNbrList.checkDeleted();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: Hcluster filename");
            System.exit(0);
        }
        String string = stringArray[0];
        DistFile distFile = null;
        DistMatrix distMatrix = null;
        double d = 250.0;
        double d2 = d / 0.95;
        int n = 100;
        try {
            distFile = new DistFile(string);
        }
        catch (Exception exception) {
            System.err.println("Can't open file: " + string);
            System.exit(1);
        }
        DistMatrix.setDistCutoff(0.0, d2);
        try {
            distMatrix = distFile.readDist();
        }
        catch (HClustException hClustException) {
            // empty catch block
        }
        ClusterNode.saveLeafNum();
        distMatrix.createIndex(n);
        Hcluster hcluster = new Hcluster(distMatrix, d, d2);
        hcluster.execute();
        hcluster.output();
    }

    static {
        missDist = 250.0;
    }
}

