/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster.tree;

import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.NodeConnection;
import cgdp.recog.tree.TreeContext;
import cgdp.recog.tree.TreeRenderer;
import cgdp.recog.util.MathUtil;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class ClusterTreeRenderer
extends TreeRenderer {
    private boolean showTreeDistFromUpgma;
    private List nodeConnectionList = new ArrayList();

    public ClusterTreeRenderer(List list, TreeContext treeContext) {
        super(list, treeContext);
        this.showTreeDistFromUpgma = OptionTbl.getInstance().getOptionValues().isShowTreeDistFromUpgma();
    }

    private float adjustX(float f) {
        float f2 = f;
        if ((double)f >= this.getTreeContext().getCanvasWidth() - this.getTreeContext().getMinLeafLength()) {
            f2 = (float)(this.getTreeContext().getCanvasWidth() - this.getTreeContext().getMinLeafLength());
        }
        return f2;
    }

    @Override
    protected float drawTreeLine(Graphics2D graphics2D, Node node, float f, float f2) {
        ClusterNode clusterNode = (ClusterNode)node;
        float f3 = (float)(clusterNode.getDist() * this.getTreeContext().getScaleX());
        if (clusterNode.isLeaf()) {
            int n = clusterNode.getChildCount();
            float f4 = (float)this.getTreeContext().getLeafInterval() * (float)n;
            float f5 = f4 / 2.0f + f2 - (float)this.getTreeContext().getLeafInterval() / 2.0f;
            float f6 = (float)this.getTreeContext().getMinLeafLength();
            if (clusterNode.isDisplayTree()) {
                graphics2D.drawLine((int)this.adjustX(f + f3 - f6), (int)f2, (int)this.adjustX(f + f3 - f6), (int)(f2 + f4 - (float)this.getTreeContext().getLeafInterval()));
            }
            float f7 = f2;
            for (int i = 0; i < n; ++i) {
                if (clusterNode.isDisplayTree()) {
                    graphics2D.drawLine((int)this.adjustX(f + f3 - f6), (int)f7, (int)(f + f3), (int)f7);
                }
                f7 += (float)this.getTreeContext().getLeafInterval();
            }
            if (clusterNode.isDisplayTree()) {
                graphics2D.drawLine((int)this.adjustX(f), (int)f5, (int)this.adjustX(f + f3 - f6), (int)f5);
            }
            return f5;
        }
        Node node2 = clusterNode.getNode1();
        Node node3 = clusterNode.getNode2();
        int n = node2.getChildCount();
        float f8 = (float)this.getTreeContext().getLeafInterval() * (float)n;
        float f9 = this.drawTreeLine(graphics2D, node2, f + f3, f2);
        float f10 = this.drawTreeLine(graphics2D, node3, f + f3, f2 + f8);
        float f11 = (f9 + f10) / 2.0f;
        if (clusterNode.isDisplayTree()) {
            graphics2D.drawLine((int)this.adjustX(f), (int)f11, (int)this.adjustX(f + f3), (int)f11);
            graphics2D.drawLine((int)this.adjustX(f + f3), (int)f9, (int)this.adjustX(f + f3), (int)f10);
            if (this.showTreeDistFromUpgma) {
                String string = String.valueOf(MathUtil.roundDecimal(node2.getMaxDist(), 3));
                graphics2D.drawString(string, (int)(f + f3 + 2.0f), (int)(f11 + this.getTreeContext().getDistFontSize() / 2.0f));
            }
        }
        return f11;
    }

    public void registerNodeConnection() {
        float f;
        float f2 = 0.0f;
        float f3 = f = (float)this.getTreeContext().getLeafInterval() / 2.0f + (float)this.getTreeContext().getMarginTop();
        int n = 0;
        for (ClusterNode clusterNode : this.getRootNodeList()) {
            int n2 = clusterNode.getChildCount();
            this.registerNodeConnection(clusterNode, f2, f3);
            f3 += (float)n2 * (float)this.getTreeContext().getLeafInterval();
            n += n2;
        }
    }

    private float registerNodeConnection(Node node, float f, float f2) {
        ClusterNode clusterNode = (ClusterNode)node;
        float f3 = (float)(clusterNode.getDist() * this.getTreeContext().getScaleX());
        if (clusterNode.isLeaf()) {
            int n = clusterNode.getChildCount();
            float f4 = (float)this.getTreeContext().getLeafInterval() * (float)n;
            float f5 = f4 / 2.0f + f2 - (float)this.getTreeContext().getLeafInterval() / 2.0f;
            return f5;
        }
        Node node2 = clusterNode.getNode1();
        Node node3 = clusterNode.getNode2();
        int n = node2.getChildCount();
        float f6 = (float)this.getTreeContext().getLeafInterval() * (float)n;
        float f7 = this.registerNodeConnection(node2, f + f3, f2);
        float f8 = this.registerNodeConnection(node3, f + f3, f2 + f6);
        float f9 = (f7 + f8) / 2.0f;
        if (clusterNode.isDisplayTree()) {
            this.registerNodeConnection((int)this.adjustX(f + f3), (int)f9, clusterNode);
        }
        return f9;
    }

    private void registerNodeConnection(int n, int n2, ClusterNode clusterNode) {
        NodeConnection nodeConnection = new NodeConnection();
        nodeConnection.setTargetArea(n, n2);
        nodeConnection.setNode(clusterNode);
        this.nodeConnectionList.add(nodeConnection);
    }

    public List getNodeConnectionList() {
        return this.nodeConnectionList;
    }
}

