/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.histogram.AbstractValueRenderer;
import cgdp.recog.histogram.DescriptionFuncRenderer;
import cgdp.recog.histogram.FuncFrequencyRenderer;
import cgdp.recog.histogram.FunctionCategoryNameRenderer;
import cgdp.recog.histogram.GeneValueHistogramContext;
import cgdp.recog.histogram.GeneValueRenderer;
import cgdp.recog.histogram.HistogramContext;
import cgdp.recog.histogram.HistogramLabelItem;
import cgdp.recog.histogram.HistogramPopupItem;
import cgdp.recog.histogram.MergedFuncFrequencyRenderer;
import cgdp.recog.histogram.MultiLineRenderer;
import cgdp.recog.histogram.StackBarRenderer;
import cgdp.recog.histogram.ValueLineRenderer;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.sort.SortMenuFactory;
import cgdp.recog.system.KeyBindUtil;
import cgdp.recog.system.OS;
import cgdp.recog.util.CollectionUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CategoryMap
extends JPanel
implements MouseListener,
ActionListener {
    private MediatorImpl mediator;
    private BufferedImage image;
    private HistogramContext context;
    private int anchorRow = -1;
    private int leadRow = -1;

    public CategoryMap(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.setLayout(null);
        this.addMouseListener(this);
        this.context = new HistogramContext();
    }

    public void setMarginTop(double d) {
        this.context.setOffsetTop((int)d);
    }

    public void resizeCategoryMap(Dimension dimension) {
        OptionTbl optionTbl = OptionTbl.getInstance();
        int n = dimension.height / optionTbl.getOptionValues().getMinClusterH();
        int n2 = dimension.height + this.context.getOffsetTop();
        if (this.image == null || dimension.width != this.image.getWidth() || n2 != this.image.getHeight()) {
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.image = new BufferedImage(dimension.width, n2, 1);
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            graphics2D.dispose();
            this.context.setWidth(dimension.width);
            this.context.setHeight(n2);
        }
        int n3 = 0;
        if (this.context.isExistClusterTbl()) {
            boolean bl;
            boolean bl2 = this.mediator.isCategoryScrollBarVisible();
            if (optionTbl.getOptionValues().isIntensive()) {
                List list = this.context.getViewOrderList();
                if (list != null && list.size() > 0) {
                    if (list.size() > n) {
                        BoundedRangeModel boundedRangeModel;
                        n3 = this.mediator.isCategoryScrollBarVisible() ? ((boundedRangeModel = (BoundedRangeModel)this.mediator.getCategoryScrollBarModel()).getValue() + n > list.size() ? list.size() - n : boundedRangeModel.getValue()) : 0;
                        bl = true;
                    } else {
                        n3 = 0;
                        bl = false;
                    }
                } else {
                    n3 = 0;
                    bl = false;
                }
                this.mediator.setCategoryScrollBar(bl, n3, n, list.size());
            } else {
                List list = this.context.getViewClusterList();
                if (list.size() > 0) {
                    if (list.size() > n) {
                        BoundedRangeModel boundedRangeModel;
                        n3 = this.mediator.isCategoryScrollBarVisible() ? ((boundedRangeModel = (BoundedRangeModel)this.mediator.getCategoryScrollBarModel()).getValue() + n > list.size() ? list.size() - n : boundedRangeModel.getValue()) : 0;
                        bl = true;
                    } else {
                        n3 = 0;
                        bl = false;
                    }
                } else {
                    n3 = 0;
                    bl = false;
                }
                this.mediator.setCategoryScrollBar(bl, n3, n, list.size());
            }
            if (bl2 == bl) {
                this.context.setRowCount(n);
                this.context.setStartRow(n3);
                this.draw();
                this.repaint();
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            graphics2D.dispose();
            this.repaint();
        }
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.context.setClusterTbl(clusterTbl);
    }

    public void createCategoryMap() {
        this.createCategoryMap(this.context.getStartRow());
    }

    public void createCategoryMap(int n) {
        boolean bl;
        this.context.setStartRow(n);
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        boolean bl2 = this.mediator.isCategoryScrollBarVisible();
        OptionTbl optionTbl = OptionTbl.getInstance();
        int n2 = 0;
        if (optionTbl.getOptionValues().isIntensive()) {
            List list = this.context.getViewOrderList();
            if (list.size() > 0) {
                if (list.size() > this.context.getRowCount()) {
                    this.mediator.setCategoryScrollBar(true, n, this.context.getRowCount(), list.size());
                    bl = true;
                } else {
                    this.mediator.setCategoryScrollBar(false, n, this.context.getRowCount(), list.size());
                    bl = false;
                }
            } else {
                this.mediator.setCategoryScrollBar(false, n, this.context.getRowCount(), list.size());
                bl = false;
            }
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                List list2 = this.context.getClusterList((Map)list.get(i));
                if (n3 >= list2.size()) continue;
                n3 = list2.size();
            }
            n2 = fontMetrics.stringWidth(String.valueOf(n3)) + 10;
        } else {
            List list = this.context.getViewClusterList();
            if (list.size() > 0) {
                if (list.size() > this.context.getRowCount()) {
                    this.mediator.setCategoryScrollBar(true, n, this.context.getRowCount(), list.size());
                    bl = true;
                } else {
                    this.mediator.setCategoryScrollBar(false, n, this.context.getRowCount(), list.size());
                    bl = true;
                }
            } else {
                this.mediator.setCategoryScrollBar(false, n, this.context.getRowCount(), list.size());
                bl = true;
            }
            n2 = 0;
        }
        if (this.context.isExistHClustMergedResult()) {
            n2 = fontMetrics.stringWidth(String.valueOf(this.context.getMaxSubClusterCount())) + 10;
        }
        if (bl2 == bl) {
            this.context.setOffsetX(n2);
            this.draw();
            this.repaint();
        }
        graphics2D.dispose();
    }

    public void drawPdf(Graphics2D graphics2D) {
        List list = this.context.getViewClusterList();
        int n = list.size();
        List list2 = (List)this.mediator.getClusterMapDrawInfo();
        double d = (Double)list2.get(3);
        HistogramContext histogramContext = new HistogramContext();
        histogramContext.copyHistogramContext(this.context);
        histogramContext.setStartRow(0);
        histogramContext.setOffsetTop(0);
        histogramContext.setHeight((int)((double)n * d));
        histogramContext.setRowCount(n);
        this.draw(graphics2D, histogramContext);
        graphics2D.dispose();
    }

    public void setRow(int n) {
        this.context.setStartRow(n);
        this.draw();
        this.repaint();
    }

    public void updateSelection() {
        if (this.context.isExistSelected() && !this.context.getClusterTbl().getPpmSelectionManager().containsSelctedRange(this.context.getStartRow(), this.context.getEndRow())) {
            int n = this.context.getSelectedBaseRowIndex();
            this.mediator.setClusterVScrollBarValue(n < 0 ? 0 : n);
        }
        this.draw();
        this.repaint();
    }

    public void draw() {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        this.draw(graphics2D);
    }

    private void draw(Graphics2D graphics2D) {
        this.draw(graphics2D, this.context);
    }

    private void draw(Graphics2D graphics2D, HistogramContext histogramContext) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (optionValues.isIntensive()) {
            FuncFrequencyRenderer funcFrequencyRenderer = new FuncFrequencyRenderer();
            funcFrequencyRenderer.setContext(histogramContext);
            funcFrequencyRenderer.draw(graphics2D);
        } else if (histogramContext.isExistHClustMergedResult()) {
            MergedFuncFrequencyRenderer mergedFuncFrequencyRenderer = new MergedFuncFrequencyRenderer();
            mergedFuncFrequencyRenderer.setContext(histogramContext);
            mergedFuncFrequencyRenderer.draw(graphics2D);
        } else if (histogramContext.isDescriptionFunc()) {
            DescriptionFuncRenderer descriptionFuncRenderer = new DescriptionFuncRenderer();
            descriptionFuncRenderer.setContext(histogramContext);
            descriptionFuncRenderer.draw(graphics2D);
        } else if (histogramContext.isFuncName()) {
            FunctionCategoryNameRenderer functionCategoryNameRenderer = new FunctionCategoryNameRenderer();
            functionCategoryNameRenderer.setContext(histogramContext);
            functionCategoryNameRenderer.draw(graphics2D);
        } else if (histogramContext.isValue()) {
            GeneValueHistogramContext geneValueHistogramContext = GeneValueHistogramContext.createCondition(histogramContext.getHistogramCondition(), histogramContext);
            AbstractValueRenderer abstractValueRenderer = this.createValueRenderer();
            abstractValueRenderer.setContext(geneValueHistogramContext);
            abstractValueRenderer.draw(graphics2D);
        } else if (histogramContext.isDiff()) {
            GeneValueHistogramContext geneValueHistogramContext = GeneValueHistogramContext.createCondition(histogramContext.getHistogramCondition(), histogramContext);
            AbstractValueRenderer abstractValueRenderer = this.createValueRenderer();
            abstractValueRenderer.setContext(geneValueHistogramContext);
            abstractValueRenderer.draw(graphics2D);
        } else {
            DescriptionFuncRenderer descriptionFuncRenderer = new DescriptionFuncRenderer();
            descriptionFuncRenderer.setContext(histogramContext);
            descriptionFuncRenderer.draw(graphics2D);
        }
        graphics2D.dispose();
    }

    private AbstractValueRenderer createValueRenderer() {
        AbstractValueRenderer abstractValueRenderer = this.context.isLine() ? (this.context.isMultiOrganism() ? new MultiLineRenderer() : new ValueLineRenderer()) : (this.context.isMultiOrganism() ? new StackBarRenderer() : new GeneValueRenderer());
        return abstractValueRenderer;
    }

    private void showPopup(Point point) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        if (this.context.isExistHClustMergedResult()) {
            return;
        }
        int n = this.context.calcRowIndex(this.context.getViewOrderListSize(), point.y);
        String string = this.context.getRepresentativeOrganismCode();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
            List list = this.context.getViewClusterListInPattern(n);
            SuperCluster superCluster = new SuperCluster(list);
            JMenu jMenu = SortMenuFactory.createSortMenuForAggregate(this, this.mediator, superCluster, this.context.getViewOrganismCodeList());
            jPopupMenu.add(jMenu);
        } else {
            Cluster cluster = this.context.getViewCluster(n);
            jPopupMenu.add(new HistogramPopupItem(this, this.mediator, null, this.context.getHistogramCondition()));
            if (this.context.isValue() || this.context.isDiff()) {
                jPopupMenu.add(new HistogramLabelItem(this, this.mediator, this.context.getHistogramCondition()));
            }
            jPopupMenu.addSeparator();
            JMenu jMenu = SortMenuFactory.createSortMenuForDisaggregate(this, this.mediator, this.context.getClusterTbl(), cluster, string);
            jPopupMenu.add(jMenu);
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.afterMouseAction(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.afterMouseAction(mouseEvent);
        }
    }

    private void afterMouseAction(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
            return;
        }
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        boolean bl = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl2 = KeyBindUtil.isClickForExtendSelect(mouseEvent);
        int n = -1;
        n = OptionTbl.getInstance().getOptionValues().isIntensive() ? this.context.calcRowIndex(this.context.getViewOrderListSize(), mouseEvent.getPoint().y) : this.context.calcRowIndex(this.context.getViewClusterListSize(), mouseEvent.getPoint().y);
        if (n >= 0) {
            if (bl && bl2) {
                List list;
                if (this.anchorRow > 0) {
                    list = this.getSelectedClusters(mouseEvent, this.anchorRow, this.leadRow);
                    this.mediator.updateSelectedCluster(null, list, bl);
                }
                if (this.anchorRow < 0) {
                    this.anchorRow = n;
                }
                this.leadRow = n;
                list = this.getSelectedClusters(mouseEvent, this.anchorRow, this.leadRow);
                this.mediator.updateSelectedCluster(null, list, bl);
            } else if (bl && !bl2) {
                this.anchorRow = n;
                this.leadRow = n;
                List list = this.getSelectedClusters(mouseEvent, this.anchorRow, this.leadRow);
                this.mediator.updateSelectedCluster(null, list, bl);
            } else if (!bl && bl2) {
                if (this.anchorRow < 0) {
                    this.anchorRow = n;
                }
                this.leadRow = n;
                List list = this.getSelectedClusters(mouseEvent, this.anchorRow, this.leadRow);
                this.mediator.updateSelectedCluster(null, list, bl);
            } else {
                this.anchorRow = n;
                this.leadRow = n;
                List list = this.getSelectedClusters(mouseEvent, this.anchorRow, this.leadRow);
                this.mediator.updateSelectedCluster(null, list, bl);
            }
        }
    }

    public List getSelectedClusters(MouseEvent mouseEvent, int n, int n2) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        n3 = n3 < 0 ? n4 : n3;
        n4 = n4 < 0 ? n3 : n4;
        for (int i = n3; i <= n4; ++i) {
            ArrayList<Object> arrayList2;
            if (OptionTbl.getInstance().getOptionValues().isIntensive()) {
                arrayList2 = this.context.getViewClusterListInPattern(i);
            } else {
                Cluster cluster = this.context.getViewCluster(i);
                arrayList2 = new ArrayList<Object>();
                if (cluster != null) {
                    arrayList2.add(cluster);
                }
            }
            for (Cluster cluster : arrayList2) {
                if (arrayList.contains(cluster)) continue;
                arrayList.add(cluster);
            }
        }
        return arrayList;
    }

    private Set createSelectedClusterSetFromPattern(int n) {
        List list = this.context.getViewClusterListInPattern(n);
        HashSet hashSet = new HashSet();
        if (CollectionUtil.isNull(list)) {
            return hashSet;
        }
        hashSet.addAll(list);
        return hashSet;
    }

    private Set createSelectedClusterSet(int n) {
        Cluster cluster = this.context.getViewCluster(n);
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        if (cluster == null) {
            return hashSet;
        }
        hashSet.add(cluster);
        return hashSet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

