/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClusterInfoConfImporter
extends AbstractInfoConfImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoConfImporter.class);

    ClusterInfoConfImporter() {
        this(Const.USER_CLUSTER_INFO_PATH);
    }

    public ClusterInfoConfImporter(String string) {
        this.setFilepath(string);
    }

    @Override
    protected void parseDataLine(int n, String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        Vector vector = StringTool.splitString(string, "\t");
        ClusterInfoTitle clusterInfoTitle = new ClusterInfoTitle();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            String string3 = (String)this.columnNameList.get(i);
            this.setValue(string3, string2, clusterInfoTitle);
        }
        this.infoTitleList.add(clusterInfoTitle);
    }

    private void setValue(String string, String string2, ClusterInfoTitle clusterInfoTitle) {
        boolean bl = this.setAnalysisOptions(string, string2, clusterInfoTitle);
        if (bl) {
            return;
        }
        bl = this.setCalcOptions(string, string2, clusterInfoTitle);
        if (bl) {
            return;
        }
        if (string.equals("Name")) {
            clusterInfoTitle.setName(string2);
        } else if (string.equals("Key")) {
            clusterInfoTitle.setKey(string2);
        } else if (string.equals("Type")) {
            Map map = AbstractInfoTitle.createTypeInfo(string2);
            String string3 = (String)map.get("TypeName");
            boolean bl2 = (Boolean)map.get("Multi");
            List list = (List)map.get("ElementList");
            clusterInfoTitle.setType(InfoType.getTypeIndex(string3));
            clusterInfoTitle.setMulti(bl2);
            clusterInfoTitle.setElementList(list);
        } else if (string.equals("Category")) {
            clusterInfoTitle.setCategory(Integer.parseInt(string2));
        } else if (string.equals("Location")) {
            clusterInfoTitle.setLocationName(string2);
        } else if (string.equals("ClusterInfoType")) {
            clusterInfoTitle.setInfoType(Integer.parseInt(string2));
        } else if (string.equals("Editable")) {
            clusterInfoTitle.setEditable(new Boolean(string2));
        } else if (string.equals("NeedCache")) {
            clusterInfoTitle.setCacheNeed(new Boolean(string2));
        } else if (string.equals("SearchEqualType")) {
            clusterInfoTitle.setSearchEqualType(Integer.parseInt(string2));
        } else if (string.equals("ServerSearchEnable")) {
            clusterInfoTitle.setServerSearchEnable(new Boolean(string2));
        } else if (string.equals("DomClust ID")) {
            Vector vector = StringTool.splitString(string2, ",");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                clusterInfoTitle.addDomClustId((String)iterator.next());
            }
        }
    }
}

