/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoType;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.StringTool;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GeneInfoConfImporter
extends AbstractInfoConfImporter {
    GeneInfoConfImporter() {
        this(Const.USER_GENE_INFO_PATH);
    }

    public GeneInfoConfImporter(String string) {
        this.setFilepath(string);
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Vector vector = StringTool.splitString(string, "\t");
        GeneInfoTitle geneInfoTitle = new GeneInfoTitle();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            String string3 = (String)this.columnNameList.get(i);
            this.setValue(string3, string2, geneInfoTitle);
        }
        this.infoTitleList.add(geneInfoTitle);
    }

    private void setValue(String string, String string2, GeneInfoTitle geneInfoTitle) {
        boolean bl = this.setCalcOptions(string, string2, geneInfoTitle);
        if (bl) {
            return;
        }
        if (string.equals("Name")) {
            geneInfoTitle.setName(string2);
        } else if (string.equals("Key")) {
            geneInfoTitle.setKey(string2);
        } else if (string.equals("Type")) {
            Map map = AbstractInfoTitle.createTypeInfo(string2);
            String string3 = (String)map.get("TypeName");
            boolean bl2 = (Boolean)map.get("Multi");
            List list = (List)map.get("ElementList");
            geneInfoTitle.setType(InfoType.getTypeIndex(string3));
            geneInfoTitle.setMulti(bl2);
            geneInfoTitle.setElementList(list);
        } else if (string.equals("Category")) {
            geneInfoTitle.setCategory(Integer.parseInt(string2));
        } else if (string.equals("Location")) {
            geneInfoTitle.setLocationName(string2);
        } else if (string.equals("Editable")) {
            geneInfoTitle.setEditable(new Boolean(string2));
        } else if (string.equals("SearchEqualType")) {
            geneInfoTitle.setSearchEqualType(Integer.parseInt(string2));
        } else if (string.equals("ServerSearchEnable")) {
            geneInfoTitle.setServerSearchEnable(new Boolean(string2));
        } else if (string.equals("Organism")) {
            Vector vector = StringTool.splitString(string2, ",");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                geneInfoTitle.addOrganismCode((String)iterator.next());
            }
        }
    }
}

