/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.ContigTbl;
import cgdp.recog.mapping.MapCondition;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapExecuter;
import cgdp.recog.mapping.MapFacade;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.mapping.MappingUtil;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultMapCreater {
    private static final ApplicationLogger logger = new ApplicationLogger(DefaultMapCreater.class);
    private Set organismCodeSet;
    private List baseMapRecodeList;
    private Map chromosomeMap;
    private Map contigMap;
    private boolean saveChrId = false;

    public DefaultMapCreater() {
    }

    public DefaultMapCreater(Set set) {
        this.organismCodeSet = set;
    }

    public void execute() {
        try {
            Set set = new HashSet(this.organismCodeSet);
            set = ApplicationPropertyFacade.retainIncompleteOrganismSet(set);
            if (CollectionUtil.isNull(set)) {
                return;
            }
            List list = MapFacade.getMapConfList();
            HashSet hashSet = new HashSet();
            set.removeAll(hashSet);
            if (CollectionUtil.isNull(set)) {
                return;
            }
            System.err.println("**OK" + set);
            Project project = ProjectAccesser.getSelectedProject();
            MappingUtil.createDataDirectory(project);
            for (String string : set) {
                Object object;
                System.err.println("org=" + string);
                List list2 = this.getMapRecodeList(string);
                try {
                    MapConf mapConf = this.createMapConf(string);
                    object = MapFacade.createContigGapGroupMap(list2, string);
                    MapCondition mapCondition = new MapCondition();
                    mapCondition.setMapConf(mapConf);
                    mapCondition.setContigGapGroupMap((Map)object);
                    MapExecuter mapExecuter = new MapExecuter(mapCondition);
                    mapExecuter.execute(new DummyProgressComponent());
                }
                catch (Exception exception) {
                    object = "Fail to save the mapping information. " + string;
                    logger.warn((String)object, exception);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to save the default mapping information.", exception);
        }
    }

    private MapConf createMapConf(String string) {
        MapConf mapConf = new MapConf();
        mapConf.setFilename(DefaultMapCreater.getMapFilename(string));
        mapConf.setName("Default Mapping[" + string + "]");
        mapConf.setFilename(string);
        mapConf.setOrganismCode(string);
        mapConf.setSelected(true);
        mapConf.setDefaultMap(true);
        return mapConf;
    }

    public List getMapRecodeList(String string) throws Exception {
        Object object;
        if (this.getChromosomeMap() == null) {
            object = new ChromosomeTbl(string);
            ((ChromosomeTbl)object).readServerOnly();
            this.setChromosomeMap(this.chromosomeMap);
        }
        if (this.checkNewContigMap(string)) {
            object = new ContigTbl(string);
            ((ContigTbl)object).read();
            this.setContigMap((Map)object);
        }
        if (this.getBaseMapRecodeList() == null) {
            this.setBaseMapRecodeList(MapFacade.getDefaultMapRecodeList(string));
        }
        object = MapFacade.getContigIdSetFromMapRecode(this.getBaseMapRecodeList());
        List list = MapFacade.createMapRecodeFromContig(this.getContigMap().values(), (Set)object);
        ArrayList arrayList = new ArrayList(this.getBaseMapRecodeList());
        System.err.println("#no_mapping_list_size=" + list.size());
        arrayList.addAll(list);
        System.err.println("#map_recode_list_size=" + arrayList.size());
        this.setDirection(arrayList);
        Map map = this.createChrIdMapRecodeMap(arrayList);
        this.setChromosomeForNoMappingContigMapRecode(map, this.getChromosomeMap(), string);
        this.adjustMapRecode(map);
        ArrayList arrayList2 = new ArrayList(map.keySet());
        Collections.sort(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        for (Object e : arrayList2) {
            List list2 = (List)map.get(e);
            arrayList3.addAll(list2);
        }
        return arrayList3;
    }

    private String getNewChromosomeName(Collection collection, Map map) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Chromosome chromosome;
            int n = (Integer)iterator.next();
            if (MapRecode.isNoValue(n) || (chromosome = (Chromosome)map.get(new Integer(n))) == null) continue;
            hashSet.add(chromosome.getName());
        }
        int n = 1;
        while (hashSet.contains(String.valueOf(n))) {
            ++n;
        }
        return String.valueOf(n);
    }

    private String getNewSeqNo(Collection collection, Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Chromosome chromosome;
            int n = (Integer)iterator.next();
            if (MapRecode.isNoValue(n) || (chromosome = (Chromosome)map.get(new Integer(n))) == null) continue;
            hashSet.add(chromosome.getSeqNo());
        }
        int n = 1;
        while (hashSet.contains(String.valueOf(n))) {
            ++n;
        }
        return String.valueOf(n);
    }

    private Chromosome createChromosome(int n, String string, String string2, String string3) {
        Chromosome chromosome = new Chromosome();
        chromosome.setId(n);
        chromosome.setName(string);
        chromosome.setShape("linear");
        chromosome.setOrganismCode(string3);
        chromosome.setType("chromosome");
        chromosome.setSeqNo(string2);
        return chromosome;
    }

    private Map createChrIdMapRecodeMap(List list) {
        HashMap<Integer, ArrayList<MapRecode>> hashMap = new HashMap<Integer, ArrayList<MapRecode>>();
        for (MapRecode mapRecode : list) {
            int n = mapRecode.getChrId();
            ArrayList<MapRecode> arrayList = (ArrayList<MapRecode>)hashMap.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<MapRecode>();
                hashMap.put(new Integer(n), arrayList);
            }
            arrayList.add(mapRecode);
        }
        return hashMap;
    }

    private void setDirection(List list) {
        for (MapRecode mapRecode : list) {
            if (!mapRecode.isContig() || !mapRecode.isNoDirection()) continue;
            mapRecode.setDirection((short)1);
        }
    }

    private void setChromosomeForNoMappingContigMapRecode(Map map, Map map2, String string) throws Exception {
        List list = (List)map.get(new Integer(Integer.MIN_VALUE));
        if (!CollectionUtil.isNull(list)) {
            int n = MapFacade.getBaseChromId();
            String string2 = this.getNewChromosomeName(map.keySet(), map2);
            String string3 = this.getNewSeqNo(map.keySet(), map2);
            Chromosome chromosome = this.createChromosome(n, string2, string3, string);
            for (MapRecode mapRecode : list) {
                mapRecode.setChromosome(chromosome);
                mapRecode.setSeqNo(string3);
            }
            map.remove(new Integer(Integer.MIN_VALUE));
            map.put(new Integer(n), list);
            if (this.isSaveChrId()) {
                MapFacade.saveBaseChromId(n - 1);
            }
        }
    }

    private void adjustMapRecode(Map map) {
        for (Object k : map.keySet()) {
            List list = (List)map.get(k);
            this.adjustMapRecodeOrder(list);
            list = this.adjustGap(list);
            this.setOrderNo(list);
            map.put(k, list);
        }
    }

    private void adjustMapRecodeOrder(List list) {
        ArrayList<MapRecode> arrayList = new ArrayList<MapRecode>();
        for (MapRecode mapRecode : list) {
            if (!mapRecode.isNoOrderNo()) continue;
            arrayList.add(mapRecode);
        }
        list.removeAll(arrayList);
        list.addAll(arrayList);
    }

    private List adjustGap(List list) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<MapRecode> arrayList = new ArrayList<MapRecode>();
        MapRecode mapRecode = (MapRecode)list.get(0);
        boolean bl = mapRecode.isGap();
        if (!bl) {
            arrayList.add(this.createGapMapRecode(mapRecode.getChromosome()));
        }
        arrayList.add(mapRecode);
        for (int i = 1; i < list.size(); ++i) {
            MapRecode mapRecode2 = (MapRecode)list.get(i);
            if (bl && mapRecode2.isContig()) {
                arrayList.add(mapRecode2);
            } else if (!bl && mapRecode2.isGap()) {
                arrayList.add(mapRecode2);
            } else if (!bl && mapRecode2.isContig()) {
                arrayList.add(this.createGapMapRecode(mapRecode2.getChromosome()));
                arrayList.add(mapRecode2);
            }
            bl = mapRecode2.isGap();
        }
        if (!bl) {
            MapRecode mapRecode3 = (MapRecode)arrayList.get(arrayList.size() - 1);
            arrayList.add(this.createGapMapRecode(mapRecode3.getChromosome()));
        }
        return arrayList;
    }

    private MapRecode createGapMapRecode(Chromosome chromosome) {
        MapRecode mapRecode = new MapRecode();
        mapRecode.setChromosome(chromosome);
        mapRecode.setSeqNo(chromosome.getSeqNo());
        mapRecode.setType(2);
        return mapRecode;
    }

    private void setOrderNo(List list) {
        int n = 1;
        for (MapRecode mapRecode : list) {
            mapRecode.setOrderNo(n);
            ++n;
        }
    }

    public void setContigMap(Map map) {
        this.contigMap = map;
    }

    private Map getContigMap() {
        return this.contigMap;
    }

    private boolean checkNewContigMap(String string) {
        return this.contigMap == null || ((ContigTbl)this.contigMap).getOrganismCode() != string;
    }

    public void setChromosomeMap(Map map) {
        this.chromosomeMap = map;
    }

    private Map getChromosomeMap() {
        return this.chromosomeMap;
    }

    public void setBaseMapRecodeList(List list) {
        this.baseMapRecodeList = list;
    }

    public List getBaseMapRecodeList() {
        return this.baseMapRecodeList;
    }

    public void setSaveChrId(boolean bl) {
        this.saveChrId = bl;
    }

    private boolean isSaveChrId() {
        return this.saveChrId;
    }

    public static String getMapFilename(String string) {
        return string + ".dat";
    }

    public static void main(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("OP1");
        DefaultMapCreater defaultMapCreater = new DefaultMapCreater(hashSet);
        defaultMapCreater.execute();
    }
}

