/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.Contig;
import cgdp.recog.data.ContigTbl;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class MapImporter
extends FileImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(MapImporter.class);
    private static final String COLUMN_SP = "sp";
    private static final String COLUMN_CHRID = "chrid";
    private static final String COLUMN_CONTIGID = "contigid";
    private static final String COLUMN_SEQNO = "seqno";
    private static final String COLUMN_ORDERNO = "ordno";
    private static final String COLUMN_FROM = "from1";
    private static final String COLUMN_TO = "to1";
    private static final String COLUMN_DIR = "dir";
    private static final String DELIMITER = "\t";
    private String filepath;
    private String organismCode;
    private List columnNameList = new ArrayList();
    private List mapRecodeList = new ArrayList();
    private Map contigMap;
    private Map chromosomeMap;

    public MapImporter(String string, String string2) {
        this.filepath = string2;
        this.organismCode = string;
    }

    @Override
    protected void beforeProcess() {
        String string;
        TreeMap treeMap;
        if (this.contigMap == null) {
            try {
                treeMap = new ContigTbl(this.organismCode);
                ((ContigTbl)treeMap).read();
                System.err.println("READ CONTIG TBL HASH");
                this.contigMap = treeMap;
            }
            catch (Exception exception) {
                string = "Fail to load contig file. " + this.organismCode;
                logger.warn(string, exception);
                this.contigMap = new HashMap();
            }
        }
        if (this.chromosomeMap == null) {
            try {
                treeMap = new ChromosomeTbl(this.organismCode);
                ((ChromosomeTbl)treeMap).readAll();
                this.chromosomeMap = treeMap;
            }
            catch (Exception exception) {
                string = "Fail to load chromosome file. " + this.organismCode;
                logger.warn(string, exception);
                this.chromosomeMap = new HashMap();
            }
        }
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        MapRecode mapRecode = new MapRecode();
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            String string2 = (String)vector.get(i);
            String string3 = (String)this.columnNameList.get(i);
            this.setValue(string3, string2, mapRecode);
        }
        if (mapRecode.getChromosome() == null && mapRecode.getContig() == null) {
            mapRecode.setGap();
        }
        this.mapRecodeList.add(mapRecode);
    }

    private void setValue(String string, String string2, MapRecode mapRecode) {
        if (string.equals(COLUMN_SP)) {
            mapRecode.setOrganismCode(string2);
        } else if (string.equals(COLUMN_CHRID)) {
            if (!StringTool.isNull(string2)) {
                int n = Integer.parseInt(string2);
                Chromosome chromosome = (Chromosome)this.chromosomeMap.get(String.valueOf(n));
                mapRecode.setChromosome(chromosome);
            }
        } else if (string.equals(COLUMN_CONTIGID)) {
            if (!StringTool.isNull(string2)) {
                int n = Integer.parseInt(string2);
                Contig contig = (Contig)this.contigMap.get(String.valueOf(n));
                mapRecode.setContig(contig);
            } else {
                mapRecode.setType(2);
            }
        } else if (string.equals(COLUMN_SEQNO)) {
            if (!StringTool.isNull(string2)) {
                mapRecode.setSeqNo(string2);
            }
        } else if (string.equals(COLUMN_ORDERNO)) {
            if (!StringTool.isNull(string2)) {
                mapRecode.setOrderNo(Integer.parseInt(string2));
            }
        } else if (string.equals(COLUMN_FROM)) {
            if (!StringTool.isNull(string2)) {
                mapRecode.setFrom(Integer.parseInt(string2));
            }
        } else if (string.equals(COLUMN_TO)) {
            if (!StringTool.isNull(string2)) {
                mapRecode.setTo(Integer.parseInt(string2));
            }
        } else if (string.equals(COLUMN_DIR) && !StringTool.isNull(string2)) {
            mapRecode.setDirection(Short.parseShort(string2));
        }
    }

    @Override
    protected void parseHeaderLine(String string) {
        this.columnNameList = new ArrayList(StringTool.splitString(string, DELIMITER));
    }

    public List getMapRecodeList() {
        return this.mapRecodeList;
    }

    public void setChromosomeMap(Map map) {
        this.chromosomeMap = map;
    }

    public void setContigMap(Map map) {
        this.contigMap = map;
    }
}

