/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.menu;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class ClusterModeItem
extends JMenuItem
implements CommandImpl {
    private MediatorImpl mediator;

    public ClusterModeItem(ActionListener actionListener, MediatorImpl mediatorImpl) {
        this.changeMode();
        this.setEnabled(false);
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.mediator.register(this);
    }

    @Override
    public void execute() {
        this.mediator.setClusterMode(!this.isClusterMode());
    }

    public void changeMode() {
        this.setText(this.getLabelText());
        this.changeIcon();
    }

    private String getLabelText() {
        return this.isClusterMode() ? "Cluster Mode" : "Sub Cluster Mode";
    }

    private void changeIcon() {
        try {
            if (this.isClusterMode()) {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/base_cluster.png")));
            } else {
                this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/base_subcluster.png")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isClusterMode() {
        return OptionTbl.getInstance().getOptionValues().isClusterMode();
    }
}

