/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.neighbor;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NeighboringClustExecuter {
    private static final ApplicationLogger logger = new ApplicationLogger(NeighboringClustExecuter.class);
    private static final String[] GENE_FIELDS = new String[]{"name", "chrid", "from1", "to1"};
    private final Set geneFieldSet = new HashSet();
    private NeighboringClustCondition condition;
    private List organismCodeList;
    private List clusterList;
    private Map geneInfoGroupIdMap = new HashMap();
    private Map groupIdGeneInfoMap = new HashMap();

    public NeighboringClustExecuter(NeighboringClustCondition neighboringClustCondition, List list, List list2) {
        this.condition = neighboringClustCondition;
        this.clusterList = new ArrayList(list);
        this.organismCodeList = new ArrayList(list2);
        for (int i = 0; i < GENE_FIELDS.length; ++i) {
            this.geneFieldSet.add(GENE_FIELDS[i]);
        }
    }

    public static void reexecuteNeighborClustering(Component component, boolean bl, NeighboringClustCondition neighboringClustCondition, MediatorImpl mediatorImpl) {
        if (!bl) {
            return;
        }
        ColorDrawable colorDrawable = ColorFacade.getInstance().getNeighboringClusterColorDrawable();
        if (neighboringClustCondition.isRecalc()) {
            if (colorDrawable.isColorActive()) {
                mediatorImpl.executeNeighboringCluster(neighboringClustCondition, true);
            } else {
                neighboringClustCondition.setNeededRecalc(true);
            }
        } else {
            mediatorImpl.clearNeighboringCluster();
        }
    }

    public void execute(ProgressImpl progressImpl) throws Exception {
        int n = 0;
        for (String string : this.organismCodeList) {
            if (ApplicationPropertyFacade.isMetagenomeOnlyOrganismCode(string)) continue;
            try {
                n = this.searchNeigborGene(string, n);
            }
            catch (Exception exception) {
                String string2 = "Fail to be clustering by neighborhood cluster. " + string;
                logger.warn(string2, exception);
            }
            progressImpl.increment();
        }
    }

    private int searchNeigborGene(String string, int n) throws Exception {
        ChromosomeTbl chromosomeTbl = new ChromosomeTbl(string);
        chromosomeTbl.read();
        GeneTbl geneTbl = new GeneTbl(string);
        geneTbl.read(this.geneFieldSet);
        int n2 = this.clusterList.size() > this.condition.getSearchClusterCount() + 1 ? this.condition.getSearchClusterCount() + 1 : this.clusterList.size();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.clusterList.subList(1, n2));
        int n3 = 0;
        for (Cluster cluster : this.clusterList) {
            int n4;
            List list = cluster.getGeneInformationList(string);
            if (list != null && !list.isEmpty()) {
                for (GeneInformation geneInformation : list) {
                    Set set = this.searchNeigborGene(string, arrayList, geneInformation, chromosomeTbl, geneTbl, n);
                    if (set == null) {
                        System.err.println("NULL:NULL");
                    }
                    if (set.size() <= 1) continue;
                    int n5 = this.getRegisteredGroupId(set);
                    if (n5 == -1) {
                        n5 = n++;
                    }
                    for (GeneInformation geneInformation2 : set) {
                        this.geneInfoGroupIdMap.put(geneInformation2, new Integer(n5));
                        ArrayList<GeneInformation> arrayList2 = (ArrayList<GeneInformation>)this.groupIdGeneInfoMap.get(new Integer(n5));
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<GeneInformation>();
                            this.groupIdGeneInfoMap.put(new Integer(n5), arrayList2);
                        }
                        arrayList2.add(geneInformation2);
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                arrayList.remove(0);
            }
            if ((n4 = n3 + this.condition.getSearchClusterCount() + 1) < this.clusterList.size()) {
                arrayList.add(this.clusterList.get(n3 + this.condition.getSearchClusterCount() + 1));
            }
            ++n3;
        }
        return n;
    }

    private Set searchNeigborGene(String string, List list, GeneInformation geneInformation, ChromosomeTbl chromosomeTbl, GeneTbl geneTbl, int n) {
        Gene gene = (Gene)geneTbl.get(geneInformation.getLocusTagWithoutDomain());
        int n2 = gene.getChromId();
        int n3 = gene.getStart();
        int n4 = gene.getEnd();
        Chromosome chromosome = (Chromosome)chromosomeTbl.get(String.valueOf(n2));
        if (chromosome == null) {
            return null;
        }
        int n5 = chromosome.getLength();
        double d = GeneUtil.calcGenePosition(n3, n4, n5, chromosome.isCircular());
        HashSet<GeneInformation> hashSet = new HashSet<GeneInformation>();
        for (Cluster cluster : list) {
            List list2 = cluster.getGeneInformationList(string);
            if (list2 == null || list2.isEmpty()) continue;
            for (GeneInformation geneInformation2 : list2) {
                double d2;
                if (geneInformation2.getLocusTag().equals(geneInformation.getLocusTag())) continue;
                Gene gene2 = (Gene)geneTbl.get(geneInformation2.getLocusTagWithoutDomain());
                int n6 = gene2.getChromId();
                int n7 = gene2.getStart();
                int n8 = gene2.getEnd();
                Chromosome chromosome2 = (Chromosome)chromosomeTbl.get(String.valueOf(n6));
                int n9 = chromosome2.getLength();
                double d3 = GeneUtil.calcGenePosition(n7, n8, n9, chromosome2.isCircular());
                if (n6 != n2 || !((d2 = GeneUtil.diffGenePosition(d3, d, chromosome2.getLength(), chromosome2.isCircular())) <= (double)this.condition.getMaxDistSameGroup())) continue;
                hashSet.add(geneInformation);
                hashSet.add(geneInformation2);
            }
        }
        return hashSet;
    }

    private int getRegisteredGroupId(Set set) {
        HashMap<Integer, Serializable> hashMap = new HashMap<Integer, Serializable>();
        for (GeneInformation geneInformation : set) {
            if (!this.geneInfoGroupIdMap.containsKey(geneInformation)) continue;
            int n = (Integer)this.geneInfoGroupIdMap.get(geneInformation);
            Serializable serializable = (ArrayList<GeneInformation>)hashMap.get(new Integer(n));
            if (serializable == null) {
                serializable = new ArrayList<GeneInformation>();
                hashMap.put(new Integer(n), serializable);
            }
            serializable.add(geneInformation);
        }
        if (hashMap.size() == 0) {
            return -1;
        }
        if (hashMap.size() == 1) {
            return (Integer)hashMap.keySet().iterator().next();
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        int n = (Integer)arrayList.get(0);
        for (Serializable serializable : hashMap.keySet()) {
            if (n == (Integer)serializable) continue;
            List list = (List)this.groupIdGeneInfoMap.get(serializable);
            for (GeneInformation geneInformation : list) {
                this.geneInfoGroupIdMap.put(geneInformation, new Integer(n));
            }
            List list2 = (List)this.groupIdGeneInfoMap.get(new Integer(n));
            list2.addAll(list);
        }
        return n;
    }

    public Map getGeneInfoGroupIdMap() {
        return this.geneInfoGroupIdMap;
    }
}

