/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ppm;

import cgdp.recog.active.OrganismColumnActivationHolder;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterMenuFactory;
import cgdp.recog.organism.DisplayOrganism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.ppm.OrgainsmSelectSyncItem;
import cgdp.recog.ppm.OrganismColumnDeleteItem;
import cgdp.recog.ppm.OrganismColumnEditItem;
import cgdp.recog.ppm.OrganismColumnMultiEnableItem;
import cgdp.recog.ppm.OrganismColumnRestoreItem;
import cgdp.recog.ppm.OrganismTreeNode;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.OrganismColorMenu;
import cgdp.recog.tree.TreeController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OrganismColumnTreeController
implements TreeController,
ActionListener {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public OrganismColumnTreeController(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.clusterTbl == null) {
            return;
        }
        for (DisplayOrganism displayOrganism : this.clusterTbl.getShowControlOrganismList()) {
            OrganismTreeNode organismTreeNode = new OrganismTreeNode(displayOrganism, this.clusterTbl.isOutgroup(displayOrganism));
            defaultMutableTreeNode.add(organismTreeNode);
        }
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowTitleMenu(treePathArray)) {
            this.createTitleMenu(jPopupMenu, actionListener, treePathArray);
        }
        if (this.isShowOrganismMenu(treePathArray)) {
            this.createOrganismMenu(jPopupMenu, actionListener, treePathArray);
        }
        return jPopupMenu;
    }

    private boolean isShowTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isOrganismColumn(controlTitleNode.getControlTitleType());
    }

    private boolean isShowOrganismMenu(TreePath[] treePathArray) {
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i].getPathCount() != 3) {
                return false;
            }
            TreePath treePath = treePathArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
            if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
                return false;
            }
            ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
            if (!ControlTitleType.isOrganismColumn(controlTitleNode.getControlTitleType())) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
            if (defaultMutableTreeNode2 instanceof OrganismTreeNode) continue;
            return false;
        }
        return true;
    }

    private void createTitleMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[0].getLastPathComponent();
        if (mutableTreeNode instanceof ControlTitleNode && ControlTitleType.isOrganismColumn(((ControlTitleNode)mutableTreeNode).getControlTitleType())) {
            ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
            Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                OrganismTreeNode organismTreeNode = (OrganismTreeNode)enumeration.nextElement();
                arrayList.add(organismTreeNode.getDisplayOrganism());
            }
            jPopupMenu.add(new OrganismColumnEditItem(actionListener, this.mediator));
            jPopupMenu.add(new OrganismColumnRestoreItem(actionListener, this.mediator));
            jPopupMenu.add(new OrgainsmSelectSyncItem(actionListener, this.mediator, this.clusterTbl.isSyncOrganismSelect()));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new OrganismColumnMultiEnableItem(actionListener, this.mediator, arrayList, 1));
            jPopupMenu.add(new OrganismColumnMultiEnableItem(actionListener, this.mediator, arrayList, 2));
        }
    }

    private void createOrganismMenu(JPopupMenu jPopupMenu, ActionListener actionListener, TreePath[] treePathArray) {
        if (this.clusterTbl == null) {
            return;
        }
        Set set = this.getOrganismCodeSet(treePathArray);
        String string = "";
        Map map = OrganismUtil.createOrganismNameMap(set);
        FilterMenuFactory.createTaxonomyMenu(this, this.mediator, this.clusterTbl, string, set, map, jPopupMenu);
        jPopupMenu.add(new OrganismColorMenu(actionListener, this.mediator, set));
        jPopupMenu.addSeparator();
        List list = this.getDisplayOrganismList(treePathArray);
        jPopupMenu.add(new OrganismColumnEditItem(actionListener, this.mediator));
        jPopupMenu.add(new OrganismColumnRestoreItem(actionListener, this.mediator));
        jPopupMenu.add(new OrgainsmSelectSyncItem(actionListener, this.mediator, this.clusterTbl.isSyncOrganismSelect()));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new OrganismColumnMultiEnableItem(actionListener, this.mediator, list, 1));
        jPopupMenu.add(new OrganismColumnMultiEnableItem(actionListener, this.mediator, list, 2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new OrganismColumnDeleteItem(actionListener, this.mediator, set));
    }

    private List getDisplayOrganismList(TreePath[] treePathArray) {
        ArrayList<DisplayOrganism> arrayList = new ArrayList<DisplayOrganism>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)defaultMutableTreeNode;
            arrayList.add(organismTreeNode.getDisplayOrganism());
        }
        return arrayList;
    }

    private Set getOrganismCodeSet(TreePath[] treePathArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)defaultMutableTreeNode;
            hashSet.add(organismTreeNode.getDisplayOrganism().getOrganismCode());
        }
        return hashSet;
    }

    public void setSelectOrganismColumn(JTree jTree, ControlTitleNode controlTitleNode, Set set) {
        if (this.clusterTbl == null) {
            return;
        }
        jTree.clearSelection();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            OrganismTreeNode organismTreeNode = (OrganismTreeNode)enumeration.nextElement();
            if (!set.contains(organismTreeNode.getOrganismCode())) continue;
            TreePath treePath = new TreePath(defaultTreeModel.getPathToRoot(organismTreeNode));
            jTree.addSelectionPath(treePath);
        }
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void actionAfterClick(List list) {
        Cloneable cloneable;
        if (list.size() == 1 && !((cloneable = (DefaultMutableTreeNode)list.get(0)) instanceof OrganismTreeNode)) {
            return;
        }
        cloneable = new HashSet();
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (!(defaultMutableTreeNode instanceof OrganismTreeNode)) continue;
            cloneable.add(((OrganismTreeNode)defaultMutableTreeNode).getOrganismCode());
        }
        this.mediator.setSelectedOrganism((Set)((Object)cloneable), this);
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode instanceof OrganismColumnActivationHolder && defaultMutableTreeNode.isLeaf()) {
            OrganismColumnActivationHolder organismColumnActivationHolder = (OrganismColumnActivationHolder)((Object)defaultMutableTreeNode);
            this.mediator.activeOrganismColumn(organismColumnActivationHolder.getOrganismColumnActivation());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

