/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.search.AbstractSearchCondition;
import cgdp.recog.search.SearchConditionItem;
import cgdp.recog.search.SearchJoinType;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneSearchCondition
extends AbstractSearchCondition {
    private Set organismCodeSet = new HashSet();
    private List conditionItemList = new ArrayList();

    public GeneSearchCondition() {
        super(2);
    }

    public Set getOrganismCodeSet() {
        return this.organismCodeSet;
    }

    public void setOrganismCodeSet(Set set) {
        this.organismCodeSet = set;
    }

    public List getConditionItemList() {
        return this.conditionItemList;
    }

    public void setConditionItemList(List list) {
        this.conditionItemList = list;
    }

    @Override
    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Gene:");
        int n = 0;
        for (SearchConditionItem searchConditionItem : this.conditionItemList) {
            if (n != 0) {
                String string = SearchJoinType.getNameByType(searchConditionItem.getJoinKey());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            stringBuffer.append(searchConditionItem.getInfoTitle().getName());
            stringBuffer.append(" ");
            stringBuffer.append(searchConditionItem.getValue());
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean containsInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        for (SearchConditionItem searchConditionItem : this.conditionItemList) {
            if (!searchConditionItem.getInfoTitle().equals(abstractInfoTitle)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistCondition() {
        return !CollectionUtil.isNull(this.conditionItemList);
    }
}

