/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.seq;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.seq.SeqDownloadCondition;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.SimpleServerConnection;

public class SeqDownloader
extends SimpleServerConnection {
    private SeqDownloadCondition condition;
    private StringBuffer sb = new StringBuffer();

    public SeqDownloader(SeqDownloadCondition seqDownloadCondition) {
        this.condition = seqDownloadCondition;
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getSeqDownloadURL());
        this.setOptions();
    }

    private void setOptions() {
        String string = this.condition.isEachGene() ? this.getOptionsForEachGene() : this.getOptionsForEachCluster();
        this.setOptions(string);
    }

    private String getOptionsForEachCluster() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getseq=Get&seqtype=");
        stringBuffer.append(this.condition.getSeqType());
        stringBuffer.append("&up=");
        stringBuffer.append(this.condition.getUpstream());
        stringBuffer.append("&down=");
        stringBuffer.append(this.condition.getDownstream());
        stringBuffer.append("&clustid=");
        stringBuffer.append(this.condition.getClusterIdString());
        stringBuffer.append("&tabid=");
        stringBuffer.append(this.condition.getDomClustId());
        if (this.condition.isSpecDel()) {
            stringBuffer.append("&delimiter=");
            stringBuffer.append(this.condition.getDelStr());
        }
        return stringBuffer.toString();
    }

    private String getOptionsForEachGene() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("getseq=Get&seqtype=");
        stringBuffer.append(this.condition.getSeqType());
        stringBuffer.append("&up=");
        stringBuffer.append(this.condition.getUpstream());
        stringBuffer.append("&down=");
        stringBuffer.append(this.condition.getDownstream());
        stringBuffer.append("&orfs=");
        stringBuffer.append(this.condition.getOrganismLocusTagString());
        if (this.condition.isSpecDel()) {
            stringBuffer.append("&delimiter=");
            stringBuffer.append(this.condition.getDelStr());
        }
        return stringBuffer.toString();
    }

    @Override
    public void parseOutputString(int n, String string) {
        this.sb.append(string);
        this.sb.append(FileUtil.LINE_SEPARETOR);
    }

    public String getContents() {
        return this.sb.toString();
    }
}

