/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.SimpleServerConnection;

public class ServerAccessCheckTask
extends SimpleServerConnection
implements Runnable {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerAccessCheckTask.class);
    private static final ServerAccessCheckTask SERVERACCESSCHECKTASK = new ServerAccessCheckTask();
    private String serverUrl;

    private ServerAccessCheckTask() {
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getSysInfoURL());
    }

    @Override
    protected String createUrl() {
        if (!this.serverUrl.endsWith("/")) {
            this.serverUrl = this.serverUrl + "/";
        }
        return this.serverUrl + this.getContextPath();
    }

    public static ServerAccessCheckTask getInstance() {
        return new ServerAccessCheckTask();
    }

    @Override
    public void parseOutputString(int n, String string) {
    }

    public void checkAccessServer(String string) {
        this.serverUrl = string;
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public void run() {
        AccessServer accessServer = AccessServer.getInstance();
        accessServer.setEnableAccess(true);
        try {
            this.execute();
            if (this.isError()) {
                accessServer.setEnableAccess(false);
            } else {
                accessServer.setEnableAccess(true);
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to access server.", exception);
            accessServer.setEnableAccess(false);
        }
    }
}

