/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.server.Server;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.server.ServerUtil;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

public class ServerEditDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Server Setting";
    private Server server;
    private FocusTextField urlPortTextField;

    public ServerEditDialog(Frame frame) {
        super(frame);
        this.server = new Server();
        this.createComponents();
        this.updateTitle(true);
    }

    ServerEditDialog(Dialog dialog, Server server, boolean bl) {
        super(dialog);
        this.server = server;
        this.createComponents();
        this.updateTitle(bl);
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Server:");
        this.urlPortTextField = new FocusTextField();
        this.urlPortTextField.setColumns(30);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.urlPortTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateTitle(boolean bl) {
        if (bl) {
            this.setTitle("New Server");
        } else {
            this.setTitle("Edit Server");
        }
    }

    private void updateValue() {
        this.urlPortTextField.setText(this.server.getUrl());
    }

    String getUrlPort() {
        return ServerUtil.modifyServerUrl(this.urlPortTextField.getText());
    }

    public Server getModifiedServer() {
        this.server.setUrl(this.getUrlPort());
        return this.server;
    }

    @Override
    protected boolean check() {
        String string = this.getUrlPort();
        if (StringTool.isNull(string)) {
            MessageManager.showErrorMessage((Component)this, "Please input [Server].");
            return false;
        }
        ServerTbl serverTbl = ServerTbl.getInstance();
        if (serverTbl.containsServer(string)) {
            MessageManager.showErrorMessage((Component)this, "Server[" + string + "] already exists.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        return true;
    }
}

