/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.AbstractSetUploader;
import cgdp.recog.util.AbstractServerConnection;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SimpleServerConnection;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetUploadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(SetUploadExecuter.class);
    private Component parent;
    private Project project;
    private Collection setC;
    private boolean execDone = true;
    private Set unableUploadSetSet = new HashSet();

    public SetUploadExecuter(Component component, Collection collection, Project project) {
        this.parent = component;
        this.project = project;
        this.setC = collection;
    }

    public void setExecDone(boolean bl) {
        this.execDone = bl;
    }

    public Set getUnableUploadSetSet() {
        return this.unableUploadSetSet;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(this.setC.size());
            Iterator iterator = this.setC.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
                abstractElementSet.updateElementList();
                try {
                    AbstractSetUploader abstractSetUploader = AbstractSetUploader.createInstance(abstractElementSet, "", this.project);
                    abstractSetUploader.execute();
                    if (abstractSetUploader.isErrorAlreadyExist()) {
                        if (!MessageManager.showConfirmMessage(this.parent, "Overwrite [" + abstractElementSet.getName() + "] ?")) {
                            object = "Fail to upload set. name=" + abstractElementSet.getName();
                            this.setError(abstractElementSet, (String)object);
                        }
                        object = AbstractSetUploader.createInstance(abstractElementSet, "replace", this.project);
                        ((SimpleServerConnection)object).execute();
                        if (!((AbstractServerConnection)object).isError()) continue;
                        this.setError(abstractElementSet, ((AbstractServerConnection)object).getMessage());
                        continue;
                    }
                    if (!abstractSetUploader.isError()) continue;
                    this.setError(abstractElementSet, abstractSetUploader.getMessage());
                }
                catch (Exception exception) {
                    object = "Fail to upload set. name=" + abstractElementSet.getName();
                    this.setError(abstractElementSet, (String)object);
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to upload set.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void setError(AbstractElementSet abstractElementSet, String string) {
        String string2 = "Fail to upload set. set=" + abstractElementSet.getName();
        logger.warn(string2);
        this.unableUploadSetSet.add(abstractElementSet);
    }

    @Override
    public void done() {
        if (!this.execDone) {
            return;
        }
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!CollectionUtil.isNull(this.unableUploadSetSet)) {
            Set set = this.getUnableUploadSetSet();
            String string = AbstractElementSetFacade.createElementSetNameString(set);
            String[] stringArray = new String[]{"The following set was not able to be uploaded.", string};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }
}

