/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClusterSetDownloader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetDownloader.class);
    private ClusterTbl clusterTbl;
    private ClusterSet clusterSet;
    private List clusterList = new ArrayList();
    private Set clusterIdSet = new HashSet();

    ClusterSetDownloader(ClusterSet clusterSet, ClusterTbl clusterTbl, Project project) throws UnsupportedEncodingException {
        this.setProject(project);
        this.clusterSet = clusterSet;
        this.clusterTbl = clusterTbl;
        this.setContextPath(URLList.getInstance().getGetClusterSet());
        this.setOptions();
    }

    @Override
    public void parseOutputStringData(int n, String string) {
        if (string.indexOf("ID") != -1) {
            return;
        }
        String string2 = string;
        this.clusterIdSet.add(string2);
    }

    @Override
    protected void after() {
        super.after();
        this.clusterList = new ArrayList(this.clusterTbl.getClusterListRegardSubCluster(this.clusterIdSet));
        Collections.sort(this.clusterList, new ClusterComparator(6));
    }

    private void setOptions() throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tabid=");
        stringBuffer.append(this.clusterTbl.getClusterId());
        stringBuffer.append("&set_name=");
        stringBuffer.append(Codec.encode(this.clusterSet.getName()));
        this.setOptions(stringBuffer.toString());
    }

    public List getClusterList() {
        return this.clusterList;
    }
}

