/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.access.FileAccessExecuter;
import cgdp.recog.access.FileAccessExecuterFactory;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.DataManager;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerUtil;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetConfExporter;
import cgdp.recog.set.cluster.ClusterSetConfImporter;
import cgdp.recog.set.cluster.ClusterSetEditDialog;
import cgdp.recog.set.cluster.ClusterSetIOException;
import cgdp.recog.set.cluster.ClusterSetImporter;
import cgdp.recog.set.cluster.ClusterSetListDonwloader;
import cgdp.recog.set.cluster.ClusterSetListExporter;
import cgdp.recog.set.cluster.ClusterSetListImporter;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MathUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterSetFacade
extends AbstractElementSetFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetFacade.class);
    private static final ClusterSetFacade CLUSTER_SET_FACADE = new ClusterSetFacade();

    private ClusterSetFacade() {
    }

    public static ClusterSetFacade getInstance() {
        return CLUSTER_SET_FACADE;
    }

    public static List getClusterListFromUserFile(String string, ClusterTbl clusterTbl) throws IOException {
        ClusterSetImporter clusterSetImporter = new ClusterSetImporter(string, clusterTbl);
        clusterSetImporter.execute();
        if (clusterSetImporter.isError()) {
            throw new ClusterSetIOException(clusterSetImporter.getErrorMessage());
        }
        return clusterSetImporter.getClusterList();
    }

    @Override
    public List getElementSetList() {
        try {
            ClusterSetConfImporter clusterSetConfImporter = new ClusterSetConfImporter();
            clusterSetConfImporter.execute();
            return clusterSetConfImporter.getClusterSetList();
        }
        catch (Exception exception) {
            logger.warn("Fail to load cluster set conf file.", exception);
            return new ArrayList();
        }
    }

    public List getClusterSetListCurrentProject() {
        Project project = ProjectAccesser.getSelectedProject();
        return this.getClusterSetList(project);
    }

    public List getClusterSetList(Project project) {
        List list = this.getElementSetList();
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        for (ClusterSet clusterSet : list) {
            if (!clusterSet.equalsLocation(project.getProjectName())) continue;
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    public List getClusterSetListCurrentDomClust(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        List list = this.getElementSetList();
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        for (ClusterSet clusterSet : list) {
            if (!clusterSet.equalsLocation(project.getProjectName()) || !clusterSet.equalsDomClustId(string)) continue;
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    @Override
    protected void exportConfFile(List list) throws Exception {
        ClusterSetConfExporter clusterSetConfExporter = new ClusterSetConfExporter(list);
        clusterSetConfExporter.execute();
    }

    @Override
    protected void exportListFile(AbstractElementSet abstractElementSet, List list) throws Exception {
        ClusterSetFacade.createClusterSetDirectory(abstractElementSet.getLocation(), ((ClusterSet)abstractElementSet).getDomClustId());
        ClusterSetListExporter clusterSetListExporter = new ClusterSetListExporter(abstractElementSet.getFilepath(), list);
        clusterSetListExporter.execute();
    }

    static void createClusterSetDirectory(String string, String string2) {
        Project project = ProjectAccesser.getProject(string);
        String string3 = DataManager.getClusterSetDirpath(project, string2);
        FileUtil.createDirectory(string3);
    }

    public static void createClusterSet(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl) throws Exception {
        if (clusterTbl == null) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        FileAccessExecuter fileAccessExecuter = FileAccessExecuterFactory.createClusterSetImportExecuterForProject(frame, mediatorImpl, project.getProjectName(), clusterTbl);
        fileAccessExecuter.execute();
    }

    public void editClusterSet(MediatorImpl mediatorImpl, ClusterSet clusterSet, ClusterTbl clusterTbl) throws Exception {
        Object object;
        if (!clusterSet.isExistElement()) {
            object = this.importElementList(clusterSet);
            clusterSet.setElementList((List)object);
        }
        object = ClusterSetEditDialog.getInstance();
        ((ClusterSetEditDialog)object).updateValue(clusterSet, clusterTbl);
        ((Dialog)object).setVisible(true);
        if (((AbstractApplyDialog)object).isCanceled()) {
            return;
        }
        ClusterSet clusterSet2 = ((ClusterSetEditDialog)object).createClusterSet();
        ClusterSet clusterSet3 = null;
        List list = this.getElementSetList();
        HashSet<ClusterSet> hashSet = new HashSet<ClusterSet>();
        for (ClusterSet clusterSet4 : list) {
            if (clusterSet4.equalsElement(clusterSet)) {
                clusterSet3 = clusterSet4;
            }
            if (clusterSet2.equalsElement(clusterSet) || !clusterSet4.equalsElement(clusterSet2)) continue;
            hashSet.add(clusterSet4);
        }
        if (clusterSet2.isExistElement()) {
            clusterSet3.copy(clusterSet2);
            clusterSet3.setStatus(clusterSet2.getStatus());
            list.removeAll(hashSet);
            this.exportConfFile(list);
            if (clusterSet3.isEditList()) {
                ClusterSetFacade.removeListFile(clusterSet);
                this.exportListFile(clusterSet3, clusterSet3.getElementList());
            }
            ClusterSetFacade.removeListFile(hashSet);
        } else {
            hashSet.add(clusterSet3);
            list.removeAll(hashSet);
            this.exportConfFile(list);
            ClusterSetFacade.removeListFile(hashSet);
        }
        mediatorImpl.updateClusterSetTree();
    }

    @Override
    public List importElementList(AbstractElementSet abstractElementSet) {
        try {
            ClusterSetListImporter clusterSetListImporter = new ClusterSetListImporter(abstractElementSet.getFilepath());
            clusterSetListImporter.execute();
            return clusterSetListImporter.getClusterList();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    public List importElementList(AbstractElementSet abstractElementSet, boolean bl) {
        try {
            ClusterSetListImporter clusterSetListImporter = new ClusterSetListImporter(abstractElementSet.getFilepath());
            clusterSetListImporter.setLoadLocusTag(bl);
            clusterSetListImporter.execute();
            return clusterSetListImporter.getClusterList();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    @Override
    protected Set getKeySet(Collection collection) {
        return ClusterUtil.getClusterIdSet(collection);
    }

    @Override
    protected void updateSetTree(MediatorImpl mediatorImpl) {
        mediatorImpl.updateClusterSetTree();
    }

    public static List eliminateDuplicateElement(List list) {
        LinkedHashMap<String, Cluster> linkedHashMap = new LinkedHashMap<String, Cluster>();
        for (Cluster cluster : list) {
            String string = cluster.getKey();
            linkedHashMap.put(string, cluster);
        }
        return new ArrayList(linkedHashMap.values());
    }

    public static Map createSetBitsInfoMap(List list, Map map) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("SCVennBitPattern");
        HashMap<String, ClusterInfo> hashMap = new HashMap<String, ClusterInfo>();
        for (ElementSetGroup elementSetGroup : map.keySet()) {
            List list2 = (List)map.get(elementSetGroup);
            BitSet bitSet = ClusterSetFacade.createBitSet(list, elementSetGroup);
            String string = MathUtil.getBitSetString(list.size(), bitSet);
            for (Cluster cluster : list2) {
                String string2 = cluster.getKey();
                ClusterInfo clusterInfo = new ClusterInfo();
                clusterInfo.putInfo(clusterInfoTitle, string);
                hashMap.put(string2, clusterInfo);
            }
        }
        return hashMap;
    }

    public static Set getClusterSetIncludeCluster(Collection collection) {
        List list = ClusterSetFacade.getInstance().getClusterSetListCurrentProject();
        HashSet<ClusterSet> hashSet = new HashSet<ClusterSet>();
        for (ClusterSet clusterSet : list) {
            clusterSet.updateElementList();
            if (!clusterSet.containsAtLeast(collection)) continue;
            hashSet.add(clusterSet);
        }
        return hashSet;
    }

    public static List downloadClusterSetList(ClusterTbl clusterTbl, Project project) throws Exception {
        if (clusterTbl == null) {
            return new ArrayList();
        }
        String string = clusterTbl.getClusterId();
        ClusterSetListDonwloader clusterSetListDonwloader = new ClusterSetListDonwloader(string, project);
        clusterSetListDonwloader.execute();
        List list = clusterSetListDonwloader.getClusterSetList();
        List list2 = ClusterSetFacade.getElementSetList(2, clusterTbl.getClusterId());
        for (ClusterSet clusterSet : list) {
            ClusterSet clusterSet2 = (ClusterSet)ClusterSetFacade.getSameElementSet(clusterSet, list2);
            if (clusterSet2 != null) {
                clusterSet.setId(clusterSet2.getId());
                clusterSet.setListFilename(clusterSet2.getListFilename());
            }
            clusterSet.setDomClustId(string);
            clusterSet.setDomClustViewId(clusterTbl.getClusterViewId());
            clusterSet.setDomClustFilename(clusterTbl.getDomClustName());
        }
        return list;
    }

    public static List filterClusterSetListByServer(Collection collection) throws IOException {
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        for (ClusterSet clusterSet : collection) {
            String string = clusterSet.getDomClustFilename();
            Project project = ProjectAccesser.getProject(clusterSet.getLocation());
            String string2 = DomClustFileUtil.createDomClustFilepath(project, string);
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string2);
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            String string3 = abstractDomClustImporter.getExecServer();
            int n = abstractDomClustImporter.getExecPort();
            String string4 = ServerUtil.combineUrlPort(string3, n);
            if (!AccessServer.getInstance().equalsServerUrl(string4)) continue;
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    public static List convertServerToLocalSet(List list) {
        Project project = ProjectAccesser.getSelectedProject();
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        for (ClusterSet clusterSet : list) {
            ClusterSet clusterSet2 = new ClusterSet();
            clusterSet2.copy(clusterSet);
            clusterSet2.setId(clusterSet.getId());
            clusterSet2.setLocation(project.getProjectName());
            arrayList.add(clusterSet2);
        }
        return arrayList;
    }

    public static Map createNameElementSetMap() {
        List list = ClusterSetFacade.getInstance().getElementSetList();
        HashMap<String, AbstractElementSet> hashMap = new HashMap<String, AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : list) {
            hashMap.put(abstractElementSet.getName(), abstractElementSet);
        }
        return hashMap;
    }

    public void renameDomClustFileName(File file, File file2, Project project) throws Exception {
        this.renameDomClustFileName(FileUtil.removeExtension(file.getName()), FileUtil.removeExtension(file2.getName()), project);
    }

    public void renameDomClustFileName(String string, String string2, Project project) throws Exception {
        boolean bl = false;
        List list = ClusterSetFacade.getInstance().getClusterSetList(project);
        for (int i = 0; i < list.size(); ++i) {
            ClusterSet clusterSet;
            if (list.get(i) == null || (clusterSet = (ClusterSet)list.get(i)).getDomClustFilename().compareToIgnoreCase(string) != 0) continue;
            clusterSet.setDomClustFilename(string2);
            logger.info("core_set:" + clusterSet.getId() + " " + clusterSet.getName() + " " + clusterSet.getDomClustFilename() + " was rennamed to" + string2 + ".");
            bl = true;
        }
        if (bl) {
            ClusterSetFacade.getInstance().exportConfFile(list);
        }
    }

    public void deleteByDomClustFileName(File file, Project project) throws Exception {
        this.deleteByDomClustFileName(FileUtil.removeExtension(file.getName()), project);
    }

    public void deleteByDomClustFileName(String string, Project project) throws Exception {
        boolean bl = false;
        List list = ClusterSetFacade.getInstance().getClusterSetList(project);
        for (int i = 0; i < list.size(); ++i) {
            ClusterSet clusterSet;
            if (list.get(i) == null || (clusterSet = (ClusterSet)list.get(i)).getDomClustFilename().compareToIgnoreCase(string) != 0) continue;
            list.remove(i);
            bl = true;
            logger.info("core_set:" + clusterSet.getId() + " " + clusterSet.getName() + " was removed.");
        }
        if (bl) {
            ClusterSetFacade.getInstance().exportConfFile(list);
        }
    }

    public void deleteByDomClustId(String string, Project project) throws Exception {
        boolean bl = false;
        List list = ClusterSetFacade.getInstance().getClusterSetList(project);
        for (int i = 0; i < list.size(); ++i) {
            ClusterSet clusterSet;
            if (list.get(i) == null || (clusterSet = (ClusterSet)list.get(i)).getDomClustId().compareToIgnoreCase(string) != 0) continue;
            list.remove(i);
            bl = true;
            logger.info("core_set:" + clusterSet.getId() + " " + clusterSet.getName() + " " + clusterSet.getDomClustId() + " was removed.");
        }
        if (bl) {
            ClusterSetFacade.getInstance().exportConfFile(list);
        }
    }
}

