/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterFileAccessHelper;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class ClusterSetListImporter
extends FileImporter {
    private static final String DELIMITER = "\t";
    private String filepath;
    private List clusterList = new ArrayList();
    private boolean loadLocusTag = false;

    ClusterSetListImporter(String string) {
        this.filepath = string;
        this.setExistHeader(false);
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Vector vector = StringTool.splitString(string, DELIMITER);
        Cluster cluster = new Cluster();
        cluster.setClusterId(Integer.parseInt(String.valueOf(vector.get(0))));
        int n2 = Integer.parseInt(String.valueOf(vector.get(1)));
        if (n2 != -1) {
            cluster.setSubClusterId(n2);
        }
        if (this.isLoadLocusTag() && vector.size() > 2) {
            Map map = ClusterFileAccessHelper.createOrganismCodeLocusTagMap(vector.subList(2, vector.size()));
            for (String string2 : map.keySet()) {
                List list = (List)map.get(string2);
                cluster.addLocusTagMap(string2, list);
            }
        }
        this.clusterList.add(cluster);
    }

    @Override
    protected void parseHeaderLine(String string) {
    }

    public List getClusterList() {
        return this.clusterList;
    }

    public void setLoadLocusTag(boolean bl) {
        this.loadLocusTag = bl;
    }

    private boolean isLoadLocusTag() {
        return this.loadLocusTag;
    }
}

