/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JMenuItem;

class GeneInfoDeleteItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoDeleteItem.class);
    private Component parent;
    private MediatorImpl mediator;
    private GeneSet geneSet;
    private Collection removeGeneInfoC;

    GeneInfoDeleteItem(ActionListener actionListener, Component component, MediatorImpl mediatorImpl, GeneSet geneSet, Collection collection) {
        super("Delete gene");
        this.parent = component;
        this.mediator = mediatorImpl;
        this.geneSet = geneSet;
        this.removeGeneInfoC = collection;
        this.addActionListener(actionListener);
    }

    @Override
    public void execute() {
        try {
            if (MessageManager.showConfirmMessage(this.parent, "Delete genes?")) {
                GeneSetFacade.getInstance().deleteElementListFromSet(this.mediator, this.geneSet, this.removeGeneInfoC);
            }
        }
        catch (Exception exception) {
            String string = "Fail to delete gene info.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }
}

