/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.SetCombinationControlButtonPanel;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.SetConditionUtil;
import cgdp.recog.set.SetConditionValidateCondition;
import cgdp.recog.set.SetConditionValidater;
import cgdp.recog.set.SetFilterColorActionPanel;
import cgdp.recog.set.venn.VennFigurePanel;
import cgdp.recog.set.venn.VennModel;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class VennTabPanel
extends TabPanel {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private SetConditionGroup setConditionGroup;
    private VennModel vennModel;
    private VennFigurePanel vennPanel;
    private FocusTextField nameTextField;
    private SetCombinationControlButtonPanel setCombinationControlButtonPanel;
    private SetFilterColorActionPanel setFilterColorActionPanel;
    private SetCondition setCondition;

    public VennTabPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.vennModel = new VennModel();
        this.createComponents();
    }

    private void createComponents() {
        this.vennPanel = new VennFigurePanel(this.parent, this.mediator, this.vennModel);
        JScrollPane jScrollPane = new JScrollPane(this.vennPanel, 21, 31);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        this.setFilterColorActionPanel = new SetFilterColorActionPanel();
        this.setFilterColorActionPanel.setBorder(BorderFactory.createTitledBorder("Filter/Color setting"));
        this.setCombinationControlButtonPanel = new SetCombinationControlButtonPanel(this.parent, this.mediator, this.vennModel);
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 5), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 10, 15), 0, 0));
        this.add((Component)this.setFilterColorActionPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 10, 15), 0, 0));
        this.add((Component)this.setCombinationControlButtonPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
    }

    public void updateValue(List list, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        this.setConditionGroup = setConditionGroup;
        this.clusterTbl = clusterTbl;
        this.vennModel.initElementSetList(list);
        this.vennModel.setEnableShow(true);
        this.vennPanel.updateValue(clusterTbl);
        this.nameTextField.setText(SetConditionUtil.getDefaultName(this.vennModel.getSetType(), setConditionGroup));
        this.setFilterColorActionPanel.updateValue(1, true);
        this.setCombinationControlButtonPanel.updateValue(clusterTbl);
    }

    public void updateValue(SetCondition setCondition, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        this.setConditionGroup = setConditionGroup;
        this.clusterTbl = clusterTbl;
        this.setCondition = setCondition;
        this.vennModel.updateBySetCondition(setCondition);
        this.vennModel.setEnableShow(true);
        this.vennPanel.updateValue(clusterTbl);
        this.nameTextField.setText(setCondition.getName());
        this.setFilterColorActionPanel.updateValue(1, false);
        this.setCombinationControlButtonPanel.updateValue(clusterTbl);
    }

    public void updateValue(SetCondition setCondition, boolean bl, boolean bl2) {
        this.setCondition = setCondition;
        this.vennModel.updateBySetCondition(setCondition);
        this.vennModel.setEnableShow(true);
        this.vennPanel.updateValue(this.clusterTbl);
        this.nameTextField.setText(setCondition.getName());
        this.setFilterColorActionPanel.updateValue(SetCondition.getFilterColorAction(bl, bl2), false);
        this.setCombinationControlButtonPanel.updateValue(this.clusterTbl);
    }

    public void removeAllColor() {
        this.vennModel.removeAllColor();
    }

    public void setEnableShow(boolean bl) {
        this.vennModel.setEnableShow(bl);
    }

    public boolean isEnableShow() {
        return this.vennModel.isEnableShow();
    }

    private String getConditionName() {
        return this.nameTextField.getText();
    }

    public SetCondition createSetCondition() {
        return this.vennModel.createSetCondition(this.getConditionName());
    }

    public boolean isAddColor() {
        return this.setFilterColorActionPanel.isAddColor();
    }

    public boolean isAddFilter() {
        return this.setFilterColorActionPanel.isAddFilter();
    }

    @Override
    protected void changeDefault() {
    }

    @Override
    public boolean check() {
        SetConditionValidater setConditionValidater = new SetConditionValidater();
        SetConditionValidateCondition setConditionValidateCondition = new SetConditionValidateCondition();
        setConditionValidateCondition.setParent(this);
        setConditionValidateCondition.setName(this.getConditionName());
        if (this.setCondition != null) {
            setConditionValidateCondition.setPreName(this.setCondition.getName());
        }
        setConditionValidateCondition.setSetConditionGroup(this.setConditionGroup);
        setConditionValidateCondition.setSetType(this.vennModel.getSetType());
        setConditionValidateCondition.setTargetElementSetGroupList(this.vennModel.getPositiveElementSetGroupList());
        return setConditionValidater.validate(setConditionValidateCondition);
    }

    @Override
    protected void updateParameters() {
    }
}

