/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.system.property;

import cgdp.recog.color.geneinfo.GeneColorConditionGroup;
import cgdp.recog.color.geneinfo.GeneColorFacade;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoFacade;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyComparator;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyConfExporter;
import cgdp.recog.system.property.ApplicationPropertyConfImporter;
import cgdp.recog.system.property.ApplicationPropertyExporter;
import cgdp.recog.system.property.ApplicationPropertyImporter;
import cgdp.recog.system.property.ApplicationPropertyUtil;
import cgdp.recog.system.property.ApplicationPropertyVirtualFile;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApplicationPropertyFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(ApplicationPropertyFacade.class);

    private ApplicationPropertyFacade() {
    }

    public static String getPropertyFilepath(Project project, String string) {
        return ApplicationPropertyFacade.getPropertyDirectory(project, string) + "app_property";
    }

    public static String getPropertyFilepath(String string) {
        return new File(string, "app_property").getAbsolutePath();
    }

    public static String getPropertyDirectory(Project project, String string) {
        if (!StringTool.isNull(string)) {
            return project.getDirectoryPath() + File.separator + string + File.separator;
        }
        return project.getDirectoryPath() + File.separator;
    }

    public static void updateAccessable(ApplicationPropertyAccessable applicationPropertyAccessable) {
        Project project = ProjectAccesser.getSelectedProject();
        ApplicationPropertyFacade.updateAccessable(project, null, applicationPropertyAccessable);
    }

    public static void updateAccessable(List list) {
        Project project = ProjectAccesser.getSelectedProject();
        ApplicationPropertyFacade.updateAccessable(project, null, list);
    }

    public static void updateDomClustAccessable(String string, ApplicationPropertyAccessable applicationPropertyAccessable) {
        Project project = ProjectAccesser.getSelectedProject();
        ApplicationPropertyFacade.updateAccessable(project, string, applicationPropertyAccessable);
    }

    public static void updateDomClustAccessable(String string, List list) {
        Project project = ProjectAccesser.getSelectedProject();
        ApplicationPropertyFacade.updateAccessable(project, string, list);
    }

    private static void updateAccessable(Project project, String string, ApplicationPropertyAccessable applicationPropertyAccessable) {
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.add(applicationPropertyAccessable);
        ApplicationPropertyFacade.updateAccessable(project, string, arrayList);
    }

    private static void updateAccessable(Project project, String string, List list) {
        try {
            Map map = ApplicationPropertyFacade.getCategoryPropertyMap(project, string);
            for (ApplicationPropertyAccessable applicationPropertyAccessable : list) {
                if (applicationPropertyAccessable == null) {
                    logger.warn("Application property is null. " + string);
                }
                String string2 = applicationPropertyAccessable.getCategory();
                Map map2 = (Map)map.get(applicationPropertyAccessable.getCategory());
                map2 = StringTool.isNull(string2) ? ApplicationPropertyFacade.createKeyMap(map) : (Map)map.get(applicationPropertyAccessable.getCategory());
                if (MapUtil.isNull(map2) && string2 != "ColorGeneInfo") {
                    System.err.println("SKIP: ACC_CATEGORY=" + string2);
                    continue;
                }
                applicationPropertyAccessable.updateProperty(map2, project, string);
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to update project property. Project=" + project.getProjectName() + " DomClustID = " + string, iOException);
        }
    }

    public static void updateAccessable(String string, Project project, String string2, List list) throws IOException {
        ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(string);
        applicationPropertyImporter.execute();
        List list2 = applicationPropertyImporter.getProjectPropertyList();
        Map map = ApplicationPropertyFacade.createCategorKeyPropertyMap(list2);
        ApplicationPropertyFacade.updateAccessable(map, project, string2, list);
    }

    private static void updateAccessable(Map map, Project project, String string, List list) {
        for (ApplicationPropertyAccessable applicationPropertyAccessable : list) {
            if (applicationPropertyAccessable == null) {
                logger.warn("Application property is null. " + string);
            }
            String string2 = applicationPropertyAccessable.getCategory();
            Map map2 = (Map)map.get(applicationPropertyAccessable.getCategory());
            map2 = StringTool.isNull(string2) ? ApplicationPropertyFacade.createKeyMap(map) : (Map)map.get(applicationPropertyAccessable.getCategory());
            if (MapUtil.isNull(map2)) continue;
            System.err.println("+++ *******" + applicationPropertyAccessable + " " + applicationPropertyAccessable.getCategory() + " " + string + " " + string2 + " " + map2);
            applicationPropertyAccessable.updateProperty(map2, project, string);
        }
    }

    private static Map createKeyMap(Map map) {
        HashMap hashMap = new HashMap();
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    private static void createProjectPropertyFile(Project project, String string) throws IOException {
        String string2 = ApplicationPropertyFacade.getPropertyFilepath(project, string);
        ApplicationPropertyFacade.createProjectPropertyFile(string2);
    }

    private static void createProjectPropertyFile(String string) throws IOException {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        if (!file.isFile()) {
            file.createNewFile();
        }
    }

    public static Map getKeyPropertyMap(Project project, String string, String string2) throws IOException {
        ApplicationPropertyFacade.createProjectPropertyFile(project, string);
        ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(project, string);
        applicationPropertyImporter.execute();
        List list = applicationPropertyImporter.getProjectPropertyList();
        Map map = ApplicationPropertyFacade.createCategorPropertyMap(list);
        List list2 = (List)map.get(string2);
        Map map2 = ApplicationPropertyFacade.createKeyPropertyMap(list2);
        return map2;
    }

    public static Map getCategoryPropertyMap(Project project, String string) throws IOException {
        ApplicationPropertyFacade.createProjectPropertyFile(project, string);
        ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(project, string);
        applicationPropertyImporter.execute();
        List list = applicationPropertyImporter.getProjectPropertyList();
        return ApplicationPropertyFacade.createCategorKeyPropertyMap(list);
    }

    public static Map getCategoryPropertyMap(String string) throws IOException {
        ApplicationPropertyFacade.createProjectPropertyFile(string);
        ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(string);
        applicationPropertyImporter.execute();
        List list = applicationPropertyImporter.getProjectPropertyList();
        return ApplicationPropertyFacade.createCategorKeyPropertyMap(list);
    }

    public static void saveProperty(ApplicationPropertyAccessable applicationPropertyAccessable) throws IOException {
        ApplicationPropertyFacade.saveProperty(null, applicationPropertyAccessable);
    }

    public static void saveProperty(String string, ApplicationPropertyAccessable applicationPropertyAccessable) throws IOException {
        if (applicationPropertyAccessable == null) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.add(applicationPropertyAccessable);
        ApplicationPropertyFacade.saveProperty(project, string, arrayList);
    }

    public static void saveProperty(String string, List list) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        ApplicationPropertyFacade.saveProperty(project, string, list);
    }

    private static void saveProperty(Project project, String string, List list) throws IOException {
        List list2;
        Object object2;
        ApplicationPropertyFacade.createProjectPropertyFile(project, string);
        ArrayList arrayList = new ArrayList();
        for (Object object2 : list) {
            list2 = object2.getPropertyList(project, string);
            if (CollectionUtil.isNull(list2)) continue;
            arrayList.addAll(list2);
        }
        ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(project, string);
        applicationPropertyImporter.execute();
        object2 = applicationPropertyImporter.getProjectPropertyList();
        list2 = ApplicationPropertyFacade.margeProjectProprety((List)object2, arrayList);
        ApplicationPropertyExporter applicationPropertyExporter = new ApplicationPropertyExporter(project, string, list2);
        applicationPropertyExporter.execute();
    }

    public static void savePropertyFile(String string, List list) throws IOException {
        ApplicationPropertyExporter applicationPropertyExporter = new ApplicationPropertyExporter(string, list);
        applicationPropertyExporter.execute();
    }

    private static List margeProjectProprety(List list, List list2) {
        HashSet hashSet = new HashSet(list2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = ApplicationPropertyFacade.createCategorPropertyMap(list2);
        for (Object object : list) {
            ApplicationProperty applicationProperty = ApplicationPropertyFacade.findProjectProperty(((ApplicationProperty)object).getCategory(), ((ApplicationProperty)object).getKey(), map);
            if (applicationProperty == null) {
                arrayList.add(object);
                continue;
            }
            if (applicationProperty.getValue() != null) {
                arrayList.add(applicationProperty);
            }
            hashSet.remove(applicationProperty);
        }
        HashSet hashSet2 = new HashSet();
        for (ApplicationProperty applicationProperty : hashSet) {
            if (applicationProperty.getValue() != null) continue;
            hashSet2.add(applicationProperty);
        }
        hashSet.removeAll(hashSet2);
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, new ApplicationPropertyComparator());
        return arrayList;
    }

    private static Map createCategorKeyPropertyMap(List list) {
        HashMap<String, HashMap<String, String>> hashMap = new HashMap<String, HashMap<String, String>>();
        for (ApplicationProperty applicationProperty : list) {
            HashMap<String, String> hashMap2 = (HashMap<String, String>)hashMap.get(applicationProperty.getCategory());
            if (MapUtil.isNull(hashMap2)) {
                hashMap2 = new HashMap<String, String>();
                hashMap.put(applicationProperty.getCategory(), hashMap2);
            }
            hashMap2.put(applicationProperty.getKey(), applicationProperty.getValue());
        }
        return hashMap;
    }

    private static Map createCategorPropertyMap(List list) {
        HashMap<String, ArrayList<ApplicationProperty>> hashMap = new HashMap<String, ArrayList<ApplicationProperty>>();
        for (ApplicationProperty applicationProperty : list) {
            ArrayList<ApplicationProperty> arrayList = (ArrayList<ApplicationProperty>)hashMap.get(applicationProperty.getCategory());
            if (CollectionUtil.isNull(arrayList)) {
                arrayList = new ArrayList<ApplicationProperty>();
                hashMap.put(applicationProperty.getCategory(), arrayList);
            }
            arrayList.add(applicationProperty);
        }
        return hashMap;
    }

    public static Map createKeyPropertyMap(List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (CollectionUtil.isNull(list)) {
            return hashMap;
        }
        for (ApplicationProperty applicationProperty : list) {
            hashMap.put(applicationProperty.getKey(), applicationProperty.getValue());
        }
        return hashMap;
    }

    private static ApplicationProperty findProjectProperty(String string, String string2, Map map) {
        ApplicationProperty applicationProperty = null;
        List list = (List)map.get(string);
        if (CollectionUtil.isNull(list)) {
            return applicationProperty;
        }
        for (ApplicationProperty applicationProperty2 : list) {
            if (!applicationProperty2.equalsKey(string2)) continue;
            applicationProperty = applicationProperty2;
            break;
        }
        return applicationProperty;
    }

    private static List importGenomeParam() {
        try {
            String string = DataManager.getGenomeParamDat();
            ApplicationPropertyImporter applicationPropertyImporter = new ApplicationPropertyImporter(string);
            applicationPropertyImporter.execute();
            return applicationPropertyImporter.getProjectPropertyList();
        }
        catch (IOException iOException) {
            logger.warn("Fail to load genome_param.dat.", iOException);
            return new ArrayList();
        }
    }

    private static ApplicationProperty getGenomeProperty(String string) {
        List list = ApplicationPropertyFacade.importGenomeParam();
        for (ApplicationProperty applicationProperty : list) {
            if (!applicationProperty.equalsKey(string)) continue;
            return applicationProperty;
        }
        return null;
    }

    private static boolean isMetagenomeOrganismCode(String string) {
        if (ModifiedOrganismManager.getInstance().isModifiledOrganismCode(string)) {
            List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
            for (String string2 : list) {
                if (!ApplicationPropertyFacade.getMetagenomeOrganismCodeSet().contains(string2)) continue;
                return true;
            }
            return false;
        }
        return ApplicationPropertyFacade.getMetagenomeOrganismCodeSet().contains(string);
    }

    public static boolean isMetagenomeOnlyOrganismCode(String string) {
        return ApplicationPropertyFacade.isMetagenomeOrganismCode(string) && !ApplicationPropertyFacade.isIncompleteOrganismCode(string);
    }

    public static Set getMetagenomeOrganismCodeSet() {
        return ApplicationPropertyFacade.getValueSet("species_metagenome");
    }

    public static List getMetagenomeOrganismList(Collection collection) {
        ArrayList<Organism> arrayList = new ArrayList<Organism>();
        for (Organism organism : collection) {
            if (!ApplicationPropertyFacade.isMetagenomeOrganismCode(organism.getOrganismCode())) continue;
            arrayList.add(organism);
        }
        return arrayList;
    }

    public static Set getIncompleteOrganismCodeSet() {
        return ApplicationPropertyFacade.getValueSet("species_incomplete");
    }

    public static List getIncompleteOrganismList() {
        Set set = ApplicationPropertyFacade.getIncompleteOrganismCodeSet();
        List list = OrganismUtil.getOrganismList(new ArrayList(set));
        return list;
    }

    public static List retainIncompleteOrganismList(List list) {
        List list2 = ModifiedOrganismManager.getInstance().convertSystemOrganismCodeList(list);
        Set set = ApplicationPropertyFacade.getIncompleteOrganismCodeSet();
        list2.retainAll(set);
        return list2;
    }

    public static Set retainIncompleteOrganismSet(Set set) {
        HashSet hashSet = new HashSet(ModifiedOrganismManager.getInstance().convertSystemOrganismCodeList(set));
        Set set2 = ApplicationPropertyFacade.getIncompleteOrganismCodeSet();
        hashSet.retainAll(set2);
        return hashSet;
    }

    public static boolean isIncompleteOrganismCode(String string) {
        if (ModifiedOrganismManager.getInstance().isModifiledOrganismCode(string)) {
            List list = ModifiedOrganismManager.getInstance().getSystemOrganismCodeList(string);
            for (String string2 : list) {
                if (!ApplicationPropertyFacade.getIncompleteOrganismCodeSet().contains(string2)) continue;
                return true;
            }
            return false;
        }
        return ApplicationPropertyFacade.getIncompleteOrganismCodeSet().contains(string);
    }

    public static Set getValueSet(String string) {
        ApplicationProperty applicationProperty = ApplicationPropertyFacade.getGenomeProperty(string);
        if (applicationProperty == null) {
            return new HashSet();
        }
        return new HashSet(applicationProperty.getValueList());
    }

    public static String getApplicationPropertyConfFilepath(Project project) {
        return project.getDirectoryPath() + File.separator + "app_prop_conf" + File.separator;
    }

    public static String getApplicationPropertyDirpath(Project project, ApplicationPropertyConf applicationPropertyConf) {
        return project.getDirectoryPath() + File.separator + applicationPropertyConf.getDomClustId() + File.separator + applicationPropertyConf.getConfDirname() + File.separator;
    }

    public static String getApplicationPropertyDefaultDirpath(Project project, String string) {
        return project.getDirectoryPath() + File.separator + string + File.separator + "default" + File.separator;
    }

    public static void saveConfList(Project project, List list) {
        try {
            String string = ApplicationPropertyFacade.getApplicationPropertyConfFilepath(project);
            ApplicationPropertyConfExporter applicationPropertyConfExporter = new ApplicationPropertyConfExporter(string, list);
            applicationPropertyConfExporter.execute();
        }
        catch (IOException iOException) {
            logger.warn("Fail to save application property conf file. " + project.getProjectName());
        }
    }

    public static List getConfList(Project project) {
        try {
            String string = ApplicationPropertyFacade.getApplicationPropertyConfFilepath(project);
            if (!new File(string).isFile()) {
                ApplicationPropertyFacade.saveConfList(project, new ArrayList());
            }
            ApplicationPropertyConfImporter applicationPropertyConfImporter = new ApplicationPropertyConfImporter(string);
            applicationPropertyConfImporter.execute();
            List list = applicationPropertyConfImporter.getConfList();
            return list;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load application property conf file. " + project.getProjectName());
            return new ArrayList();
        }
    }

    public static Map getConfDirnameMap(Project project) {
        List list = ApplicationPropertyFacade.getConfList(project);
        HashMap<String, ApplicationPropertyConf> hashMap = new HashMap<String, ApplicationPropertyConf>();
        for (ApplicationPropertyConf applicationPropertyConf : list) {
            hashMap.put(applicationPropertyConf.getConfDirname(), applicationPropertyConf);
        }
        return hashMap;
    }

    public static void removeConf(String string) {
        Project project = ProjectAccesser.getSelectedProject();
        List list = ApplicationPropertyFacade.getConfList(project);
        ApplicationPropertyConf applicationPropertyConf = ApplicationPropertyUtil.getConf(string, list);
        if (applicationPropertyConf == null) {
            return;
        }
        String string2 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
        FileUtil.delete(string2);
        list.remove(applicationPropertyConf);
        ApplicationPropertyFacade.saveConfList(project, list);
    }

    public static ApplicationPropertyConf getConf(String string) {
        return ApplicationPropertyFacade.getConf(ProjectAccesser.getSelectedProject(), string);
    }

    public static ApplicationPropertyConf getConf(Project project, String string) {
        List list = ApplicationPropertyFacade.getConfList(project);
        return ApplicationPropertyUtil.getConf(string, list);
    }

    private static ApplicationPropertyConf findConf(String string, List list) {
        ApplicationPropertyConf applicationPropertyConf = null;
        for (ApplicationPropertyConf applicationPropertyConf2 : list) {
            if (!applicationPropertyConf2.equalsId(string)) continue;
            applicationPropertyConf = applicationPropertyConf2;
            break;
        }
        return applicationPropertyConf;
    }

    public static void registerConf(Project project, ApplicationPropertyConf applicationPropertyConf) {
        List list = ApplicationPropertyFacade.getConfList(project);
        ApplicationPropertyConf applicationPropertyConf2 = ApplicationPropertyFacade.findConf(applicationPropertyConf.getConfId(), list);
        if (applicationPropertyConf2 != null) {
            list.remove(applicationPropertyConf2);
        }
        list.add(applicationPropertyConf);
        ApplicationPropertyFacade.saveConfList(project, list);
    }

    public static void replaceConf(Project project, ApplicationPropertyConf applicationPropertyConf) {
        Object object;
        String string = applicationPropertyConf.getDomClustId();
        String string2 = DataManager.getDomClustDirpath(project, string);
        String string3 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
        File file = new File(string3);
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            file2.mkdir();
        }
        System.err.println("ReplaceConf:" + file + " " + file2 + " ");
        for (int i = 0; i < ApplicationPropertyConf.CONF_FILE_NAMES.length; ++i) {
            object = ApplicationPropertyConf.CONF_FILE_NAMES[i];
            File file3 = new File(file, (String)object);
            if (!file3.isFile()) continue;
            File file4 = new File(file2, (String)object);
            try {
                FileUtil.copy(file3, file4, true);
                continue;
            }
            catch (Exception exception) {
                logger.warn("Fail to copy application property file. " + file3.getAbsolutePath(), exception);
            }
        }
        File file5 = new File(file, "data");
        object = new File(file2, "data");
        System.err.println("dataDir:" + file5 + " " + object + " ");
        if (((File)object).isDirectory()) {
            FileUtil.delete((File)object);
        }
        if (file5.isDirectory()) {
            try {
                FileUtil.copyDir(file5, (File)object, true);
            }
            catch (Exception exception) {
                logger.warn("Fail to copy application property file. " + file5.getAbsolutePath(), exception);
            }
        }
    }

    public static void saveConf(Project project, ApplicationPropertyConf applicationPropertyConf) {
        Object object;
        String string = applicationPropertyConf.getDomClustId();
        String string2 = DataManager.getDomClustDirpath(project, string);
        String string3 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
        File file = new File(string3);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        File file2 = new File(string2);
        for (int i = 0; i < ApplicationPropertyConf.CONF_FILE_NAMES.length; ++i) {
            object = ApplicationPropertyConf.CONF_FILE_NAMES[i];
            File file3 = new File(file2, (String)object);
            if (!file3.isFile()) continue;
            File file4 = new File(file, (String)object);
            try {
                FileUtil.copy(file3, file4, true);
                continue;
            }
            catch (Exception exception) {
                logger.warn("Fail to copy application property file. " + file3.getAbsolutePath(), exception);
            }
        }
        File file5 = new File(file2, "data");
        object = new File(file, "data");
        if (((File)object).isDirectory()) {
            FileUtil.delete((File)object);
        }
        if (file5.isDirectory()) {
            try {
                FileUtil.copyDir(file5, (File)object, true);
            }
            catch (Exception exception) {
                logger.warn("Fail to copy application property file. " + file5.getAbsolutePath(), exception);
            }
        }
    }

    public static boolean equalsConf(File file, ApplicationPropertyConf applicationPropertyConf) {
        if (file instanceof ApplicationPropertyVirtualFile) {
            if (applicationPropertyConf == null) {
                return false;
            }
            ApplicationPropertyVirtualFile applicationPropertyVirtualFile = (ApplicationPropertyVirtualFile)file;
            ApplicationPropertyConf applicationPropertyConf2 = applicationPropertyVirtualFile.getConf();
            return applicationPropertyConf2.equalsId(applicationPropertyConf.getConfId());
        }
        if (applicationPropertyConf == null) {
            return true;
        }
        return applicationPropertyConf.equalsId("default");
    }

    public static Set getGeneInfoTitleSetFromConfFile(Project project, String string, Set set) throws IOException {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Map map = ApplicationPropertyFacade.getCategoryPropertyMap(project, string);
        Map map2 = (Map)map.get("HClust");
        if (!MapUtil.isNull(map2)) {
            map2.get("HClustInfoCls");
            object = ApplicationPropertyFacade.getInfoTitle(map, "HClust", "HClustInfoCls", "HClustInfoTitleKey", false, set);
            if (object != null && ((AbstractInfoTitle)object).isGene()) {
                hashSet.add(object);
            }
        }
        object = new GeneColorConditionGroup();
        ApplicationPropertyFacade.updateAccessable(project, string, (ApplicationPropertyAccessable)object);
        Set set2 = ((GeneColorConditionGroup)object).getInfoTitleSet();
        hashSet.addAll(InfoUtil.fitlerInfoTitleListByCls(set2, 1));
        HashSet hashSet2 = new HashSet(InfoUtil.extractUserInfoTitleList(hashSet));
        return hashSet2;
    }

    private static AbstractInfoTitle getInfoTitle(Map map, String string, String string2, String string3, boolean bl, Set set) {
        Map map2 = (Map)map.get(string);
        if (MapUtil.isNull(map2)) {
            return null;
        }
        Object v = map2.get(string2);
        if (v == null) {
            return null;
        }
        int n = -1;
        try {
            n = Integer.parseInt(String.valueOf(v));
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = "Fail to parse proparty type. " + v;
            logger.warn(string4, numberFormatException);
            return null;
        }
        Object v2 = map2.get(string3);
        if (v2 == null) {
            return null;
        }
        AbstractInfoTitle abstractInfoTitle = InfoFacade.getInfoTitle(n, set, String.valueOf(v2), bl);
        return abstractInfoTitle;
    }

    public static Set getGeneInfoTitleSetFromConfFile(String string, Set set) throws IOException {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string2 = ApplicationPropertyFacade.getPropertyFilepath(string);
        Map map = ApplicationPropertyFacade.getCategoryPropertyMap(string2);
        Map map2 = (Map)map.get("HClust");
        if (!MapUtil.isNull(map2)) {
            map2.get("HClustInfoCls");
            object = ApplicationPropertyFacade.getInfoTitle(map, "HClust", "HClustInfoCls", "HClustInfoTitleKey", true, set);
            if (object != null && ((AbstractInfoTitle)object).isGene()) {
                hashSet.add(object);
            }
        }
        object = GeneColorFacade.createTmpGeneColorConditionGroup(string);
        Set set2 = ((GeneColorConditionGroup)object).getInfoTitleSet();
        hashSet.addAll(InfoUtil.fitlerInfoTitleListByCls(set2, 1));
        HashSet hashSet2 = new HashSet(InfoUtil.extractUserInfoTitleList(hashSet));
        return hashSet2;
    }

    public static void renameConfName(File file, File file2, Project project) {
        ApplicationPropertyFacade.renameConfName(FileUtil.removeExtension(file.getName()), FileUtil.removeExtension(file2.getName()), project);
    }

    public static void renameConfName(String string, String string2, Project project) {
        boolean bl = false;
        List list = ApplicationPropertyFacade.getConfList(project);
        for (int i = 0; i < list.size(); ++i) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)list.get(i);
            if (applicationPropertyConf.getConfName().compareToIgnoreCase(string) != 0) continue;
            applicationPropertyConf.setConfName(string2);
            bl = true;
            logger.info("appPropConf: " + applicationPropertyConf.getConfId() + " " + applicationPropertyConf.getConfName() + " was renamed to " + string2 + ".");
        }
        if (bl) {
            ApplicationPropertyFacade.saveConfList(project, list);
        }
    }

    public static void deleteByDomClustId(String string, Project project) {
        boolean bl = false;
        List list = ApplicationPropertyFacade.getConfList(project);
        for (int i = 0; i < list.size(); ++i) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)list.get(i);
            String string2 = applicationPropertyConf.getDomClustId();
            if (string2.compareToIgnoreCase(string) == 0) {
                list.remove(i);
                bl = true;
                logger.info("app_prop_conf: " + applicationPropertyConf.getConfId() + " " + applicationPropertyConf.getDomClustId() + " " + applicationPropertyConf.getConfName() + " was removed.");
                String string3 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
                FileUtil.delete(string3);
                logger.info("app_prop_conf: " + string3 + " was deleted.");
            }
            if (!bl) continue;
            ApplicationPropertyFacade.saveConfList(project, list);
        }
    }

    public static void deleteByConfName(File file, Project project) {
        ApplicationPropertyFacade.deleteByConfName(FileUtil.removeExtension(file.getName()), project);
    }

    public static void deleteByConfName(String string, Project project) {
        boolean bl = false;
        List list = ApplicationPropertyFacade.getConfList(project);
        for (int i = 0; i < list.size(); ++i) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)list.get(i);
            String string2 = applicationPropertyConf.getConfName();
            if (string2.compareToIgnoreCase(string) != 0) continue;
            list.remove(i);
            bl = true;
            logger.info("app_prop_conf: " + applicationPropertyConf.getConfId() + " " + applicationPropertyConf.getDomClustId() + " " + applicationPropertyConf.getDomClustViewId() + " " + applicationPropertyConf.getConfName() + " was removed.");
            String string3 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
            FileUtil.delete(string3);
            logger.info("app_prop_conf: " + string3 + " was deleted.");
        }
        if (bl) {
            ApplicationPropertyFacade.saveConfList(project, list);
        }
    }

    public static void deleteByClusterViewId(String string, String string2, Project project) {
        boolean bl = false;
        List list = ApplicationPropertyFacade.getConfList(project);
        for (int i = 0; i < list.size(); ++i) {
            ApplicationPropertyConf applicationPropertyConf = (ApplicationPropertyConf)list.get(i);
            String string3 = applicationPropertyConf.getDomClustId();
            if (string3 == null || string3.compareTo(string) != 0 || (string3 = applicationPropertyConf.getDomClustViewId()) == null || string3.compareTo(string2) != 0) continue;
            list.remove(i);
            bl = true;
            logger.info("app_prop_conf: " + applicationPropertyConf.getConfId() + " " + applicationPropertyConf.getDomClustId() + " " + applicationPropertyConf.getDomClustViewId() + " " + applicationPropertyConf.getConfName() + " was removed.");
            String string4 = ApplicationPropertyFacade.getApplicationPropertyDirpath(project, applicationPropertyConf);
            FileUtil.delete(string4);
            logger.info("app_prop_conf: " + string4 + " was deleted.");
        }
        if (bl) {
            ApplicationPropertyFacade.saveConfList(project, list);
        }
    }

    public static void deletePropertyDirectory(Project project, String string) {
        String string2 = ApplicationPropertyFacade.getPropertyDirectory(project, string);
        FileUtil.delete(string2);
        logger.info("DomClust: " + string2 + " was deleted.");
    }
}

