/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;

public class TaxMapScoreFilterDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Filter nodes by score";
    private JCheckBox moreCheckBox;
    private SliderTextPanel moreSliderTextPanel;

    public TaxMapScoreFilterDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public TaxMapScoreFilterDialog(Dialog dialog) {
        super(dialog);
        this.createComponents();
    }

    public static TaxMapScoreFilterDialog getInstance(Component component) {
        if (component instanceof Dialog) {
            return new TaxMapScoreFilterDialog((Dialog)component);
        }
        if (component instanceof Frame) {
            return new TaxMapScoreFilterDialog((Frame)component);
        }
        return null;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.moreCheckBox = new JCheckBox("Score # or more");
        this.moreCheckBox.addActionListener(this);
        this.moreSliderTextPanel = new SliderTextPanel();
        this.moreSliderTextPanel.setPaintLabels(true);
        this.moreSliderTextPanel.setSnapToTicks(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.moreCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 15, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.moreSliderTextPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 0, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 0, new Insets(5, 15, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(boolean bl, double d, double d2) {
        this.moreCheckBox.setSelected(bl);
        this.moreSliderTextPanel.setMinimum(0);
        this.moreSliderTextPanel.setMaximum((int)d2);
        this.moreSliderTextPanel.setValue(d);
        this.setEnableMoreSliderTextPanel();
    }

    private void setEnableMoreSliderTextPanel() {
        this.moreSliderTextPanel.setEnabledComponents(this.moreCheckBox.isSelected());
    }

    public boolean isEnableScoreFilter() {
        return this.moreCheckBox.isSelected();
    }

    public double getThreshold() {
        return this.moreSliderTextPanel.getValue();
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.moreCheckBox) {
            this.setEnableMoreSliderTextPanel();
        }
    }
}

