/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.util.GeneUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.PieDataset;

class TaxMapUtil {
    private TaxMapUtil() {
    }

    public static List createGeneInfoList(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (TaxMapInfo taxMapInfo : list) {
            String string;
            String string2 = taxMapInfo.getOrganismCode();
            String string3 = GeneUtil.createOrganismLocusTagKey(string2, string = taxMapInfo.getLocusTag());
            if (hashSet.contains(string3)) continue;
            hashSet.add(string3);
            GeneInfo geneInfo = new GeneInfo();
            geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string2);
            geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, GeneUtil.removeDomainNo(string));
            arrayList.add(geneInfo);
        }
        return arrayList;
    }

    public static Map createOrganismTaxMapInfoMap(List list) {
        HashMap<String, ArrayList<TaxMapInfo>> hashMap = new HashMap<String, ArrayList<TaxMapInfo>>();
        for (TaxMapInfo taxMapInfo : list) {
            String string = taxMapInfo.getOrganismCode();
            ArrayList<TaxMapInfo> arrayList = (ArrayList<TaxMapInfo>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<TaxMapInfo>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(taxMapInfo);
        }
        return hashMap;
    }

    public static Map createClusterIdTaxMapInfoListMap(List list, ClusterTbl clusterTbl) {
        int n = 3;
        if (clusterTbl.isOutgroup()) {
            n = 4;
        }
        HashMap<String, ArrayList<TaxMapInfo>> hashMap = new HashMap<String, ArrayList<TaxMapInfo>>();
        for (TaxMapInfo taxMapInfo : list) {
            List list2 = clusterTbl.getClusterList(taxMapInfo.getOrganismCode(), taxMapInfo.getLocusTag());
            for (Cluster cluster : list2) {
                String string = ClusterInfoUtil.getClusterInfoKey(cluster, n);
                ArrayList<TaxMapInfo> arrayList = (ArrayList<TaxMapInfo>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<TaxMapInfo>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(taxMapInfo);
            }
        }
        return hashMap;
    }

    public static float calcSum(PieDataset pieDataset) {
        float f = 0.0f;
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            float f2 = pieDataset.getValue(i).floatValue();
            f += f2;
        }
        return f;
    }
}

