/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.tree;

import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.tree.TreeContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.List;

public class TreeRenderer {
    private List rootNodeList;
    private TreeContext treeContext;

    public TreeRenderer(List list, TreeContext treeContext) {
        this.rootNodeList = list;
        this.treeContext = treeContext;
        double d = NodeUtil.calcMaxDist(this.rootNodeList);
        this.treeContext.calcXScale(d);
    }

    protected TreeContext getTreeContext() {
        return this.treeContext;
    }

    public void draw(Graphics2D graphics2D) {
        float f;
        graphics2D.setFont(this.treeContext.createDistFont());
        graphics2D.setColor(Color.black);
        float f2 = 0.0f;
        float f3 = f = this.getStartY();
        int n = 0;
        for (ClusterNode clusterNode : this.rootNodeList) {
            int n2 = clusterNode.getChildCount();
            if (n + n2 < this.treeContext.getStartRow() + this.treeContext.getOffsetStartRow()) {
                f3 += (float)n2 * (float)this.treeContext.getLeafInterval();
                n += n2;
                continue;
            }
            this.drawTreeLine(graphics2D, clusterNode, f2, f3);
            f3 += (float)n2 * (float)this.treeContext.getLeafInterval();
            if ((n += n2) <= this.treeContext.getRowCount() + this.treeContext.getStartRow()) continue;
            break;
        }
    }

    protected float getStartY() {
        float f = (float)this.treeContext.getLeafInterval() / 2.0f + (float)this.treeContext.getMarginTop() - (float)this.treeContext.getLeafInterval() * (float)(this.treeContext.getStartRow() + this.treeContext.getOffsetStartRow());
        return f;
    }

    protected float drawTreeLine(Graphics2D graphics2D, Node node, float f, float f2) {
        float f3 = (float)(node.getDist() * this.getTreeContext().getScaleX());
        if (node.isLeaf()) {
            graphics2D.draw(new Line2D.Float(f, f2, f + f3, f2));
            return f2;
        }
        Node node2 = node.getNode1();
        Node node3 = node.getNode2();
        int n = node2.getChildCount();
        float f4 = (float)this.getTreeContext().getLeafInterval() * (float)n;
        float f5 = this.drawTreeLine(graphics2D, node2, f + f3, f2);
        float f6 = this.drawTreeLine(graphics2D, node3, f + f3, f2 + f4);
        float f7 = (f5 + f6) / 2.0f;
        graphics2D.draw(new Line2D.Float(f, f7, f + f3, f7));
        graphics2D.draw(new Line2D.Float(f + f3, f5, f + f3, f6));
        return f7;
    }

    protected List getRootNodeList() {
        return this.rootNodeList;
    }
}

