/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.url;

import cgdp.recog.url.GeneUrl;
import cgdp.recog.url.GeneUrlEditDialog;
import cgdp.recog.url.GeneUrlTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RadioButtonCellEditor;
import cgdp.recog.util.RadioButtonCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class GeneUrlListDialog
extends AbstractApplyDialog {
    private static GeneUrlListDialog GENE_URL_LIST_DIALOG;
    private static final String TITLE = "URL";
    private static final int COLUMN_WIDTH_DEFAULT = 50;
    private static final int DIALOG_HEIGHT = 200;
    private JTable geneUrlTable;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;

    private GeneUrlListDialog(Frame frame) {
        super(frame);
        this.createComponents();
        GeneUrlEditDialog.createInstance(this);
    }

    public static void createInstance(Frame frame) {
        if (GENE_URL_LIST_DIALOG != null) {
            return;
        }
        GENE_URL_LIST_DIALOG = new GeneUrlListDialog(frame);
    }

    public static GeneUrlListDialog getInstance() {
        return GENE_URL_LIST_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.geneUrlTable = new JTable(new GeneUrlTableModel());
        this.geneUrlTable.setRowHeight(20);
        this.geneUrlTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.geneUrlTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GeneUrlListDialog.this.updateButtonState();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.geneUrlTable, 20, 31);
        TableColumn tableColumn = this.geneUrlTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new RadioButtonCellRenderer());
        tableColumn.setCellEditor(new RadioButtonCellEditor());
        tableColumn.setMinWidth(50);
        tableColumn.setMaxWidth(50);
        this.addButton = new JButton("Add...");
        this.addButton.addActionListener(this);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.editButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.updateButtonState();
        this.pack();
        this.setSize(new Dimension(this.getSize().width, 200));
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(List list) {
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        geneUrlTableModel.setGeneUrlList(list);
    }

    private void updateButtonState() {
        if (this.geneUrlTable.getSelectedRowCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public List getGeneUrlList() {
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        return geneUrlTableModel.getGeneUrlList();
    }

    @Override
    protected boolean apply() {
        return true;
    }

    private GeneUrlTableModel getGeneUrlTableModel() {
        return (GeneUrlTableModel)this.geneUrlTable.getModel();
    }

    private GeneUrl getSelectedGeneUrl() {
        int n = this.geneUrlTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        return geneUrlTableModel.getGeneUrl(n);
    }

    private void add() {
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        GeneUrlEditDialog geneUrlEditDialog = GeneUrlEditDialog.getInstance();
        geneUrlEditDialog.updateValue(null, geneUrlTableModel.getGeneUrlList());
        geneUrlEditDialog.setVisible(true);
        if (geneUrlEditDialog.isCanceled()) {
            return;
        }
        GeneUrl geneUrl = geneUrlEditDialog.getGeneUrl();
        geneUrlTableModel.addGeneUrl(geneUrl);
    }

    private void edit() {
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        GeneUrl geneUrl = this.getSelectedGeneUrl();
        GeneUrlEditDialog geneUrlEditDialog = GeneUrlEditDialog.getInstance();
        geneUrlEditDialog.updateValue(geneUrl, geneUrlTableModel.getGeneUrlList());
        geneUrlEditDialog.setVisible(true);
        if (geneUrlEditDialog.isCanceled()) {
            return;
        }
        GeneUrl geneUrl2 = geneUrlEditDialog.getGeneUrl();
        geneUrl.copy(geneUrl2);
        int n = this.geneUrlTable.getSelectedRow();
        geneUrlTableModel.fireTableRowsUpdated(n, n);
    }

    private void delete() {
        GeneUrl geneUrl = this.getSelectedGeneUrl();
        if (geneUrl == null) {
            return;
        }
        if (!MessageManager.showConfirmMessage((Component)this, "Delete URL. [" + geneUrl.getName() + "]")) {
            return;
        }
        GeneUrlTableModel geneUrlTableModel = this.getGeneUrlTableModel();
        geneUrlTableModel.deleteGeneUrl(geneUrl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.editButton) {
            this.edit();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }
}

