/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public abstract class AbstractPrintExecuter
implements Printable {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractPrintExecuter.class);
    private Component parent;
    private int width;
    private int height;
    private PageFormat pageFormat;

    public AbstractPrintExecuter(int n, int n2) {
        this(null, n, n2);
    }

    public AbstractPrintExecuter(Component component, int n, int n2) {
        this(component, n, n2, null);
    }

    public AbstractPrintExecuter(Component component, int n, int n2, PageFormat pageFormat) {
        this.parent = component;
        this.width = n;
        this.height = n2;
        this.pageFormat = pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void execute() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        if (this.pageFormat != null) {
            pageFormat = this.pageFormat;
        } else {
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
            if (pageFormat == pageFormat2) {
                return;
            }
            pageFormat = pageFormat2;
        }
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                String string = "Fail to print.";
                logger.warn(string, printerException);
                MessageManager.showErrorMessage(this.parent, string);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, (int)d3, (int)d4);
        double d5 = d3 / (double)this.getWidth();
        double d6 = d4 / (double)this.getHeight();
        double d7 = Math.min(d5, d6);
        graphics2D.translate(d, d2);
        graphics2D.scale(d7, d7);
        this.draw(graphics2D, this.getWidth(), this.getHeight());
        return 0;
    }

    protected abstract void draw(Graphics2D var1, int var2, int var3);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

