/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.AbstractFileFilter;
import cgdp.recog.util.StringTool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class CustomFileChooser
extends JFileChooser {
    private PropertyChangeListener propertyChangeListener;

    public CustomFileChooser() {
        this.init();
    }

    public CustomFileChooser(File file) {
        super(file);
        this.init();
    }

    public CustomFileChooser(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (this.getUI() instanceof BasicFileChooserUI) {
            final BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)this.getUI();
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                        final String string = basicFileChooserUI.getFileName();
                        final AbstractFileFilter abstractFileFilter = (AbstractFileFilter)CustomFileChooser.this.getFileFilter();
                        if (!StringTool.isNull(string)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    basicFileChooserUI.setFileName(abstractFileFilter.modifiedExtension(string));
                                }
                            });
                        }
                    }
                }
            };
            this.addPropertyChangeListener(this.propertyChangeListener);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                        CustomFileChooser.this.updateSelectedFile();
                    }
                }
            });
        }
    }

    protected void updateSelectedFile() {
    }
}

