/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.ColorTableCellRenderer;
import cgdp.recog.util.LabelColorTableModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JTable;

public class LabelColorTable
extends JTable
implements MouseListener {
    public LabelColorTable() {
        this.init();
    }

    private void init() {
        this.setModel(new LabelColorTableModel());
        this.addMouseListener(this);
        this.setRowHeight(20);
        this.setTableHeader(null);
        this.setCellRenderer();
    }

    public void setLabelColorList(List list) {
        LabelColorTableModel labelColorTableModel = this.getLabelColorTableModel();
        labelColorTableModel.setLabelColorList(list);
    }

    public List getLabelColorList() {
        LabelColorTableModel labelColorTableModel = this.getLabelColorTableModel();
        return labelColorTableModel.getLabelColorList();
    }

    private LabelColorTableModel getLabelColorTableModel() {
        return (LabelColorTableModel)this.getModel();
    }

    public void setCellRenderer() {
        this.getColumnModel().getColumn(1).setCellRenderer(new ColorTableCellRenderer());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0 && mouseEvent.getButton() == 1) {
            Object object = this.getValueAt(n, n2);
            if (object instanceof Color) {
                Color color = (Color)object;
                Color color2 = JColorChooser.showDialog(this, "Color palette", color);
                LabelColorTableModel labelColorTableModel = this.getLabelColorTableModel();
                labelColorTableModel.setColor(n, color2);
            } else {
                this.processMouseClicked(object, n, n2);
            }
        }
    }

    protected void processMouseClicked(Object object, int n, int n2) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

