/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfPageLabels
implements Comparator {
    public static int DECIMAL_ARABIC_NUMERALS = 0;
    public static int UPPERCASE_ROMAN_NUMERALS = 1;
    public static int LOWERCASE_ROMAN_NUMERALS = 2;
    public static int UPPERCASE_LETTERS = 3;
    public static int LOWERCASE_LETTERS = 4;
    public static int EMPTY = 5;
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    TreeMap map = new TreeMap(this);

    public PdfPageLabels() {
        this.addPageLabel(1, DECIMAL_ARABIC_NUMERALS, null, 1);
    }

    public int compare(Object object, Object object2) {
        int n;
        int n2 = (Integer)object;
        if (n2 < (n = ((Integer)object2).intValue())) {
            return -1;
        }
        if (n2 == n) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return true;
    }

    public void addPageLabel(int n, int n2, String string, int n3) {
        if (n < 1 || n3 < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfName pdfName = null;
        if (n2 >= 0 && n2 < numberingStyle.length) {
            pdfName = numberingStyle[n2];
        }
        Integer n4 = new Integer(n);
        Object[] objectArray = new Object[]{n4, pdfName, string, new Integer(n3)};
        this.map.put(n4, objectArray);
    }

    public void addPageLabel(int n, int n2, String string) {
        this.addPageLabel(n, n2, string, 1);
    }

    public void addPageLabel(int n, int n2) {
        this.addPageLabel(n, n2, null, 1);
    }

    public void removePageLabel(int n) {
        if (n <= 1) {
            return;
        }
        this.map.remove(new Integer(n));
    }

    PdfDictionary getDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            Object[] objectArray = (Object[])iterator.next();
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            PdfName pdfName = (PdfName)objectArray[1];
            if (pdfName != null) {
                pdfDictionary2.put(PdfName.S, pdfName);
            }
            if ((string = (String)objectArray[2]) != null) {
                pdfDictionary2.put(PdfName.P, new PdfString(string, "UnicodeBig"));
            }
            if ((n = ((Integer)objectArray[3]).intValue()) != 1) {
                pdfDictionary2.put(PdfName.ST, new PdfNumber(n));
            }
            pdfArray.add(new PdfNumber((Integer)objectArray[0] - 1));
            pdfArray.add(pdfDictionary2);
        }
        pdfDictionary.put(PdfName.NUMS, pdfArray);
        return pdfDictionary;
    }
}

