/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.access;

import cgdp.recog.access.AbstractFileAccessExecuter;
import cgdp.recog.access.FileChooserFactory;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.domclust.AbstractDomClustExporter;
import cgdp.recog.domclust.DomClustTabExporter;
import cgdp.recog.filefilter.SingleFileFilter;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;

class ClusterSetExportExecuter
extends AbstractFileAccessExecuter {
    private JFileChooser chooser;
    private ClusterTbl clusterTbl;
    private ClusterSet clusterSet;
    private Map infoMap;
    private Map parameterMap;

    ClusterSetExportExecuter(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, ClusterSet clusterSet) {
        this(frame, mediatorImpl, clusterTbl, clusterSet, null, null);
    }

    ClusterSetExportExecuter(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, ClusterSet clusterSet, Map map, Map map2) {
        super(frame, mediatorImpl, null);
        this.clusterTbl = clusterTbl;
        this.clusterSet = clusterSet;
        this.chooser = FileChooserFactory.createFileChooser(this.getAccessType(), null);
        this.infoMap = map;
        this.parameterMap = map2;
    }

    @Override
    int getAccessType() {
        return 104;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        try {
            if (this.chooser.showSaveDialog(this.parent) != 0) {
                return;
            }
            this.parent.setCursor(new Cursor(3));
            List list = this.clusterSet.getElementList();
            list = this.clusterTbl.getClusterList(ClusterUtil.getClusterIdSet(list));
            Collections.sort(list, new ClusterComparator(6));
            File file = this.chooser.getSelectedFile();
            SingleFileFilter singleFileFilter = (SingleFileFilter)this.chooser.getFileFilter();
            String string = singleFileFilter.modifiedExtension(file);
            if (new File(string).isFile() && !MessageManager.showConfirmOverwriteMessage(this.parent, string)) {
                return;
            }
            DomClustTabExporter domClustTabExporter = AbstractDomClustExporter.createDomClustTabExporter(string, this.clusterTbl.getFilepath(), list, this.clusterTbl.isOutgroup(), this.clusterTbl.getIngroupSpList(), this.clusterTbl.getOutgroupSpList());
            domClustTabExporter.setInfoMap(this.infoMap);
            domClustTabExporter.setParameterMap(this.parameterMap);
            domClustTabExporter.execute();
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            optionValues.setUserImportDir(new File(string).getParent());
        }
        finally {
            this.parent.setCursor(new Cursor(0));
        }
    }
}

