/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.mgmap.AlignmentItem;
import cgdp.recog.multiplealign.MultipleAlignmentItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.ppm.ClusterSplitItem;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.table.GeneNameTableModel;
import cgdp.recog.url.GeneUrlFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class GeneNameList
extends JScrollPane
implements ActionListener,
MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneNameList.class);
    private static int[] COLUMN_SIZE = new int[]{50, 80, 80};
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private Set clusterSet = new HashSet();
    private JTable geneListTable;

    public GeneNameList(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        mediatorImpl.register(this);
        this.setBorder(null);
        this.setPreferredSize(new Dimension(300, 200));
        this.setMinimumSize(new Dimension(150, 100));
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void createGeneNameList(String string, String string2, Set set) {
        Serializable serializable;
        if (this.clusterTbl == null || !CollectionUtil.isNull(set) && ((Object)this.clusterSet).equals(set)) {
            if (!StringTool.isNull(string2)) {
                this.setGeneSelectionByGeneName(string2);
            } else {
                this.setGeneSelectionByOrganism(string);
            }
            return;
        }
        this.clusterSet = set;
        List list = this.clusterTbl.getViewOrganismCodeList();
        ArrayList<Gene> arrayList = new ArrayList<Gene>();
        int n = 0;
        for (String string3 : list) {
            serializable = new HashSet();
            for (Cluster cluster : set) {
                List list2 = cluster.getGeneInformationList(string3);
                if (list2 == null) continue;
                for (GeneInformation geneInformation : list2) {
                    if (serializable.contains(geneInformation.getLocusTag())) continue;
                    Gene gene = new Gene();
                    gene.setOrganism(string3);
                    gene.setLocusTag(geneInformation.getLocusTag());
                    arrayList.add(gene);
                    serializable.add(geneInformation.getLocusTag());
                    ++n;
                }
            }
        }
        this.geneListTable = new JTable(new GeneNameTableModel(arrayList));
        this.geneListTable.addMouseListener(this);
        this.geneListTable.setSelectionMode(2);
        this.geneListTable.setRowHeight(20);
        Enumeration<TableColumn> enumeration = this.geneListTable.getColumnModel().getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            serializable = (TableColumn)enumeration.nextElement();
            ((TableColumn)serializable).setPreferredWidth(COLUMN_SIZE[n2]);
            ++n2;
        }
        this.setViewportView(this.geneListTable);
        if (!StringTool.isNull(string2)) {
            this.setGeneSelectionByGeneName(string2);
        } else {
            this.setGeneSelectionByOrganism(string);
        }
    }

    public void setGeneSelectionByOrganism(String string) {
        if (this.geneListTable == null) {
            return;
        }
        GeneNameTableModel geneNameTableModel = (GeneNameTableModel)this.geneListTable.getModel();
        int n = geneNameTableModel.getRowIndexByOrganism(string);
        if (n != -1) {
            this.geneListTable.scrollRectToVisible(this.geneListTable.getCellRect(n, 0, false));
            this.geneListTable.setRowSelectionInterval(n, n);
        }
    }

    public void setGeneSelectionByGeneName(String string) {
        if (this.geneListTable == null) {
            return;
        }
        GeneNameTableModel geneNameTableModel = (GeneNameTableModel)this.geneListTable.getModel();
        int n = geneNameTableModel.getRowIndexByGeneName(string);
        if (n != -1) {
            this.geneListTable.scrollRectToVisible(this.geneListTable.getCellRect(n, 0, false));
            this.geneListTable.setRowSelectionInterval(n, n);
        }
    }

    public void clearGeneNameList() {
        this.setViewportView(null);
        this.clusterSet.clear();
    }

    public Gene getSelectedGene() {
        int n = this.geneListTable.getSelectedRow();
        if (n != -1) {
            Gene gene = new Gene();
            gene.setOrganism((String)this.geneListTable.getValueAt(n, 0));
            String string = (String)this.geneListTable.getValueAt(n, 1);
            int n2 = 0;
            if (GeneUtil.isDomain(string)) {
                string = GeneUtil.removeDomainNo(string);
                n2 = GeneUtil.getDomainNo(string);
            }
            gene.setLocusTag(string);
            gene.setDomainNo(n2);
            return gene;
        }
        return null;
    }

    public List getSelectedGeneInfoList() {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        int[] nArray = this.geneListTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.geneListTable.getValueAt(nArray[i], 0);
            String string2 = (String)this.geneListTable.getValueAt(nArray[i], 1);
            GeneInfo geneInfo = new GeneInfo(string, string2);
            arrayList.add(geneInfo);
        }
        return arrayList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.geneListTable.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            String string = (String)this.geneListTable.getValueAt(n, 0);
            String string2 = GeneUtil.removeDomainNo((String)this.geneListTable.getValueAt(n, 1));
            if (mouseEvent.getButton() == 1) {
                this.mediator.createGeneInfoList(string, string2);
            }
            if (mouseEvent.getClickCount() == 2) {
                String string3 = GeneUrlFacade.getDefaultUrl(this.clusterTbl, string, GeneUtil.removeDomainNo(string2));
                this.mediator.viewUrl(string3);
            }
        }
    }

    private static Map createGeneInformationMap(Collection collection) {
        HashMap<String, GeneInformation> hashMap = new HashMap<String, GeneInformation>();
        for (Cluster cluster : collection) {
            for (String string : cluster.getSpSet()) {
                for (GeneInformation geneInformation : cluster.getGeneInformationList(string)) {
                    String string2 = geneInformation.getLocusTag();
                    String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
                    hashMap.put(string3, geneInformation);
                }
            }
        }
        return hashMap;
    }

    private Set createGeneInfoSet() {
        int[] nArray = this.geneListTable.getSelectedRows();
        List list = this.mediator.getSelectClusterOnClusterList();
        Map map = GeneNameList.createGeneInformationMap(list);
        HashSet<GeneInfo> hashSet = new HashSet<GeneInfo>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.geneListTable.getValueAt(nArray[i], 0);
            String string2 = (String)this.geneListTable.getValueAt(nArray[i], 1);
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            GeneInformation geneInformation = (GeneInformation)map.get(string3);
            GeneInfo geneInfo = new GeneInfo(string, string2);
            geneInfo.putInfo(GeneInfoTitle.TITLE_START_ON_GENE, new Double(geneInformation.getFrom()));
            geneInfo.putInfo(GeneInfoTitle.TITLE_END_ON_GENE, new Double(geneInformation.getTo()));
            hashSet.add(geneInfo);
        }
        return hashSet;
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        String string;
        List list;
        Object object;
        List list2;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        int n = this.geneListTable.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        Set set = this.createGeneInfoSet();
        Set set2 = GeneInfoUtil.adjustUniqueGeneInfo(set);
        boolean bl = false;
        if (OptionTbl.getInstance().getOptionValues().isShowHiddenMenu()) {
            jPopupMenu.add(new AlignmentItem(this, this.mediator, set));
            if (set2.size() > 1) {
                jPopupMenu.add(new MultipleAlignmentItem(this, this.mediator, set2));
            }
            bl = true;
        }
        if ((list2 = this.clusterTbl.getSelectedClusterList()).size() == 1 && !((Cluster)(object = (Cluster)list2.get(0))).isTypeMergeCluster()) {
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(new ClusterSplitItem(this, this.mediator, (Cluster)object, set));
            bl = true;
        }
        if (!CollectionUtil.isNull(list = GeneUrlFacade.createUrlMenuList(this, this.mediator, this.clusterTbl, (String)(object = (String)this.geneListTable.getValueAt(n, 0)), string = GeneUtil.removeDomainNo((String)this.geneListTable.getValueAt(n, 1))))) {
            if (bl) {
                jPopupMenu.addSeparator();
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((JMenuItem)iterator.next());
            }
        }
        jPopupMenu.show(this.geneListTable, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

