/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ColorTbl;
import cgdp.recog.data.ViewData;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.ppm.PPMContext;
import cgdp.recog.ppm.PPMLabelCondition;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.ThreadManager;
import cgdp.recog.sort.BasicSortCondition;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.system.KeyBindUtil;
import cgdp.recog.system.OS;
import cgdp.recog.taxonomy.TaxonomyTreeEx;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class HeaderMap
extends JPanel
implements MouseListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(HeaderMap.class);
    private static final Color DEFAULT_FILL_COLOR = ColorTbl.DEFAULT_COLOR;
    public static final int GENE_NAME_CELL_WIDTH = 45;
    private MediatorImpl mediator;
    private OptionTbl m_optionTbl;
    private ClusterTbl m_clusterTbl;
    private PPMContext ppmContext;
    private List m_viewDataList;
    private boolean popupFlagForMac = false;

    public HeaderMap(MediatorImpl mediatorImpl, PPMContext pPMContext) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.ppmContext = pPMContext;
        this.clear();
        this.setLayout(null);
        this.setBackground(Color.white);
        this.setFont(new Font("Monospaced", 0, 10));
        this.addMouseListener(this);
        this.setToolTipText("");
    }

    private void clear() {
        this.m_optionTbl = OptionTbl.getInstance();
        this.m_clusterTbl = null;
        this.m_viewDataList = new ArrayList();
    }

    public void resizeHeaderMap(Dimension dimension) {
        this.repaint();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.m_clusterTbl = clusterTbl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.m_clusterTbl == null) {
            return;
        }
        this.m_viewDataList.clear();
        double d = this.getSize().height;
        List list = this.m_clusterTbl.getViewOrganismList();
        List list2 = (List)this.mediator.getClusterMapDrawInfo();
        int n = (Integer)list2.get(0);
        int n2 = (Integer)list2.get(1);
        double d2 = (Double)list2.get(2);
        list2.clear();
        list2 = null;
        if (n >= list.size()) {
            return;
        }
        if (this.m_optionTbl.getOptionValues().isIntensive()) {
            HeaderMap.drawHeader((Graphics2D)graphics, list, n, n2, d2, d, 0.0, this.m_viewDataList);
        } else {
            HeaderMap.drawHeader((Graphics2D)graphics, list, n, n2, d2, d, 45.0, this.m_viewDataList);
        }
    }

    static void drawHeader(Graphics2D graphics2D, List list, int n, int n2, double d, double d2, double d3, List list2) {
        int n3;
        ColorTbl colorTbl = ColorTbl.getInstance();
        double d4 = d < 1.0 ? 1.0 : d;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = fontMetrics.stringWidth("w") + 1;
        for (n3 = 0; n3 < list.size() && n3 < n2 && n3 + n < list.size(); ++n3) {
            int n5;
            Organism organism = (Organism)list.get(n3 + n);
            String string = organism.getOrganismCode();
            double d5 = (double)n3 * d + d3;
            Color color = colorTbl.containsKey(string) ? colorTbl.getColor(string) : DEFAULT_FILL_COLOR;
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Double(d5, 0.0, d4, d2 - 2.0));
            if (d4 - 1.0 >= (double)fontMetrics.stringWidth(string)) {
                int n6 = (int)(d5 + d4 / 2.0) - fontMetrics.stringWidth(string) / 2;
                n5 = (int)((d2 - 2.0) / 2.0) + fontMetrics.getAscent() / 2;
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, n6, n5);
            } else if (d4 - 1.0 >= (double)n4) {
                int n7 = 0;
                for (n5 = 0; n5 < string.length(); ++n5) {
                    String string2 = new Character(string.charAt(n5)).toString();
                    int n8 = fontMetrics.stringWidth(string2);
                    int n9 = (int)(d5 + (d4 - (double)n8) / 2.0);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(string2, n9, n7 += 10);
                }
            }
            if (list2 == null) continue;
            ViewData viewData = new ViewData();
            viewData.setObject(organism);
            viewData.setDataRect2D(new Rectangle2D.Double(d5, 0.0, d4, d2 - 2.0));
            list2.add(viewData);
        }
        graphics2D.setColor(Color.white);
        for (n3 = 1; n3 < n2; ++n3) {
            double d6 = (double)n3 * d + d3;
            graphics2D.drawLine((int)d6, 0, (int)d6, (int)d2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        if (this.m_clusterTbl == null) {
            return;
        }
        Organism organism = this.getSelectedOrganism(mouseEvent.getPoint());
        if (organism != null) {
            object2 = organism.getOrganismCode();
            object = new HashSet<Object>();
            if (KeyBindUtil.isClickForMutliSelect(mouseEvent)) {
                object.addAll(this.m_clusterTbl.getPpmSelectionManager().getSelectedOrganismSet());
                if (object.contains(object2)) {
                    object.remove(object2);
                } else {
                    object.add(object2);
                }
            } else {
                object.add(object2);
            }
            this.mediator.setSelectedOrganism((Set)object, this);
        }
        if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            object2 = mouseEvent.getPoint();
            if (organism != null) {
                object = organism.getOrganismCode();
                this.m_clusterTbl.flipPppmHeaderSortOrder(SortConditionFactory.getGenePositionConditionGroupName((String)object));
                GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createGenePositionConditionGroup((String)object, ClusterMode.getClusterMode(), this.m_clusterTbl.getPpmHeaderSortOrder());
                this.mediator.sortClusterList(geneInfoSortConditionGroup);
            } else if (this.ppmContext.isLeftGeneNameArea(((Point)object2).x)) {
                object = this.m_clusterTbl.getSelectedPpmLabelCondition();
                this.m_clusterTbl.flipPppmHeaderSortOrder(SortConditionFactory.createConditionByPPMLabelName((PPMLabelCondition)object, 1));
                BasicSortCondition basicSortCondition = SortConditionFactory.createConditionByPPMLabel(this.m_clusterTbl.isOutgroup(), (PPMLabelCondition)object, 1, this.m_clusterTbl.getPpmHeaderSortOrder());
                this.mediator.sortClusterList(basicSortCondition);
            } else if (this.ppmContext.isRightGeneNameArea(((Point)object2).x)) {
                object = this.m_clusterTbl.getSelectedPpmLabelCondition();
                this.m_clusterTbl.flipPppmHeaderSortOrder(SortConditionFactory.createConditionByPPMLabelName((PPMLabelCondition)object, 2));
                BasicSortCondition basicSortCondition = SortConditionFactory.createConditionByPPMLabel(this.m_clusterTbl.isOutgroup(), (PPMLabelCondition)object, 2, this.m_clusterTbl.getPpmHeaderSortOrder());
                this.mediator.sortClusterList(basicSortCondition);
            } else if (this.ppmContext.isHomClusterArea(((Point)object2).x)) {
                object = this.m_clusterTbl.getSelectedPpmLabelCondition();
                this.m_clusterTbl.flipPppmHeaderSortOrder(SortConditionFactory.createConditionByPPMLabelName((PPMLabelCondition)object, 3));
                BasicSortCondition basicSortCondition = SortConditionFactory.createConditionByPPMLabel(this.m_clusterTbl.isOutgroup(), (PPMLabelCondition)object, 3, this.m_clusterTbl.getPpmHeaderSortOrder());
                this.mediator.sortClusterList(basicSortCondition);
            }
        }
    }

    private Organism getSelectedOrganism(Point point) {
        for (int i = 0; i < this.m_viewDataList.size(); ++i) {
            ViewData viewData = (ViewData)this.m_viewDataList.get(i);
            if (!viewData.getDataRect2D().contains(point.getX(), point.getY())) continue;
            return (Organism)viewData.getObject();
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Organism organism = this.getSelectedOrganism(mouseEvent.getPoint());
        if (organism == null) {
            return null;
        }
        return organism.getToolTipString();
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), mouseEvent.getY() + 20);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
            this.popupFlagForMac = true;
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getPoint());
            return;
        }
        if (!OS.isWindows() && this.popupFlagForMac) {
            this.popupFlagForMac = false;
            return;
        }
        this.updateGenomeMap(mouseEvent.getPoint());
    }

    private void updateGenomeMap(final Point point) {
        if (!this.mediator.isVisibleGenomeMap()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Organism organism = HeaderMap.this.getSelectedOrganism(point);
                    ChromosomeTbl chromosomeTbl = new ChromosomeTbl(organism);
                    chromosomeTbl.read();
                    final Chromosome chromosome = chromosomeTbl.getMainChromosome();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeaderMap.this.mediator.updateGenomeMap(chromosome.getId(), chromosome.getOrganismCode(), chromosome.isCircular(), chromosome.getLength());
                        }
                    });
                }
                catch (Exception exception) {
                    logger.warn("Fail to update genome map.", exception);
                }
            }
        };
        ThreadManager threadManager = ThreadManager.getInstance();
        threadManager.execute(runnable);
    }

    private void showPopup(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Set set = this.m_clusterTbl.getPpmSelectionManager().getSelectedOrganismSet();
        TaxonomyTreeEx.showOrganismMenus((ActionListener)this, this.mediator, this.m_clusterTbl, jPopupMenu, set);
        jPopupMenu.show(this, point.x, point.y);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }
}

