/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.access.ExportMenu;
import cgdp.recog.access.ExportTool;
import cgdp.recog.access.FileAccessFacade;
import cgdp.recog.access.ImportMenu;
import cgdp.recog.access.ImportTool;
import cgdp.recog.bean.ClusterArea;
import cgdp.recog.bean.ClusterList;
import cgdp.recog.bean.GeneInfoList;
import cgdp.recog.bean.GeneNameList;
import cgdp.recog.bean.InfoTabbedPane;
import cgdp.recog.bean.LabelTransferHandler;
import cgdp.recog.bean.Mediator;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.bean.ModePanel;
import cgdp.recog.bean.TreeOptionPanel;
import cgdp.recog.bean.TreeTabbedPane;
import cgdp.recog.calc.CoefDialog;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.geneinfo.GeneColorItem;
import cgdp.recog.color.geneinfo.GeneColorTool;
import cgdp.recog.coregenome.CoreGenomeItem;
import cgdp.recog.coregenome.CoreGenomeTool;
import cgdp.recog.domclust.DomClustItem;
import cgdp.recog.domclust.DomClustSaveServerItem;
import cgdp.recog.domclust.DomClustTool;
import cgdp.recog.domclust.FileDeleteItem;
import cgdp.recog.domclust.FileOpenItem;
import cgdp.recog.domclust.FileOpenTool;
import cgdp.recog.domclust.FileSaveTool;
import cgdp.recog.domclust.NewMenu;
import cgdp.recog.filter.CountFilterDialog;
import cgdp.recog.filter.CountFilterItem;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.funccat.FuncCatItem;
import cgdp.recog.funccat.FuncCatTool;
import cgdp.recog.gmap.GenomeMapFrame;
import cgdp.recog.hcluster.HClustDialog;
import cgdp.recog.hcluster.HClustItem;
import cgdp.recog.hcluster.HClustTool;
import cgdp.recog.hcluster.tree.ClusterTreeMap;
import cgdp.recog.hcluster.tree.ClusterTreeScrollBar;
import cgdp.recog.hcluster.tree.ClusterTreeScrollPane;
import cgdp.recog.histogram.CategoryMap;
import cgdp.recog.histogram.CategoryScrollBar;
import cgdp.recog.histogram.CategoryScrollPane;
import cgdp.recog.histogram.HistogramDialog;
import cgdp.recog.histogram.HistogramItem;
import cgdp.recog.histogram.HistogramTool;
import cgdp.recog.info.InfoListItem;
import cgdp.recog.info.cluster.ClusterInfoConvertDialog;
import cgdp.recog.info.cluster.ClusterInfoConvertItem;
import cgdp.recog.info.gene.GeneFrame;
import cgdp.recog.mapping.MapEditDialog;
import cgdp.recog.mapping.MapMenu;
import cgdp.recog.menu.AggregateModeItem;
import cgdp.recog.menu.AggregateModeTool;
import cgdp.recog.menu.AllClusterSelectItem;
import cgdp.recog.menu.ClusterModeItem;
import cgdp.recog.menu.ClusterModeTool;
import cgdp.recog.menu.ExitItem;
import cgdp.recog.menu.FunctionItem;
import cgdp.recog.menu.HZoomSlider;
import cgdp.recog.menu.PageSetupItem;
import cgdp.recog.menu.TaxonomyItem;
import cgdp.recog.menu.TreeCollapseItem;
import cgdp.recog.menu.TreeCollapseTool;
import cgdp.recog.menu.TreeExpandItem;
import cgdp.recog.menu.TreeExpandTool;
import cgdp.recog.menu.VZoomSlider;
import cgdp.recog.mgmap.AlignmentFrame;
import cgdp.recog.multiplealign.MultipleAlignmentFrame;
import cgdp.recog.neighbor.NeighborClustItem;
import cgdp.recog.neighbor.NeighborClustTool;
import cgdp.recog.option.OptionItem;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionTool;
import cgdp.recog.option.OptionValues;
import cgdp.recog.organism.MergeOrganismReleaseItem;
import cgdp.recog.organism.OrganismSplitDialog;
import cgdp.recog.organism.SplitOrganismReleaseItem;
import cgdp.recog.pattern.PatternEditDialog;
import cgdp.recog.ppm.MergeClusterReleaseItem;
import cgdp.recog.ppm.OrganismColumnDialog;
import cgdp.recog.ppm.PPMLabelMenu;
import cgdp.recog.ppm.SplitClusterReleaseItem;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.project.BaseClusterListDialog;
import cgdp.recog.project.DeleteDialog;
import cgdp.recog.project.OpenDialog;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ProjectOpenMenu;
import cgdp.recog.property.PropertyDialog;
import cgdp.recog.property.PropertyItem;
import cgdp.recog.search.ClusterSearchResultDialog;
import cgdp.recog.search.GeneSearchResultDialog;
import cgdp.recog.search.KeywordSearchDialog;
import cgdp.recog.search.KeywordSearchMainItem;
import cgdp.recog.search.KeywordSearchTool;
import cgdp.recog.seq.SeqDownloadDialog;
import cgdp.recog.server.ServerChangeMenu;
import cgdp.recog.set.SetFilterColorDialog;
import cgdp.recog.set.SetListItem;
import cgdp.recog.set.cluster.ClusterSetEditDialog;
import cgdp.recog.set.gene.GeneSetEditDialog;
import cgdp.recog.sort.GeneInfoSortDialog;
import cgdp.recog.sort.PatternCoefDialog;
import cgdp.recog.statusbar.StatusBar;
import cgdp.recog.system.KeyBindUtil;
import cgdp.recog.system.property.ApplicationPropertyDialog;
import cgdp.recog.taxonomy.BaseClusterSearchPanel;
import cgdp.recog.taxonomy.RankSelectPanel;
import cgdp.recog.taxonomy.TaxSearchPanel;
import cgdp.recog.taxonomy.TaxonomyTree;
import cgdp.recog.taxonomy.TaxonomyTreeEx;
import cgdp.recog.taxonomy.map.TaxMapExecuteDialog;
import cgdp.recog.taxonomy.map.TaxMapExecuteItem;
import cgdp.recog.taxonomy.map.TaxMapExecuteTool;
import cgdp.recog.update.DataUpdateDialog;
import cgdp.recog.update.UpdateCheckExecuter;
import cgdp.recog.update.UpdateDatasItem;
import cgdp.recog.url.GeneUrlListDialog;
import cgdp.recog.url.GeneUrlSetItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.JLicenserTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class MainWindow
extends JFrame
implements ActionListener,
Runnable {
    private static final ApplicationLogger logger = new ApplicationLogger(MainWindow.class);
    private MediatorImpl m_mediator;
    private OptionTbl m_optionTbl;
    private JSplitPane m_splitPane1;
    private JSplitPane m_splitPane2;
    private JSplitPane m_splitPane3;
    private JSplitPane m_splitPane4;
    private JSplitPane m_splitPane5;
    private TreeTabbedPane m_treeTabbedPane;
    private InfoTabbedPane m_infoTabbedPane;
    private HZoomSlider m_hZoomSlider;
    private VZoomSlider m_vZoomSlider;
    private BaseClusterSearchPanel m_bcSearchPanel;

    public MainWindow() throws Exception {
        this.clear();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainWindow.this.m_mediator.exit();
            }
        });
        this.m_mediator.setApplicationTitle();
        this.setDefaultCloseOperation(0);
        this.createMenu();
        this.createToolBar();
        this.createDataArea();
        this.pack();
        int n = this.m_infoTabbedPane.getY();
        int n2 = 40;
        this.m_mediator.setPPMHeaderHeight(n, n2);
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        if (optionValues.getMainWindowW() != 0 && optionValues.getMainWindowH() != 0) {
            this.setBounds(optionValues.getMainWindowX(), optionValues.getMainWindowY(), optionValues.getMainWindowW(), optionValues.getMainWindowH());
            if (optionValues.getDividerLocation5() != Integer.MIN_VALUE) {
                this.m_splitPane5.setDividerLocation(optionValues.getDividerLocation5());
            } else {
                this.m_splitPane5.setDividerLocation(optionValues.getMainWindowH() / 10 * 5);
            }
            if (optionValues.getDividerLocation4() != Integer.MIN_VALUE) {
                this.m_splitPane4.setDividerLocation(optionValues.getDividerLocation4());
            }
            if (optionValues.getDividerLocation3() != Integer.MIN_VALUE) {
                this.m_splitPane3.setDividerLocation(optionValues.getDividerLocation3());
            }
            if (optionValues.getDividerLocation2() != Integer.MIN_VALUE) {
                this.m_splitPane2.setDividerLocation(optionValues.getDividerLocation2());
            }
            if (optionValues.getDividerLocation1() != Integer.MIN_VALUE) {
                this.m_splitPane1.setDividerLocation(optionValues.getDividerLocation1());
            }
        }
        this.setTaxonomyView(this.m_optionTbl.getOptionValues().isTaxonomyView(), false);
        this.setFunctionView(this.m_optionTbl.getOptionValues().isFunctionView(), false);
        this.setIconImage(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/frameicon.png")).getImage());
        this.setVisible(true);
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
        this.checkUpdateApplication();
    }

    private void checkUpdateApplication() {
        try {
            UpdateCheckExecuter updateCheckExecuter = UpdateCheckExecuter.createContinuationUpdateCheckExecuter(this, this.m_mediator);
            updateCheckExecuter.setStock(false);
            updateCheckExecuter.execute();
        }
        catch (IOException iOException) {
            logger.warn("Fail to check application update.", iOException);
        }
    }

    private void clear() {
        this.m_mediator = new Mediator();
        this.m_optionTbl = OptionTbl.getInstance();
        this.m_mediator.register(this);
        ColorFacade.createInstance(this.m_mediator);
        FilterFacade.createInstance(this.m_mediator);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new NewMenu(this, this.m_mediator));
        jMenu.add(new ServerChangeMenu(this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new ProjectOpenMenu(this.m_mediator));
        jMenu.add(new FileOpenItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new DomClustSaveServerItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new FileDeleteItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new ImportMenu(this.m_mediator));
        jMenu.add(new ExportMenu(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new MapMenu(this, this.m_mediator, null));
        jMenu.addSeparator();
        jMenu.add(new PageSetupItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new UpdateDatasItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new ExitItem(this, this.m_mediator));
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        jMenu.add(new AggregateModeItem(this, this.m_mediator));
        jMenu.add(new ClusterModeItem(this, this.m_mediator));
        jMenu.add(new TreeExpandItem(this, this.m_mediator));
        jMenu.add(new TreeCollapseItem(this, this.m_mediator));
        jMenu.addSeparator();
        AllClusterSelectItem allClusterSelectItem = new AllClusterSelectItem(this, this.m_mediator);
        allClusterSelectItem.setAccelerator(KeyStroke.getKeyStroke(65, KeyBindUtil.getCtrlMetaMask()));
        jMenu.add(allClusterSelectItem);
        jMenu.addSeparator();
        jMenu.add(new PPMLabelMenu(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new GeneColorItem(this, this.m_mediator));
        jMenu.add(new FuncCatItem(this, this.m_mediator));
        jMenu.add(new HistogramItem(this, this.m_mediator));
        jMenu.addSeparator();
        MergeClusterReleaseItem mergeClusterReleaseItem = new MergeClusterReleaseItem(this, this.m_mediator);
        this.m_mediator.register(mergeClusterReleaseItem);
        mergeClusterReleaseItem.setEnabled(false);
        SplitClusterReleaseItem splitClusterReleaseItem = new SplitClusterReleaseItem(this, this.m_mediator);
        this.m_mediator.register(splitClusterReleaseItem);
        splitClusterReleaseItem.setEnabled(false);
        MergeOrganismReleaseItem mergeOrganismReleaseItem = new MergeOrganismReleaseItem(this, this.m_mediator);
        this.m_mediator.register(mergeOrganismReleaseItem);
        mergeOrganismReleaseItem.setEnabled(false);
        SplitOrganismReleaseItem splitOrganismReleaseItem = new SplitOrganismReleaseItem(this, this.m_mediator);
        this.m_mediator.register(splitOrganismReleaseItem);
        splitOrganismReleaseItem.setEnabled(false);
        jMenu.add(mergeClusterReleaseItem);
        jMenu.add(splitClusterReleaseItem);
        jMenu.add(mergeOrganismReleaseItem);
        jMenu.add(splitOrganismReleaseItem);
        jMenu.addSeparator();
        jMenu.add(new TaxonomyItem(this, this.m_mediator));
        jMenu.add(new FunctionItem(this, this.m_mediator));
        jMenu = new JMenu("Property");
        jMenuBar.add(jMenu);
        jMenu.add(new InfoListItem(this, this.m_mediator, "Gene Property...", 1));
        jMenu.add(new InfoListItem(this, this.m_mediator, "Cell Property...", 3));
        jMenu.add(new InfoListItem(this, this.m_mediator, "Cluster Property...", 2));
        jMenu.addSeparator();
        jMenu.add(new ClusterInfoConvertItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new SetListItem(this, this.m_mediator, "Gene Set...", 1));
        jMenu.add(new SetListItem(this, this.m_mediator, "Cluster Set...", 2));
        jMenu = new JMenu("Tool");
        jMenuBar.add(jMenu);
        jMenu.add(new KeywordSearchMainItem(this, this.m_mediator));
        jMenu.add(new CountFilterItem(this, this.m_mediator));
        jMenu = new JMenu("Run");
        jMenuBar.add(jMenu);
        jMenu.add(new DomClustItem(this, this.m_mediator));
        jMenu.add(new HClustItem(this, this.m_mediator, true));
        jMenu.add(new CoreGenomeItem(this, this.m_mediator));
        jMenu.add(new NeighborClustItem(this, this.m_mediator));
        jMenu.add(new TaxMapExecuteItem(this, this.m_mediator));
        jMenu = new JMenu("Option");
        jMenuBar.add(jMenu);
        jMenu.add(new OptionItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new GeneUrlSetItem(this, this.m_mediator));
        jMenu.addSeparator();
        jMenu.add(new PropertyItem(this, this.m_mediator));
    }

    private void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        jToolBar.add(new FileOpenTool(this, this.m_mediator));
        jToolBar.add(new FileSaveTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new ImportTool(this, this.m_mediator));
        jToolBar.add(new ExportTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new AggregateModeTool(this, this.m_mediator));
        jToolBar.add(new ClusterModeTool(this, this.m_mediator));
        jToolBar.add(new TreeExpandTool(this, this.m_mediator));
        jToolBar.add(new TreeCollapseTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new GeneColorTool(this, this.m_mediator));
        jToolBar.add(new FuncCatTool(this, this.m_mediator));
        jToolBar.add(new HistogramTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new KeywordSearchTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new DomClustTool(this, this.m_mediator));
        jToolBar.add(new HClustTool(this, this.m_mediator));
        jToolBar.add(new CoreGenomeTool(this, this.m_mediator));
        jToolBar.add(new NeighborClustTool(this, this.m_mediator));
        jToolBar.add(new TaxMapExecuteTool(this, this.m_mediator));
        jToolBar.addSeparator();
        jToolBar.add(new OptionTool(this, this.m_mediator));
    }

    private void createDataArea() throws Exception {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel = new JLabel("Vertical Zoom:");
        jPanel2.add(jLabel);
        this.m_vZoomSlider = new VZoomSlider(this.m_mediator);
        jPanel2.add(this.m_vZoomSlider);
        jLabel = new JLabel("Horizontal Zoom:");
        jPanel2.add(jLabel);
        this.m_hZoomSlider = new HZoomSlider(this.m_mediator);
        jPanel2.add(this.m_hZoomSlider);
        GeneNameList geneNameList = new GeneNameList(this.m_mediator);
        GeneInfoList geneInfoList = new GeneInfoList(this.m_mediator);
        this.m_splitPane4 = new JSplitPane(0, geneNameList, geneInfoList);
        ClusterList clusterList = new ClusterList(this.m_mediator);
        this.m_splitPane3 = new JSplitPane(0, clusterList, this.m_splitPane4);
        jPanel2 = new JPanel(new BorderLayout());
        CategoryMap categoryMap = new CategoryMap(this.m_mediator);
        CategoryScrollPane categoryScrollPane = new CategoryScrollPane(this.m_mediator, categoryMap);
        jPanel2.add((Component)categoryScrollPane, "Center");
        CategoryScrollBar categoryScrollBar = new CategoryScrollBar(this.m_mediator);
        jPanel2.add((Component)categoryScrollBar, "East");
        this.m_infoTabbedPane = new InfoTabbedPane(this.m_mediator);
        this.m_infoTabbedPane.add("Info", this.m_splitPane3);
        this.m_infoTabbedPane.add("Histogram", jPanel2);
        this.setEnableHistogramTab(this.m_optionTbl.getOptionValues().isIntensive());
        ClusterArea clusterArea = new ClusterArea(this.m_mediator);
        this.m_splitPane2 = new JSplitPane(1, clusterArea, this.m_infoTabbedPane);
        this.m_splitPane2.setResizeWeight(1.0);
        TaxSearchPanel taxSearchPanel = new TaxSearchPanel(this.m_mediator);
        RankSelectPanel rankSelectPanel = new RankSelectPanel(this.m_mediator);
        TaxonomyTree taxonomyTree = new TaxonomyTree(this.m_mediator);
        JScrollPane jScrollPane = new JScrollPane(taxonomyTree);
        jScrollPane.setBorder(null);
        jScrollPane.setPreferredSize(new Dimension(200, 546));
        jScrollPane.setMinimumSize(new Dimension(200, 200));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.m_bcSearchPanel = new BaseClusterSearchPanel(this.m_mediator);
        jPanel3.add((Component)this.m_bcSearchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        boolean bl = ProjectAccesser.getSelectedProject().isServer();
        this.setEnableBaseClustringSearchPanel(bl);
        jPanel3.add((Component)taxSearchPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)rankSelectPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2 = new JPanel(new BorderLayout());
        TaxonomyTreeEx taxonomyTreeEx = new TaxonomyTreeEx(this.m_mediator);
        JScrollPane jScrollPane2 = new JScrollPane(taxonomyTreeEx);
        jScrollPane2.setBorder(null);
        jScrollPane2.setPreferredSize(new Dimension(200, 546));
        jScrollPane2.setMinimumSize(new Dimension(200, 200));
        ModePanel modePanel = new ModePanel(this.m_mediator);
        TreeOptionPanel treeOptionPanel = new TreeOptionPanel(this, this.m_mediator);
        this.m_mediator.setVisibleForSubTree();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)modePanel, "North");
        jPanel4.add((Component)treeOptionPanel, "Center");
        this.m_splitPane5 = new JSplitPane(0, jScrollPane2, jPanel4);
        jPanel2.add((Component)this.m_splitPane5, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 3, 3));
        jPanel2.add((Component)jPanel5, "South");
        jLabel = new JLabel();
        try {
            jLabel.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/trash.png")));
        }
        catch (Exception exception) {
            jLabel.setText("[Trash]");
        }
        jLabel.setTransferHandler(new LabelTransferHandler(this.m_mediator));
        jPanel5.add(jLabel);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        ClusterTreeMap clusterTreeMap = new ClusterTreeMap(this.m_mediator);
        ClusterTreeScrollPane clusterTreeScrollPane = new ClusterTreeScrollPane(this.m_mediator, clusterTreeMap);
        jPanel6.add((Component)clusterTreeScrollPane, "Center");
        ClusterTreeScrollBar clusterTreeScrollBar = new ClusterTreeScrollBar(this.m_mediator);
        jPanel6.add((Component)clusterTreeScrollBar, "East");
        this.m_treeTabbedPane = new TreeTabbedPane(this.m_mediator);
        this.m_treeTabbedPane.add("All", jPanel3);
        this.m_treeTabbedPane.add("Selected", jPanel2);
        this.m_treeTabbedPane.add("Clustering", jPanel6);
        this.m_treeTabbedPane.setEnabledAt(2, false);
        this.m_splitPane1 = new JSplitPane(1, this.m_treeTabbedPane, this.m_splitPane2);
        jPanel.add((Component)this.m_splitPane1, "Center");
        this.getContentPane().add((Component)new StatusBar(this.m_mediator), "South");
        new AlignmentFrame(this, this.m_mediator);
        new MultipleAlignmentFrame(this, this.m_mediator);
        new GenomeMapFrame(this, this.m_mediator);
        new GeneFrame(this, this.m_mediator);
        OpenDialog.createOpenDialog(this, this.m_mediator);
        DeleteDialog.createDeleteDialog(this, this.m_mediator);
        PropertyDialog.createInstance(this, this.m_mediator);
        GeneInfoSortDialog.createInstance(this, this.m_mediator);
        GeneUrlListDialog.createInstance(this);
        KeywordSearchDialog.createInstance(this, this.m_mediator);
        GeneSearchResultDialog.createInstance(this, this.m_mediator);
        ClusterSearchResultDialog.createInstance(this, this.m_mediator);
        HistogramDialog.createInstance(this, this.m_mediator);
        DataUpdateDialog.createInstance(this);
        GeneSetEditDialog.createInstance(this, this.m_mediator);
        ClusterSetEditDialog.createInstance(this, this.m_mediator);
        CountFilterDialog.creasteInstance(this);
        SeqDownloadDialog.createInstance(this);
        SetFilterColorDialog.createInstance(this);
        FileAccessFacade.createInstance(this, this.m_mediator);
        CoefDialog.createInstance(this, this.m_mediator);
        PatternEditDialog.createInstance(this);
        MapEditDialog.createInstance(this);
        OrganismColumnDialog.createInstance(this);
        PatternCoefDialog.createInstance(this, this.m_mediator);
        HClustDialog.createInstance(this, this.m_mediator);
        ApplicationPropertyDialog.createInstance(this);
        ClusterInfoConvertDialog.createIntance(this);
        OrganismSplitDialog.createInstance(this);
        TaxMapExecuteDialog.createInstance(this, this.m_mediator);
        BaseClusterListDialog.createBaseClusterListDialog(this, this.m_mediator);
    }

    public void setTaxonomyView(boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                this.m_treeTabbedPane.setVisible(true);
                this.m_splitPane1.setDividerSize(5);
                int n = this.m_optionTbl.getOptionValues().getLastDividerLocation1();
                if (n != Integer.MIN_VALUE) {
                    this.m_splitPane1.setDividerLocation(n);
                }
            } else {
                this.m_optionTbl.getOptionValues().setLastDividerLocation1(this.m_splitPane1.getDividerLocation());
                this.m_treeTabbedPane.setVisible(false);
                this.m_splitPane1.setDividerSize(0);
            }
        } else {
            this.m_treeTabbedPane.setVisible(bl);
            this.m_splitPane1.setDividerSize(bl ? 5 : 0);
        }
        this.m_optionTbl.getOptionValues().setTaxonomyView(bl);
    }

    public void setFunctionView(boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                this.m_infoTabbedPane.setVisible(true);
                this.m_splitPane2.setDividerSize(5);
                int n = this.m_optionTbl.getOptionValues().getLastDividerLocation2();
                if (n != Integer.MIN_VALUE) {
                    Insets insets = this.m_splitPane2.getInsets();
                    int n2 = this.m_splitPane2.getSize().width;
                    n2 -= 5;
                    n2 -= this.m_splitPane2.getRightComponent().getMinimumSize().width;
                    if (insets != null) {
                        n2 -= insets.right;
                    }
                    this.m_splitPane2.setDividerLocation(n < n2 ? n : n2);
                }
            } else {
                this.m_optionTbl.getOptionValues().setLastDividerLocation2(this.m_splitPane2.getDividerLocation());
                this.m_infoTabbedPane.setVisible(false);
                this.m_splitPane2.setDividerSize(0);
            }
        } else {
            this.m_infoTabbedPane.setVisible(bl);
            this.m_splitPane2.setDividerSize(bl ? 5 : 0);
        }
        this.m_optionTbl.getOptionValues().setFunctionView(bl);
    }

    public void setEnableClusteringTab(boolean bl) {
        if (!bl && this.m_treeTabbedPane.getSelectedIndex() == 2) {
            if (this.m_mediator.getTaxonomyCount() == 0) {
                this.m_treeTabbedPane.setSelectedIndex(0);
            } else {
                this.m_treeTabbedPane.setSelectedIndex(1);
            }
        }
        this.m_treeTabbedPane.setEnabledAt(2, bl);
    }

    public void setEnableHistogramTab(boolean bl) {
        this.m_infoTabbedPane.setEnabledAt(1, true);
    }

    public void setEnableBaseClustringSearchPanel(boolean bl) {
        this.m_bcSearchPanel.setEnabled(bl);
    }

    public void setSelectClusteringTab() {
        this.m_treeTabbedPane.setSelectedIndex(2);
    }

    public JSplitPane getSplitPane1() {
        return this.m_splitPane1;
    }

    public JSplitPane getSplitPane2() {
        return this.m_splitPane2;
    }

    public JSplitPane getSplitPane3() {
        return this.m_splitPane3;
    }

    public JSplitPane getSplitPane4() {
        return this.m_splitPane4;
    }

    public JSplitPane getSplitPane5() {
        return this.m_splitPane5;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public JSlider getVZoomSlider() {
        return this.m_vZoomSlider;
    }

    public JSlider getHZoomSlider() {
        return this.m_hZoomSlider;
    }

    @Override
    public void run() {
        try {
            do {
                Thread.sleep(200L);
            } while (!this.isShowing());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.repaint();
    }
}

