/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorDrawable;
import cgdp.recog.color.ColorEnableItem;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.color.ColorMultiEnableItem;
import cgdp.recog.color.ColorSetConditionDeleteItem;
import cgdp.recog.color.ColorTreeNode;
import cgdp.recog.color.DefaultColorEditItem;
import cgdp.recog.color.GeneCountColorEditItem;
import cgdp.recog.color.NeighboringClusterColorEditItem;
import cgdp.recog.color.PropertyColorEditItem;
import cgdp.recog.color.SetColorDrawable;
import cgdp.recog.color.geneinfo.GeneColorDeleteItem;
import cgdp.recog.controltree.ControlTitleNode;
import cgdp.recog.controltree.ControlTitleType;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.search.KeywordSearchItem;
import cgdp.recog.search.KeywordSearchResultItem;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupColorTreeNode;
import cgdp.recog.set.ElementSetGroupTreeNode;
import cgdp.recog.set.SetCondElementDeleteItem;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.color.SetFilerColorItem;
import cgdp.recog.tree.AbstractTreeController;
import cgdp.recog.util.CollectionUtil;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ColorTreeController
extends AbstractTreeController {
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;

    public ColorTreeController(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public void createTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        ColorFacade colorFacade = ColorFacade.getInstance();
        List list = colorFacade.getColorOrderList();
        Map map = colorFacade.getColorDrawableMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            List list2 = (List)map.get(new Integer(n));
            if (CollectionUtil.isNull(list2)) continue;
            if (ControlTitleType.isColorGeneSet(n)) {
                this.createColorSetTree(defaultMutableTreeNode, list2, "Gene Set", 36);
                continue;
            }
            if (ControlTitleType.isColorClusterSet(n)) {
                this.createColorSetTree(defaultMutableTreeNode, list2, "Cluster Set", 37);
                continue;
            }
            ColorDrawable colorDrawable = (ColorDrawable)list2.get(0);
            ColorTreeNode colorTreeNode = new ColorTreeNode(colorDrawable);
            defaultMutableTreeNode.add(colorTreeNode);
        }
    }

    @Override
    public JPopupMenu createPopupMenu(JTree jTree, ActionListener actionListener) {
        SetCondition setCondition;
        Object object;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.isShowSearchMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            jPopupMenu.add(new KeywordSearchItem(actionListener, this.mediator));
            jPopupMenu.add(new KeywordSearchResultItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorEnableItem(actionListener, this.mediator, ((ColorTreeNode)defaultMutableTreeNode).getColorDrawable()));
        }
        if (this.isShowNeighboringClusterMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            jPopupMenu.add(new NeighboringClusterColorEditItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorEnableItem(actionListener, this.mediator, ((ColorTreeNode)defaultMutableTreeNode).getColorDrawable()));
        }
        if (this.isShowPropertyColorMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            jPopupMenu.add(new PropertyColorEditItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorEnableItem(actionListener, this.mediator, ((ColorTreeNode)defaultMutableTreeNode).getColorDrawable()));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new GeneColorDeleteItem(actionListener, this.mediator));
        }
        if (this.isSelectableGeneCountColorEditMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            jPopupMenu.add(new GeneCountColorEditItem(actionListener, this.mediator));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorEnableItem(actionListener, this.mediator, ((ColorTreeNode)defaultMutableTreeNode).getColorDrawable()));
        }
        if (this.isShowGeneSetMenu(treePathArray) || this.isShowClusterSetMenu(treePathArray)) {
            defaultMutableTreeNode = (ControlTitleNode)treePathArray[0].getLastPathComponent();
            object2 = this.getAccessableList((ControlTitleNode)defaultMutableTreeNode);
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object2, 1));
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object2, 2));
        }
        if (this.isShowGeneSetTitleMenu(treePathArray) || this.isShowClusterSetTitleMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            object2 = (SetColorDrawable)((ColorTreeNode)defaultMutableTreeNode).getColorDrawable();
            object = this.getAccessableList((ControlTitleNode)defaultMutableTreeNode);
            setCondition = ((SetColorDrawable)object2).getSetCondition();
            jPopupMenu.add(new SetFilerColorItem(actionListener, this.mediator, setCondition));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object, 1));
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object, 2));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorSetConditionDeleteItem(actionListener, this.mediator, setCondition));
        }
        if (this.isShowGeneSetConditionMenu(treePathArray) || this.isShowClusterSetConditionMenu(treePathArray)) {
            defaultMutableTreeNode = (ElementSetGroupColorTreeNode)treePathArray[0].getLastPathComponent();
            object2 = (ColorTreeNode)defaultMutableTreeNode.getParent();
            object = (SetColorDrawable)((ColorTreeNode)object2).getColorDrawable();
            setCondition = ((SetColorDrawable)object).getSetCondition();
            List list = this.getElementSetGroupList(setCondition, treePathArray);
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, list, 1));
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, list, 2));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new SetCondElementDeleteItem(actionListener, this.mediator, setCondition, list));
        }
        if (this.isSelectableDefaultColorEditMenu(treePathArray)) {
            defaultMutableTreeNode = (ColorTreeNode)treePathArray[0].getLastPathComponent();
            jPopupMenu.add(new DefaultColorEditItem(actionListener, this.mediator));
            jPopupMenu.add(new ColorEnableItem(actionListener, this.mediator, ((ColorTreeNode)defaultMutableTreeNode).getColorDrawable()));
        }
        if (this.isShowColorMenu(treePathArray)) {
            defaultMutableTreeNode = (ControlTitleNode)treePathArray[0].getLastPathComponent();
            object2 = this.getAccessableList((ControlTitleNode)defaultMutableTreeNode);
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object2, 1));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new ColorMultiEnableItem(actionListener, this.mediator, (List)object2, 2));
        }
        return jPopupMenu;
    }

    private List getElementSetGroupList(SetCondition setCondition, TreePath[] treePathArray) {
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        for (int i = 0; i < treePathArray.length; ++i) {
            ElementSetGroupColorTreeNode elementSetGroupColorTreeNode;
            ColorTreeNode colorTreeNode;
            SetCondition setCondition2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ElementSetGroupColorTreeNode) || !(setCondition2 = ((SetColorDrawable)(colorTreeNode = (ColorTreeNode)(elementSetGroupColorTreeNode = (ElementSetGroupColorTreeNode)defaultMutableTreeNode).getParent()).getColorDrawable()).getSetCondition()).equals(setCondition)) continue;
            arrayList.add(elementSetGroupColorTreeNode.getElementSetGroup());
        }
        return arrayList;
    }

    private List getAccessableList(ControlTitleNode controlTitleNode) {
        ArrayList<ColorActivation> arrayList = new ArrayList<ColorActivation>();
        Enumeration<TreeNode> enumeration = controlTitleNode.children();
        while (enumeration.hasMoreElements()) {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode instanceof ColorTreeNode) {
                object = (ColorTreeNode)defaultMutableTreeNode;
                if (((ColorTreeNode)object).isColorDefault()) continue;
                arrayList.add(((ColorTreeNode)object).getColorDrawable());
                continue;
            }
            if (defaultMutableTreeNode instanceof ControlTitleNode) {
                object = this.getAccessableList((ControlTitleNode)defaultMutableTreeNode);
                arrayList.addAll((Collection<ColorActivation>)object);
                continue;
            }
            if (!(defaultMutableTreeNode instanceof ElementSetGroupColorTreeNode)) continue;
            object = (ElementSetGroupColorTreeNode)defaultMutableTreeNode;
            arrayList.add(((ElementSetGroupTreeNode)object).getElementSetGroup());
        }
        return arrayList;
    }

    private boolean isShowColorMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 2) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isColor(controlTitleNode.getControlTitleType());
    }

    private boolean isShowSearchMenu(TreePath[] treePathArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return colorTreeNode.isColorSearch();
    }

    private boolean isShowGeneSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isColorGeneSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowGeneSetTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return ControlTitleType.isColorGeneSet(colorTreeNode.getControlTitleType());
    }

    private boolean isShowGeneSetConditionMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(4);
        if (!(defaultMutableTreeNode instanceof ElementSetGroupColorTreeNode)) {
            return false;
        }
        ElementSetGroupColorTreeNode elementSetGroupColorTreeNode = (ElementSetGroupColorTreeNode)defaultMutableTreeNode;
        return elementSetGroupColorTreeNode.isGeneSet();
    }

    private boolean isShowClusterSetMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 3) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        if (!(defaultMutableTreeNode instanceof ControlTitleNode)) {
            return false;
        }
        ControlTitleNode controlTitleNode = (ControlTitleNode)defaultMutableTreeNode;
        return ControlTitleType.isColorClusterSet(controlTitleNode.getControlTitleType());
    }

    private boolean isShowClusterSetTitleMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() != 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(3);
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return ControlTitleType.isColorClusterSet(colorTreeNode.getControlTitleType());
    }

    private boolean isShowClusterSetConditionMenu(TreePath[] treePathArray) {
        if (treePathArray[0].getPathCount() <= 4) {
            return false;
        }
        TreePath treePath = treePathArray[0];
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(4);
        if (!(defaultMutableTreeNode instanceof ElementSetGroupColorTreeNode)) {
            return false;
        }
        ElementSetGroupColorTreeNode elementSetGroupColorTreeNode = (ElementSetGroupColorTreeNode)defaultMutableTreeNode;
        return elementSetGroupColorTreeNode.isClusterSet();
    }

    private boolean isShowNeighboringClusterMenu(TreePath[] treePathArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return colorTreeNode.isColorNeighbor();
    }

    private boolean isShowPropertyColorMenu(TreePath[] treePathArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return colorTreeNode.isColorProperty();
    }

    private boolean isSelectableGeneCountColorEditMenu(TreePath[] treePathArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return colorTreeNode.isColorGeneCount();
    }

    private boolean isSelectableDefaultColorEditMenu(TreePath[] treePathArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof ColorTreeNode)) {
            return false;
        }
        ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
        return colorTreeNode.isColorDefault();
    }

    private void createColorSetTree(DefaultMutableTreeNode defaultMutableTreeNode, List list, String string, int n) {
        ControlTitleNode controlTitleNode = new ControlTitleNode(string, n);
        for (SetColorDrawable setColorDrawable : list) {
            SetCondition setCondition = setColorDrawable.getSetCondition();
            ColorTreeNode colorTreeNode = new ColorTreeNode(setColorDrawable);
            for (ElementSetGroup elementSetGroup : setCondition.getElementSetGroupList()) {
                ElementSetGroupColorTreeNode elementSetGroupColorTreeNode = new ElementSetGroupColorTreeNode(elementSetGroup);
                colorTreeNode.add(elementSetGroupColorTreeNode);
            }
            controlTitleNode.add(colorTreeNode);
        }
        defaultMutableTreeNode.add(controlTitleNode);
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public void actionAfterDoubleClick(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode instanceof ColorTreeNode && defaultMutableTreeNode.isLeaf()) {
            ColorTreeNode colorTreeNode = (ColorTreeNode)defaultMutableTreeNode;
            ColorDrawable colorDrawable = colorTreeNode.getColorDrawable();
            this.mediator.activeColor(colorDrawable);
        } else if (defaultMutableTreeNode instanceof ElementSetGroupColorTreeNode) {
            ElementSetGroupColorTreeNode elementSetGroupColorTreeNode = (ElementSetGroupColorTreeNode)defaultMutableTreeNode;
            this.mediator.activeColor(elementSetGroupColorTreeNode.getElementSetGroup());
        }
    }
}

