/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.color.geneinfo;

import cgdp.recog.color.geneinfo.ColorValue;
import cgdp.recog.color.geneinfo.GenePropertySummary;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

class ColorBarPanel
extends JPanel {
    private static final Dimension PANEL_SIZE = new Dimension(400, 30);
    private List colorValueList = new ArrayList();
    private GenePropertySummary summary;
    private ColorBarRenderer colorBarRenderer = new ColorBarRenderer();

    public ColorBarPanel() {
        this.setPreferredSize(PANEL_SIZE);
    }

    public void updateValue(List list, GenePropertySummary genePropertySummary) {
        this.colorValueList = list;
        this.summary = genePropertySummary;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.colorBarRenderer.draw((Graphics2D)graphics);
    }

    private class ColorBarRenderer {
        private ColorBarRenderer() {
        }

        public void draw(Graphics2D graphics2D) {
            double d;
            int n;
            int n2;
            int n3;
            if (ColorBarPanel.this.colorValueList.isEmpty()) {
                return;
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            double d2 = fontMetrics.stringWidth("Min");
            double d3 = fontMetrics.stringWidth("Max");
            Dimension dimension = ColorBarPanel.this.getSize();
            double d4 = dimension.getWidth() - (d2 + d3);
            double d5 = ColorBarPanel.this.summary.getLength();
            int n4 = 14;
            double d6 = d2;
            ColorValue colorValue = (ColorValue)ColorBarPanel.this.colorValueList.get(0);
            double d7 = ColorBarPanel.this.summary.getValue(colorValue.getValueAsDouble(), 1);
            if (d7 - ColorBarPanel.this.summary.getMinValue() > 0.0) {
                graphics2D.setPaint(colorValue.getColor());
                n3 = (int)((d7 - ColorBarPanel.this.summary.getMinValue()) / d5 * d4);
                graphics2D.fill(new Rectangle2D.Double(d6, n4, n3, dimension.getHeight()));
                d6 = (double)n3 + d6;
            }
            for (n3 = 0; n3 < ColorBarPanel.this.colorValueList.size(); ++n3) {
                if (n3 == 0) continue;
                ColorValue colorValue2 = (ColorValue)ColorBarPanel.this.colorValueList.get(n3 - 1);
                ColorValue colorValue3 = (ColorValue)ColorBarPanel.this.colorValueList.get(n3);
                n2 = 2;
                if (n3 - 1 == 0) {
                    n2 = 1;
                }
                n = 2;
                if (n3 == ColorBarPanel.this.colorValueList.size() - 1) {
                    n = 3;
                }
                double d8 = ColorBarPanel.this.summary.getValue(colorValue2.getValueAsDouble(), n2);
                double d9 = ColorBarPanel.this.summary.getValue(colorValue3.getValueAsDouble(), n);
                d8 = this.adjustValue(d8);
                d9 = this.adjustValue(d9);
                d = (d9 - d8) / d5 * d4;
                GradientPaint gradientPaint = new GradientPaint((float)d6, 0.0f, colorValue2.getColor(), (float)(d6 + d), 0.0f, colorValue3.getColor());
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(new Rectangle2D.Double(d6, n4, d, dimension.getHeight()));
                d6 += d;
            }
            ColorValue colorValue4 = (ColorValue)ColorBarPanel.this.colorValueList.get(ColorBarPanel.this.colorValueList.size() - 1);
            double d10 = ColorBarPanel.this.summary.getValue(colorValue4.getValueAsDouble(), 3);
            if (ColorBarPanel.this.summary.getMaxValue() - d10 > 0.0) {
                graphics2D.setPaint(colorValue4.getColor());
                n2 = (int)((ColorBarPanel.this.summary.getMaxValue() - d10) / d5 * d4);
                graphics2D.fill(new Rectangle2D.Double(d6, n4, n2, dimension.getHeight()));
            }
            Shape shape = this.createReverseTriangle();
            n = (int)((ColorBarPanel.this.summary.getAveValue() - ColorBarPanel.this.summary.getMinValue()) / d5 * d4 + d2);
            int n5 = n4 - 3;
            graphics2D.translate(n, n5);
            graphics2D.setColor(Color.red);
            graphics2D.fill(shape);
            graphics2D.translate(-n, -n5);
            n = (int)((ColorBarPanel.this.summary.getMedianValue() - ColorBarPanel.this.summary.getMinValue()) / d5 * d4 + d2);
            graphics2D.translate(n, n5);
            graphics2D.setColor(Color.blue);
            graphics2D.fill(shape);
            graphics2D.translate(-n, -n5);
            graphics2D.setColor(Color.black);
            n5 = (int)(dimension.getHeight() - 1.0);
            graphics2D.drawString("Min", 0, n5);
            graphics2D.drawString("Max", (int)(dimension.getWidth() - d3 + 1.0), n5);
            for (int i = 0; i < ColorBarPanel.this.colorValueList.size(); ++i) {
                ColorValue colorValue5 = (ColorValue)ColorBarPanel.this.colorValueList.get(i);
                int n6 = i == 0 ? 1 : (i == ColorBarPanel.this.colorValueList.size() - 1 ? 3 : 2);
                d = ColorBarPanel.this.summary.getValue(colorValue5.getValueAsDouble(), n6);
                int n7 = (int)((d - ColorBarPanel.this.summary.getMinValue()) / d5 * d4 + d2);
                if ((double)n7 > d4 - (double)graphics2D.getFontMetrics().stringWidth(String.valueOf(i + 1)) + d2) {
                    n7 = (int)(d4 - (double)graphics2D.getFontMetrics().stringWidth(String.valueOf(i + 1)) + d2);
                }
                graphics2D.drawString(String.valueOf(i + 1), n7, 10);
            }
        }

        private double adjustValue(double d) {
            double d2 = d;
            if (d < ColorBarPanel.this.summary.getMinValue()) {
                d2 = ColorBarPanel.this.summary.getMinValue();
            } else if (d > ColorBarPanel.this.summary.getMaxValue()) {
                d2 = ColorBarPanel.this.summary.getMaxValue();
            }
            return d2;
        }

        private Shape createReverseTriangle() {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(7.0f, 0.0f);
            generalPath.lineTo(3.0f, 4.0f);
            generalPath.closePath();
            return generalPath;
        }
    }
}

