/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FoldCoreGenomeContext;
import cgdp.recog.coregenome.FoldCoreGenomeRenderer;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.LegendContext;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;

class CoreGenomePrintDriver {
    private static final double DEFAULT_ZOOM_SCALE = 0.5;
    private PageFormat pageFormat;
    private CoreGenomeViewModel coreGenomeViewModel;

    CoreGenomePrintDriver(PageFormat pageFormat, CoreGenomeViewModel coreGenomeViewModel) {
        this.pageFormat = pageFormat;
        this.coreGenomeViewModel = coreGenomeViewModel;
    }

    int calcRowCountForOnePage() {
        double d;
        double d2;
        FoldCoreGenomeRenderer foldCoreGenomeRenderer = CoreGenomePrintDriver.createCoreGenomeRenderer(this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight(), this.coreGenomeViewModel);
        FoldCoreGenomeContext foldCoreGenomeContext = foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        int n = 1;
        double d3 = 2.0;
        double d4 = 3.0;
        double d5 = 0.0;
        while (d4 >= d3) {
            d5 = d4;
            d2 = this.calcTotalRowHeightFromImageable(foldCoreGenomeContext, n);
            d = foldCoreGenomeRenderer.calcHeight();
            d4 = d2 / d;
            double d6 = this.calcTotalRowWidthFromImageable(foldCoreGenomeContext, n);
            foldCoreGenomeContext.setOrganismNameWidth(foldCoreGenomeRenderer.calcVirtualOrganismNameSize());
            double d7 = this.calcTotalRowWidthFromContext(foldCoreGenomeContext, n);
            d3 = d6 / d7;
            ++n;
        }
        d5 = this.adjustZoomScale(d5, foldCoreGenomeContext);
        foldCoreGenomeContext.zoom(d5);
        d2 = foldCoreGenomeRenderer.calcHeight();
        d = this.getRowHeightFromImageable(foldCoreGenomeContext);
        int n2 = (int)Math.ceil(d / d2);
        return n2;
    }

    private double adjustZoomScale(double d, CoreGenomeContext coreGenomeContext) {
        if (d > 0.5) {
            d = 0.5;
        }
        return d;
    }

    private double calcZoomScale(FoldCoreGenomeRenderer foldCoreGenomeRenderer, int n) {
        FoldCoreGenomeContext foldCoreGenomeContext = foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        double d = this.calcTotalRowHeightFromImageable(foldCoreGenomeContext, n);
        double d2 = foldCoreGenomeRenderer.calcHeight();
        double d3 = d / d2;
        return d3;
    }

    private double calcGraphhicsZoomScale(FoldCoreGenomeContext foldCoreGenomeContext, double d) {
        double d2 = foldCoreGenomeContext.getMinmumZoomScale();
        double d3 = 1.0;
        if (d < d2) {
            d3 = d / d2;
        }
        return d3;
    }

    FoldCoreGenomeRenderer createCoreGenomeRenderer(int n) {
        FoldCoreGenomeRenderer foldCoreGenomeRenderer = CoreGenomePrintDriver.createCoreGenomeRenderer(this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight(), this.coreGenomeViewModel);
        FoldCoreGenomeContext foldCoreGenomeContext = foldCoreGenomeRenderer.getFoldCoreGenomeContext();
        double d = this.calcZoomScale(foldCoreGenomeRenderer, n);
        double d2 = this.calcGraphhicsZoomScale(foldCoreGenomeContext, d);
        d = d < foldCoreGenomeContext.getMinmumZoomScale() ? foldCoreGenomeContext.getMinmumZoomScale() : d;
        foldCoreGenomeContext.setRowCountParPage(n);
        foldCoreGenomeContext.setPageIndex(0);
        foldCoreGenomeContext.zoom(d);
        foldCoreGenomeContext.setScaleX(d2);
        foldCoreGenomeContext.setScaleY(d2);
        LegendContext legendContext = foldCoreGenomeContext.getLegendContext();
        int n2 = legendContext.calcColumnCount(foldCoreGenomeRenderer.calcHeight());
        legendContext.setColumnCount(n2);
        foldCoreGenomeContext.setOrganismNameWidth(foldCoreGenomeRenderer.calcVirtualOrganismNameSize());
        this.calcFoldPoint(foldCoreGenomeContext, this.coreGenomeViewModel.getGenomeAlign());
        double d3 = (double)foldCoreGenomeContext.getLastColumnCount() * foldCoreGenomeContext.getDirectionWidth() * d2;
        if (this.coreGenomeViewModel.isAllRowShowOrganismName()) {
            d3 += foldCoreGenomeContext.getGeneNameStartX();
        }
        double d4 = this.pageFormat.getImageableWidth() - d3;
        legendContext.setNameWidth(legendContext.calcNameWidth());
        double d5 = legendContext.calcWidth(n2);
        if (d4 <= d5) {
            legendContext.setDrawNewLineRow(true);
            if (foldCoreGenomeContext.getTotalRowCount() % n == 0) {
                if (this.coreGenomeViewModel.isOnePagePrintFlag()) {
                    return this.createCoreGenomeRenderer(n + 1);
                }
                legendContext.setShowNextPageLegend(true);
            }
            double d6 = 1.0;
            if (this.pageFormat.getImageableWidth() < d5) {
                d6 = (this.pageFormat.getImageableWidth() + 10.0) / d5;
                if (d < 1.0) {
                    legendContext.zoom(d * d6);
                } else {
                    legendContext.zoom(d6);
                }
            }
        }
        return foldCoreGenomeRenderer;
    }

    private double calcTotalRowHeightFromImageable(CoreGenomeContext coreGenomeContext, int n) {
        return this.getRowHeightFromImageable(coreGenomeContext) / (double)n;
    }

    private double getRowHeightFromImageable(CoreGenomeContext coreGenomeContext) {
        return this.pageFormat.getImageableHeight() - (coreGenomeContext.getMarginTop() + coreGenomeContext.getMarginBottom());
    }

    private double calcTotalRowWidthFromImageable(CoreGenomeContext coreGenomeContext, int n) {
        return this.getRowWidthFromImageable(coreGenomeContext) * (double)n;
    }

    private double getRowWidthFromImageable(CoreGenomeContext coreGenomeContext) {
        return this.pageFormat.getImageableWidth() - coreGenomeContext.getMarginLeft() - coreGenomeContext.getMarginRight();
    }

    private double calcTotalRowWidthFromContext(CoreGenomeContext coreGenomeContext, int n) {
        int n2 = this.coreGenomeViewModel.isAllRowShowOrganismName() ? n : 1;
        GenomeAlign genomeAlign = this.coreGenomeViewModel.getGenomeAlign();
        return (coreGenomeContext.getOrganismNameWidth() + coreGenomeContext.getOrthologGroupIntervalX()) * (double)n2 + coreGenomeContext.calcMatrixWidth(genomeAlign.getOrthologGroupSize(), genomeAlign.getClusterCount());
    }

    private static FoldCoreGenomeRenderer createCoreGenomeRenderer(double d, double d2, CoreGenomeViewModel coreGenomeViewModel) {
        FoldCoreGenomeContext foldCoreGenomeContext = new FoldCoreGenomeContext();
        foldCoreGenomeContext.setBaseMarginTop(0.0);
        foldCoreGenomeContext.setBaseMarginBottom(20.0);
        foldCoreGenomeContext.setBaseMarginLeft(0.0);
        foldCoreGenomeContext.setBaseMarginRight(0.0);
        foldCoreGenomeContext.setImageableWidth(d);
        foldCoreGenomeContext.setImageableHeight(d2);
        foldCoreGenomeContext.setCanvasWidth(d);
        foldCoreGenomeContext.setCanvasHeight(d2);
        foldCoreGenomeContext.setOrthologGroupStartIndex(coreGenomeViewModel.getOverviewCoreGenomeContext().getOrthologGroupStartIndex());
        FoldCoreGenomeRenderer foldCoreGenomeRenderer = new FoldCoreGenomeRenderer();
        foldCoreGenomeRenderer.setModel(coreGenomeViewModel, foldCoreGenomeContext);
        return foldCoreGenomeRenderer;
    }

    private void calcFoldPoint(FoldCoreGenomeContext foldCoreGenomeContext, GenomeAlign genomeAlign) {
        int n;
        List list = this.coreGenomeViewModel.getOrhotlogGroupLabelList();
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        float f = (float)foldCoreGenomeContext.getGeneNameStartX();
        int n5 = foldCoreGenomeContext.convertOrthologGroupStartIndex(-1, genomeAlign.getOrthologGroupSize());
        int n6 = genomeAlign.getOrthologGroup(n5).getClusterNo();
        int n7 = 0;
        for (n = 0; n < genomeAlign.getOrthologGroupSize(); ++n) {
            n5 = foldCoreGenomeContext.convertOrthologGroupStartIndex(n, genomeAlign.getOrthologGroupSize());
            int n8 = genomeAlign.getOrthologGroup(n5).getClusterNo();
            if (n6 != Integer.MIN_VALUE && n6 != n8 && n != 0) {
                f = (float)((double)f + foldCoreGenomeContext.getClusterBlankWidth());
                ++n7;
            }
            n6 = n8;
            String string = (String)list.get(n5);
            double d = foldCoreGenomeContext.calcVirtualGeneNameWidth(string);
            if (((double)f + d) * foldCoreGenomeContext.getScaleX() > foldCoreGenomeContext.getCanvasWidth()) {
                if (n2 == -1) {
                    n4 = n5;
                    n2 = n7;
                } else if (n3 > n7) {
                    n3 = n7;
                }
                f = this.coreGenomeViewModel.isAllRowShowOrganismName() ? (float)foldCoreGenomeContext.getGeneNameStartX() : 0.0f;
                n7 = 0;
            } else {
                f = (float)((double)f + foldCoreGenomeContext.getDirectionWidth());
            }
            ++n7;
        }
        n = 0;
        if (n4 == -1) {
            n4 = n5 + 1;
            n2 = n7;
            n = 1;
        }
        if (n3 == Integer.MAX_VALUE) {
            n7 = 0;
            f = 0.0f;
            String string = (String)list.get(n5);
            double d = foldCoreGenomeContext.calcVirtualGeneNameWidth(string);
            while (((double)f + d) * foldCoreGenomeContext.getScaleX() < foldCoreGenomeContext.getCanvasWidth()) {
                f = (float)((double)f + foldCoreGenomeContext.getDirectionWidth());
                ++n7;
            }
            n3 = n7;
        }
        if (this.coreGenomeViewModel.isAllRowShowOrganismName()) {
            if (n3 < n2) {
                n4 -= n2 - n3;
                n2 = n3;
            } else if (n3 > n2) {
                n3 = n2;
            }
        }
        double d = 0.0;
        d = n != 0 ? foldCoreGenomeContext.getGeneNameStartX() : (this.coreGenomeViewModel.isAllRowShowOrganismName() ? foldCoreGenomeContext.getGeneNameStartX() : foldCoreGenomeContext.getOrthologGroupWidth() * (double)(n3 - n2) + foldCoreGenomeContext.getMarginLeft() + foldCoreGenomeContext.getOrthologGroupIntervalX());
        foldCoreGenomeContext.setMatrixStartX(d);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(foldCoreGenomeContext.getOrthologGroupStartIndex()));
        int n9 = genomeAlign.getOrthologGroupCount(foldCoreGenomeContext.getOrthologGroupStartIndex(), n2, this.coreGenomeViewModel.getOverviewCoreGenomeContext().getOrthologGroupStartIndex());
        arrayList.add(new Integer(n4));
        int n10 = 1;
        int n11 = n4;
        int n12 = n2 - 1;
        int n13 = genomeAlign.getOrthologGroupSize();
        n13 -= n9;
        int n14 = -1;
        while (true) {
            if (n13 - n3 < 0) {
                if (n13 == 0) {
                    if (n10 == 1) {
                        n14 = n2;
                        break;
                    }
                    n14 = n3;
                    break;
                }
                n11 += n13;
                n14 = genomeAlign.getColumnSize() - (n12 + 1);
                ++n10;
                break;
            }
            n9 = genomeAlign.getOrthologGroupCount(n12, n3, this.coreGenomeViewModel.getOverviewCoreGenomeContext().getOrthologGroupStartIndex());
            if ((n11 += n9) >= this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize()) {
                n11 -= this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize();
            }
            arrayList.add(new Integer(n11));
            n13 -= n9;
            n12 += n3;
            ++n10;
        }
        foldCoreGenomeContext.setFirstColumnCount(n2);
        foldCoreGenomeContext.setOtherColumnCount(n3);
        foldCoreGenomeContext.setLastColumnCount(n14);
        foldCoreGenomeContext.setFoldPointList(arrayList);
        foldCoreGenomeContext.setTotalRowCount(n10);
    }
}

