/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeChangeStartIndexEvent;
import cgdp.recog.coregenome.CoreGenomeSearch;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.util.FocusTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class CoreGenomeSearchPanel
extends JPanel
implements ActionListener {
    private static final int WIDTH = 400;
    private static final String SEARCH_TYPE_STR_GENE_NAME = "Gene Name";
    private static final String SEARCH_TYPE_STR_LOCUS_TAG = "Locus Tag";
    private static final String SEARCH_TYPE_STR_BOTH = "Both";
    private static final String[] SEARCH_TYPE_STRINGS = new String[]{"Both", "Gene Name", "Locus Tag"};
    private CoreGenomeViewModel coreGenomeViewModel;
    private FocusTextField keywordTextField;
    private JComboBox typeComboBox;
    private JButton searchButton;

    CoreGenomeSearchPanel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.init();
    }

    private void init() {
        this.keywordTextField = new FocusTextField();
        this.keywordTextField.addActionListener(this);
        this.typeComboBox = new JComboBox<String>(SEARCH_TYPE_STRINGS);
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.keywordTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.typeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.searchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        Dimension dimension = new Dimension(400, this.getPreferredSize().height);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    private boolean check() {
        return true;
    }

    private int getSearchType() {
        String string = (String)this.typeComboBox.getSelectedItem();
        int n = 1;
        if (string.equals(SEARCH_TYPE_STR_GENE_NAME)) {
            n = 1;
        } else if (string.equals(SEARCH_TYPE_STR_LOCUS_TAG)) {
            n = 2;
        } else if (string.equals(SEARCH_TYPE_STR_BOTH)) {
            n = 3;
        }
        return n;
    }

    private void search() {
        if (!this.check()) {
            return;
        }
        CoreGenomeSearch coreGenomeSearch = this.coreGenomeViewModel.getCoreGenomeSearch();
        coreGenomeSearch.setKeyword(this.keywordTextField.getText());
        coreGenomeSearch.setSearchType(this.getSearchType());
        coreGenomeSearch.execute();
        this.coreGenomeViewModel.moveViewOrthologGroupStartIndexForCenter(coreGenomeSearch.getOrthologGroupIndex());
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.coreGenomeViewModel.nodifyObservers(coreGenomeChangeStartIndexEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.searchButton) {
            this.search();
        } else if (actionEvent.getSource() == this.keywordTextField) {
            this.searchButton.doClick();
        }
    }
}

