/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Chromosome;
import cgdp.recog.util.DateUtil;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChromosomeExporter
extends FileExporter {
    private static final String HEADER = "id\tudate\tgenome\tspid\tsp\tname\tseqno\ttype\tshape\tstatus\taccession\tgi\tseq\tseq_length\tcount_genes\tlength";
    private static final String DELIMITER = "\t";
    private String filepath;
    private List chromosomeList = new ArrayList();

    public ChromosomeExporter(String string, List list) {
        this.filepath = string;
        this.chromosomeList = list;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (Chromosome chromosome : this.chromosomeList) {
            stringBuffer.append(chromosome.getId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(DateUtil.formatServerDate(new Date()));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getGenome());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getSpid());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getOrganismCode());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getName());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getSeqNo());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getType());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getShape());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getStatus());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getAccession());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getGi());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getSeq());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getSeqLength());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getCountGene());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(chromosome.getLength());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

