/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.Const;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class ColorTbl
extends HashMap {
    private static final ApplicationLogger logger = new ApplicationLogger(ColorTbl.class);
    private static final String DELIMITER = "<>";
    private static final String INGROUP = "INGROUP";
    private static final String OUTGROUP = "OUTGROUP";
    public static final Color DEFAULT_COLOR = new Color(192, 192, 192);
    private static ColorTbl colorTbl = new ColorTbl();

    private ColorTbl() {
        try {
            this.readColor();
        }
        catch (IOException iOException) {
            logger.warn("Fail to load color.dat");
            MessageManager.showErrorMessage(null, iOException.getMessage());
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readColor() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(Const.USER_COLOR_DAT_PATH);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                Vector vector = StringTool.splitString(string, DELIMITER);
                if (((String)vector.get(0)).equals(INGROUP) || ((String)vector.get(0)).equals(OUTGROUP)) continue;
                this.put((String)vector.get(0), (String)vector.get(1));
                vector.clear();
                vector = null;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeColor() throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(Const.USER_COLOR_DAT_PATH);
            printWriter = new PrintWriter(fileOutputStream);
            for (String string : this.keySet()) {
                String string2 = (String)this.get(string);
                printWriter.println(string + DELIMITER + string2);
            }
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public Color getColor(String string) {
        if (!this.containsKey(string)) {
            return null;
        }
        String string2 = (String)this.get(string);
        return ColorUtil.str2Color(string2);
    }

    public static ColorTbl getInstance() {
        return colorTbl;
    }
}

