/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.AbstractMultiCluster;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TextConsenser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MultiCluster
extends AbstractMultiCluster {
    private static final ApplicationLogger logger = new ApplicationLogger(MultiCluster.class);

    public MultiCluster(int n) {
        this.setClusterType(2);
        this.setClusterId(n);
        this.init();
    }

    public MultiCluster(int n, Collection collection) {
        this.setClusterType(2);
        this.setClusterId(n);
        this.setSubClusterList(ClusterUtil.convertClusterOnlyList(collection));
        this.init();
    }

    private void init() {
        String string = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("CGene"));
        this.setGeneName(string);
        String string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("CFuncMbgd"));
        this.setFunctionCategoryMBGD(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("CFuncCog"));
        this.setFunctionCategoryCOG(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("CFuncKegg"));
        this.setFunctionCategoryKEGG(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("CFuncTigr"));
        this.setFunctionCategoryTIGR(string2);
        String string3 = this.getConsenseText(ClusterInfoFacade.getInfoTitle("CDescr"));
        this.setDescription(string3);
        string = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("SCGene"));
        this.setSubGeneName(string);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("SCFuncMbgd"));
        this.setSubFunctionCategoryMBGD(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("SCFuncCog"));
        this.setSubFunctionCategoryCOG(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("SCFuncKegg"));
        this.setSubFunctionCategoryKEGG(string2);
        string2 = (String)this.getPresentativeValue(ClusterInfoFacade.getInfoTitle("SCFuncTigr"));
        this.setSubFunctionCategoryTIGR(string2);
        String string4 = this.getConsenseText(ClusterInfoFacade.getInfoTitle("SCDescr"));
        this.setSubDescription(string4);
    }

    private String getConsenseText(ClusterInfoTitle clusterInfoTitle) {
        try {
            TextConsenser textConsenser = new TextConsenser();
            textConsenser.createCondition();
            for (Cluster cluster : this.getSubClusterList()) {
                textConsenser.addTitle((String)cluster.getValue(clusterInfoTitle));
            }
            textConsenser.execute();
            String string = textConsenser.getMaxTitleOrig();
            return string;
        }
        catch (IOException iOException) {
            String string = "Fail to consense cluster descriptions.";
            logger.warn(string, iOException);
            if (this.isExistSubCluster()) {
                return (String)((Cluster)this.getSubClusterList().get(0)).getValue(clusterInfoTitle);
            }
            return "";
        }
    }

    private Object getPresentativeValue(ClusterInfoTitle clusterInfoTitle) {
        Iterator iterator;
        Object object2;
        HashMap<Object, Set<Object>> hashMap = new HashMap<Object, Set<Object>>();
        for (Object object2 : this.getSubClusterList()) {
            iterator = ((Cluster)object2).getValue(clusterInfoTitle);
            if (iterator instanceof String && StringTool.isNull((String)((Object)iterator))) continue;
            Set<Object> set = (Set)hashMap.get(iterator);
            if (set == null) {
                set = new HashSet();
                hashMap.put(iterator, set);
            }
            set.add(object2);
        }
        int n = 0;
        object2 = new ArrayList();
        for (Set<Object> set : hashMap.keySet()) {
            int n2 = ((Set)hashMap.get(set)).size();
            if (n < n2) {
                n = n2;
                object2.clear();
                object2.add(set);
                continue;
            }
            if (n != n2) continue;
            object2.add(set);
        }
        iterator = CollectionUtil.isNull((Collection)object2) ? "" : Collections.min(object2);
        return iterator;
    }
}

