/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.Const;
import cgdp.recog.data.InnerTbl;
import cgdp.recog.data.OuterTbl;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustConditionComparator;
import cgdp.recog.domclust.DomClustConditionExporter;
import cgdp.recog.domclust.DomClustConditionImporter;
import cgdp.recog.domclust.DomClustConditionNameDialog;
import cgdp.recog.domclust.DomClustExecuter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.SliderTextPanel;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class DomClustDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustDialog.class);
    private static final int DOMCLUST_CONDITION_COMBOBOX_WIDTH = 200;
    private static final int COMBOBOX_WIDTH = 80;
    private static final String NO_ITEM = "-";
    private FocusTextField domClustNameTextField;
    private JPanel domclustOptionPanel;
    private JTabbedPane optionContainer;
    private boolean showOption = true;
    private JButton parameterButton;
    private RestrictTextField cutoffEvalueTextField;
    private RestrictTextField cutoffDpTextField;
    private RestrictTextField cutoffPamTextField;
    private RestrictTextField cutoffIdentityTextField;
    private RestrictTextField cutoffIngroupTextField;
    private RestrictTextField alignCoverageTextField;
    private RestrictTextField alignCoverageDomainTextField;
    private RestrictTextField scoreCutoffForDomainTextField;
    private JRadioButton scoreRadioButton;
    private JRadioButton pamRadioButton;
    private JRadioButton identityRadioButton;
    private JRadioButton noneRadioButton;
    private JRadioButton bidirecRadioButton;
    private JRadioButton unidirecRadioButton;
    private RestrictTextField cutoffScoreBestTextField;
    private RestrictTextField scoreMissingRelationshipTextField;
    private JRadioButton orthologyRadioButton;
    private JRadioButton homologyRadioButton;
    private JRadioButton combinedRadioButton;
    private RestrictTextField cutoffParalogTreeSplitTextField;
    private JComboBox phylogOrganismComboBox;
    private JComboBox overlapMergingClusterComboBox;
    private JComboBox coverageAbsorbingClusterComboBox;
    private JCheckBox useDumpCheckBox;
    private SliderTextPanel horizWeightSliderTextPanel;
    private FocusTextField otherOptionsTextField;
    private JComboBox domClustConditionComboBox;
    private JButton domClustConditionSaveButton;
    private JButton domClustConditionDeleteButton;
    private List domClustConditionList = new ArrayList();
    private OrganismSelectPanel organismSelectPanel;
    private static int paramNum = 18;
    JLabel cutoffEvalueTitleLabel;
    JLabel cutoffDpTitleLabel;
    JLabel cutoffPamTitleLabel;
    JLabel cutoffIdentityTitleLabel;
    JLabel alignCoverageTitleLabel;
    JLabel alignCoverageDomainTitleLabel;
    JLabel scoreCutoffForDomainTitleLabel;
    JLabel similarityOrthologyTitleLabel;
    JLabel cutoffIngroupTitleLabel;
    JLabel bestHitTitleLabel;
    JLabel cutoffScoreBestTitleLabel;
    JLabel scoreMissingRelationshipTitleLabel;
    JLabel clusteringModeTitleLabel;
    JLabel cutoffParalogTreeSplitTitleLabel;
    JLabel overlapMergingClusterTitleLabel;
    JLabel coverageAbsorbingClusterTitleLabel;
    JLabel horizWeightTitleLabel;
    JLabel otherOptionsLabel;

    public DomClustDialog(Frame frame) {
        super(frame);
        this.domClustConditionList = this.loadDomClustCondition();
        this.createComponents(null);
    }

    public DomClustDialog(Frame frame, DomClustCondition domClustCondition) {
        super(frame);
        domClustCondition.setConditionName("<<Base Cluster Parameters>>");
        domClustCondition.setMutable(false);
        domClustCondition.setDomClustName(DomClustFileUtil.getDefaultDomClustName());
        this.domClustConditionList = new ArrayList();
        this.domClustConditionList.add(domClustCondition);
        this.createComponents(domClustCondition);
    }

    private List loadDomClustCondition() {
        int n;
        ArrayList<DomClustCondition> arrayList = new ArrayList<DomClustCondition>();
        File file = new File(Const.USER_DOMCLUST_CONDITION_DIR);
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            try {
                DomClustConditionImporter domClustConditionImporter = new DomClustConditionImporter(fileArray[n]);
                domClustConditionImporter.execute();
                DomClustCondition domClustCondition = domClustConditionImporter.getDomClustCondition();
                if (domClustCondition == null) continue;
                domClustCondition.setFilename(fileArray[n].getAbsolutePath());
                arrayList.add(domClustCondition);
                continue;
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust condition." + fileArray[n].getAbsolutePath(), iOException);
            }
        }
        n = 0;
        for (DomClustCondition domClustCondition : arrayList) {
            if (!domClustCondition.isLastCondition()) continue;
            n = 1;
        }
        Collections.sort(arrayList, new DomClustConditionComparator());
        return arrayList;
    }

    private void createComponents(DomClustCondition domClustCondition) {
        this.setTitle("Execute domclust");
        this.setModal(true);
        this.setResizable(true);
        this.setApplyButtonName("Run");
        this.setCloseButtonName("Close");
        JPanel jPanel = this.createTitlePanel();
        JPanel jPanel2 = this.createInfoPanel();
        this.domclustOptionPanel = this.createParameterPanel();
        JScrollPane jScrollPane = new JScrollPane(this.domclustOptionPanel, 20, 30);
        int n = (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.6);
        n = n > this.domclustOptionPanel.getPreferredSize().height ? this.domclustOptionPanel.getPreferredSize().height : n;
        jScrollPane.getViewport().setPreferredSize(new Dimension(this.domclustOptionPanel.getPreferredSize().width, n));
        this.domclustOptionPanel = new JPanel();
        this.domclustOptionPanel.setLayout(new GridBagLayout());
        this.domclustOptionPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.optionContainer = new JTabbedPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.getContentPane().add((Component)this.optionContainer, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 10, 10, 10), 0, 0));
        this.optionContainer.addTab("Ortholog Clustering (DomClust) Setting", this.domclustOptionPanel);
        this.optionContainer.addTab("Taxonomy Map Parameters", this.createTaxMapParameterPanel(n));
        this.optionContainer.setSelectedIndex(0);
        this.optionContainer.setVisible(false);
        if (domClustCondition == null) {
            this.initParameters();
        } else {
            this.initParameters4base(domClustCondition);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createTaxMapParameterPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.organismSelectPanel = new OrganismSelectPanel(false, false, true);
        jPanel.add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    private JPanel createTitlePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Start Ortholog Clustering (DomClust)?");
        jPanel.add(jLabel2);
        return jPanel;
    }

    private JPanel createInfoPanel() {
        JLabel jLabel = new JLabel("Name");
        this.domClustNameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Ingroup");
        JLabel jLabel3 = new JLabel("Outgroup");
        InnerTbl innerTbl = InnerTbl.getInstance();
        JLabel jLabel4 = new JLabel(String.valueOf(innerTbl.size()));
        OuterTbl outerTbl = OuterTbl.getInstance();
        JLabel jLabel5 = new JLabel(String.valueOf(outerTbl.size()));
        JLabel jLabel6 = new JLabel("Parameter set");
        JPanel jPanel = this.createDomClustConditionPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 50, 5, 5), 0, 0));
        jPanel2.add((Component)this.domClustNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 50, 5, 5), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 50, 5, 5), 0, 0));
        jPanel2.add((Component)jLabel5, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel6, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 50, 5, 5), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel2;
    }

    private JPanel createParameterPanel() {
        this.domClustConditionSaveButton = new JButton("Save parameters");
        this.domClustConditionSaveButton.addActionListener(this);
        this.domClustConditionDeleteButton = new JButton("Delete this paramter set");
        this.domClustConditionDeleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.domClustConditionSaveButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.domClustConditionDeleteButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.cutoffEvalueTitleLabel = new JLabel("Cutoff BLAST E-value");
        this.cutoffEvalueTextField = new RestrictTextField();
        this.cutoffEvalueTextField.setDecimal(true);
        this.cutoffEvalueTextField.setColumns(8);
        this.cutoffDpTitleLabel = new JLabel("Cutoff DP score");
        this.cutoffDpTextField = new RestrictTextField();
        this.cutoffDpTextField.setColumns(8);
        this.cutoffPamTitleLabel = new JLabel("Cutoff PAM distance");
        this.cutoffPamTextField = new RestrictTextField();
        this.cutoffPamTextField.setColumns(8);
        this.cutoffIdentityTitleLabel = new JLabel("Cutoff percent identity");
        this.cutoffIdentityTextField = new RestrictTextField();
        this.cutoffIdentityTextField.setDecimal(true);
        this.cutoffIdentityTextField.setColumns(8);
        this.cutoffIngroupTitleLabel = new JLabel("Cutoff DP score / PAM distance / percent identity for ingroup");
        this.cutoffIngroupTextField = new RestrictTextField();
        this.cutoffIngroupTextField.setDecimal(true);
        this.cutoffIngroupTextField.setColumns(8);
        this.alignCoverageTitleLabel = new JLabel("Alignment coverage");
        this.alignCoverageTextField = new RestrictTextField();
        this.alignCoverageTextField.setDecimal(true);
        this.alignCoverageTextField.setColumns(8);
        this.alignCoverageDomainTitleLabel = new JLabel("Alignment coverage for domain splitting");
        this.alignCoverageDomainTextField = new RestrictTextField();
        this.alignCoverageDomainTextField.setDecimal(true);
        this.alignCoverageDomainTextField.setColumns(8);
        this.scoreCutoffForDomainTitleLabel = new JLabel("Score cutoff for domain splitting");
        this.scoreCutoffForDomainTextField = new RestrictTextField();
        this.scoreCutoffForDomainTextField.setDecimal(true);
        this.scoreCutoffForDomainTextField.setColumns(8);
        this.similarityOrthologyTitleLabel = new JLabel("Similarity measure for orthology");
        this.scoreRadioButton = new JRadioButton("score");
        this.pamRadioButton = new JRadioButton("pam");
        this.identityRadioButton = new JRadioButton("identity");
        this.scoreRadioButton.addActionListener(this);
        this.pamRadioButton.addActionListener(this);
        this.identityRadioButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.scoreRadioButton);
        buttonGroup.add(this.pamRadioButton);
        buttonGroup.add(this.identityRadioButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.scoreRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.pamRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.identityRadioButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.bestHitTitleLabel = new JLabel("Best hit criterion");
        this.noneRadioButton = new JRadioButton("none");
        this.bidirecRadioButton = new JRadioButton("bidirec");
        this.unidirecRadioButton = new JRadioButton("unidirec");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this.noneRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add((Component)this.bidirecRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add((Component)this.unidirecRadioButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.noneRadioButton);
        buttonGroup2.add(this.bidirecRadioButton);
        buttonGroup2.add(this.unidirecRadioButton);
        this.cutoffScoreBestTitleLabel = new JLabel("Cutoff ratio of the score against the best");
        this.cutoffScoreBestTextField = new RestrictTextField();
        this.cutoffScoreBestTextField.setDecimal(true);
        this.cutoffScoreBestTextField.setColumns(8);
        this.scoreMissingRelationshipTitleLabel = new JLabel("Score for missing relationships");
        this.scoreMissingRelationshipTextField = new RestrictTextField();
        this.scoreMissingRelationshipTextField.setDecimal(true);
        this.scoreMissingRelationshipTextField.setColumns(8);
        this.clusteringModeTitleLabel = new JLabel("Clustering Mode");
        this.orthologyRadioButton = new JRadioButton("orthology");
        this.homologyRadioButton = new JRadioButton("homology");
        this.combinedRadioButton = new JRadioButton("combined");
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.combinedRadioButton);
        buttonGroup3.add(this.orthologyRadioButton);
        buttonGroup3.add(this.homologyRadioButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)this.combinedRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel4.add((Component)this.orthologyRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel4.add((Component)this.homologyRadioButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.cutoffParalogTreeSplitTitleLabel = new JLabel("Cutoff ratio of paralogs for tree splitting");
        this.cutoffParalogTreeSplitTextField = new RestrictTextField();
        this.cutoffParalogTreeSplitTextField.setDecimal(true);
        this.cutoffParalogTreeSplitTextField.setColumns(8);
        this.overlapMergingClusterTitleLabel = new JLabel("Overlap ratio (radj1) for merging adjacent clusters");
        Object[] objectArray = new Object[]{NO_ITEM, new Double(0.5), new Double(0.6), new Double(0.7), new Double(0.8), new Double(0.9), new Double(1.0)};
        this.overlapMergingClusterComboBox = new JComboBox<Object>(objectArray);
        this.overlapMergingClusterComboBox.setPreferredSize(new Dimension(80, this.overlapMergingClusterComboBox.getPreferredSize().height));
        this.coverageAbsorbingClusterTitleLabel = new JLabel("Coverage ratio (radj2) for absorbing adjacent small clusters");
        Object[] objectArray2 = new Object[]{NO_ITEM, new Double(0.8), new Double(0.85), new Double(0.9), new Double(0.95), new Double(1.0)};
        this.coverageAbsorbingClusterComboBox = new JComboBox<Object>(objectArray2);
        this.coverageAbsorbingClusterComboBox.setPreferredSize(new Dimension(80, this.coverageAbsorbingClusterComboBox.getPreferredSize().height));
        this.horizWeightSliderTextPanel = SliderTextPanel.createRatioSliderTextPanel();
        this.horizWeightTitleLabel = new JLabel("Relative weight for horiz. transfer(%)");
        this.useDumpCheckBox = new JCheckBox("Use domclust dump");
        this.otherOptionsLabel = new JLabel("Other options");
        this.otherOptionsTextField = new FocusTextField(30);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.add((Component)jPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 0, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffEvalueTitleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffEvalueTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffDpTitleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffDpTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffPamTitleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffPamTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffIdentityTitleLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffIdentityTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.alignCoverageTitleLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.alignCoverageTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.alignCoverageDomainTitleLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.alignCoverageDomainTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.scoreCutoffForDomainTitleLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.scoreCutoffForDomainTextField, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.similarityOrthologyTitleLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)jPanel2, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffIngroupTitleLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffIngroupTextField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.bestHitTitleLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)jPanel3, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffScoreBestTitleLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffScoreBestTextField, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.scoreMissingRelationshipTitleLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.scoreMissingRelationshipTextField, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.clusteringModeTitleLabel, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)jPanel4, new GridBagConstraints(1, 13, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffParalogTreeSplitTitleLabel, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.cutoffParalogTreeSplitTextField, new GridBagConstraints(1, 14, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.overlapMergingClusterTitleLabel, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.overlapMergingClusterComboBox, new GridBagConstraints(1, 15, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.coverageAbsorbingClusterTitleLabel, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.coverageAbsorbingClusterComboBox, new GridBagConstraints(1, 16, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.horizWeightTitleLabel, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.horizWeightSliderTextPanel, new GridBagConstraints(1, 17, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
        jPanel5.add((Component)this.useDumpCheckBox, new GridBagConstraints(0, 18, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.otherOptionsLabel, new GridBagConstraints(0, 19, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        jPanel5.add((Component)this.otherOptionsTextField, new GridBagConstraints(1, 19, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 7, 0, 3), 0, 0));
        return jPanel5;
    }

    private JPanel createDomClustConditionPanel() {
        JLabel jLabel = new JLabel("DomClust Condition");
        DomClustConditionComboBoxModel domClustConditionComboBoxModel = new DomClustConditionComboBoxModel(this.domClustConditionList);
        this.domClustConditionComboBox = new JComboBox(domClustConditionComboBoxModel);
        this.domClustConditionComboBox.addItemListener(this);
        this.domClustConditionComboBox.setPreferredSize(new Dimension(200, this.domClustConditionComboBox.getPreferredSize().height));
        this.parameterButton = new JButton(">>Parameters");
        this.parameterButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.domClustConditionComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.parameterButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return jPanel;
    }

    private void initParameters() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        String string = optionTbl.getOptionValues().getDomClustConditionName();
        DomClustCondition domClustCondition = this.getDomClustCondition(string);
        if (domClustCondition == null) {
            File file = new File(DomClustCondition.getLastConditionFilepath());
            if (file.isFile()) {
                try {
                    DomClustConditionImporter domClustConditionImporter = new DomClustConditionImporter(file);
                    domClustConditionImporter.execute();
                    domClustCondition = domClustConditionImporter.getDomClustCondition();
                }
                catch (IOException iOException) {
                    String string2 = "Fail to load last condition.";
                    MessageManager.showErrorMessage((Component)this, string2);
                    logger.warn(string2, iOException);
                    domClustCondition = DomClustCondition.createNewLastCondition();
                }
            } else {
                domClustCondition = this.getDefaultDomClustCondition();
            }
        }
        this.setParameters(domClustCondition);
        this.setTaxMapParameters(domClustCondition);
        this.domClustNameTextField.setText(DomClustFileUtil.getDefaultDomClustName());
        this.updateButtonStatus();
    }

    private void initParameters4base(DomClustCondition domClustCondition) {
        this.setParameters(domClustCondition);
        this.setTaxMapParameters(domClustCondition);
        this.domClustNameTextField.setText(DomClustFileUtil.getDefaultDomClustName());
        this.updateButtonStatus();
        this.setParamEnabled();
    }

    private DomClustCondition getDefaultDomClustCondition() {
        for (DomClustCondition domClustCondition : this.domClustConditionList) {
            if (!domClustCondition.isDefault()) continue;
            return domClustCondition;
        }
        if (!CollectionUtil.isNull(this.domClustConditionList)) {
            return (DomClustCondition)this.domClustConditionList.get(0);
        }
        return null;
    }

    public void setDefaultDomClustCondition(DomClustCondition domClustCondition) {
        if (domClustCondition == null) {
            return;
        }
        this.setParameters(domClustCondition);
        this.setDomClustName(domClustCondition.getDomClustName());
    }

    public void setDomClustName(String string) {
        this.domClustNameTextField.setText(string);
    }

    public void setEnableBestHitCriterion(Set set) {
        boolean bl = false;
        if (!set.contains("none")) {
            this.noneRadioButton.setEnabled(false);
            bl |= this.noneRadioButton.isSelected();
        }
        if (!set.contains("bidirec")) {
            this.bidirecRadioButton.setEnabled(false);
            bl |= this.bidirecRadioButton.isSelected();
        }
        if (!set.contains("unidirec")) {
            this.unidirecRadioButton.setEnabled(false);
            bl |= this.unidirecRadioButton.isSelected();
        }
        if (bl) {
            if (this.noneRadioButton.isEnabled()) {
                this.noneRadioButton.setSelected(true);
            } else if (this.bidirecRadioButton.isEnabled()) {
                this.bidirecRadioButton.setSelected(true);
            } else {
                this.unidirecRadioButton.setSelected(true);
            }
        }
    }

    private DomClustCondition getSelectedDomClustCondition() {
        DomClustConditionComboBoxModel domClustConditionComboBoxModel = (DomClustConditionComboBoxModel)this.domClustConditionComboBox.getModel();
        return domClustConditionComboBoxModel.getSelectedCondition();
    }

    private void saveCondition() {
        try {
            DomClustCondition domClustCondition = this.getSelectedDomClustCondition();
            if (domClustCondition == null) {
                domClustCondition = new DomClustCondition();
            } else if (!domClustCondition.isMutable()) {
                domClustCondition = (DomClustCondition)domClustCondition.clone();
            }
            Set set = this.getImmutableDomClustConditionNameSet();
            String string = "";
            if (domClustCondition.isMutable()) {
                string = domClustCondition.getConditionName();
            }
            DomClustConditionNameDialog domClustConditionNameDialog = new DomClustConditionNameDialog((Dialog)this, string, set);
            domClustConditionNameDialog.setVisible(true);
            if (domClustConditionNameDialog.isCanceled()) {
                return;
            }
            String string2 = domClustConditionNameDialog.getConditionName();
            domClustConditionNameDialog.dispose();
            DomClustCondition domClustCondition2 = this.getDomClustCondition(string2);
            if (domClustCondition2 != null) {
                if (!MessageManager.showConfirmMessage((Component)this, "Overwrite domclust condition?")) {
                    return;
                }
            } else {
                domClustCondition2 = new DomClustCondition();
                domClustCondition2.setConditionName(string2);
                this.domClustConditionList.add(domClustCondition2);
                Collections.sort(this.domClustConditionList, new DomClustConditionComparator());
            }
            this.updateDomClustCondition(domClustCondition2);
            DomClustConditionExporter domClustConditionExporter = new DomClustConditionExporter(domClustCondition2);
            domClustConditionExporter.execute();
            this.domClustConditionComboBox.getModel().setSelectedItem(domClustCondition2.getConditionName());
        }
        catch (IOException iOException) {
            String string = "Fail to save domclust condition.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    private void deleteCondition() {
        DomClustCondition domClustCondition = this.getSelectedDomClustCondition();
        if (domClustCondition == null) {
            return;
        }
        if (!domClustCondition.isMutable()) {
            return;
        }
        if (!MessageManager.showConfirmMessage((Component)this, "Delete domclust condition. : " + domClustCondition.getConditionName())) {
            return;
        }
        this.domClustConditionList.remove(domClustCondition);
        File file = new File(domClustCondition.getFilename());
        if (file.isFile()) {
            file.delete();
        }
        if (!this.domClustConditionList.isEmpty()) {
            DomClustCondition domClustCondition2 = (DomClustCondition)this.domClustConditionList.get(0);
            this.domClustConditionComboBox.getModel().setSelectedItem(domClustCondition2.getConditionName());
        }
    }

    private DomClustCondition getDomClustCondition(String string) {
        DomClustCondition domClustCondition = null;
        if (StringTool.isNull(string)) {
            return domClustCondition;
        }
        for (DomClustCondition domClustCondition2 : this.domClustConditionList) {
            String string2 = domClustCondition2.getConditionName();
            if (StringTool.isNull(string2) || !string2.equals(string)) continue;
            domClustCondition = domClustCondition2;
            break;
        }
        return domClustCondition;
    }

    private Set getImmutableDomClustConditionNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (DomClustCondition domClustCondition : this.domClustConditionList) {
            if (domClustCondition.isMutable()) continue;
            hashSet.add(domClustCondition.getConditionName());
        }
        return hashSet;
    }

    private Set getDomClustConditionNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (DomClustCondition domClustCondition : this.domClustConditionList) {
            hashSet.add(domClustCondition.getConditionName());
        }
        return hashSet;
    }

    private void setParameters(DomClustCondition domClustCondition) {
        this.domClustConditionComboBox.removeItemListener(this);
        this.domClustConditionComboBox.getModel().setSelectedItem(domClustCondition.getConditionName());
        this.domClustConditionComboBox.addItemListener(this);
        this.updateValue(domClustCondition);
    }

    private void setTaxMapParameters(DomClustCondition domClustCondition) {
        Set set = ApplicationPropertyFacade.getMetagenomeOrganismCodeSet();
        Set set2 = ((HashMap)InnerTbl.getInstance().clone()).keySet();
        set2.removeAll(set);
        List list = OrganismUtil.getOrganismList(set2, 2, true);
        list = OrganismUtil.convertDisplayOrganismList(list);
        set.retainAll(InnerTbl.getInstance().keySet());
        List list2 = new ArrayList(set);
        list2 = OrganismUtil.getOrganismList(list2, 2, true);
        list2 = OrganismUtil.convertDisplayOrganismList(list2);
        this.organismSelectPanel.updateValue(list, list2);
    }

    public Set getTaxMapOrganismCodeSet() {
        List list = this.organismSelectPanel.getTargetOrganismCodeList();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            hashSet.add(list.get(i));
        }
        return hashSet;
    }

    private void updateValue(DomClustCondition domClustCondition) {
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffEvalue())) {
            this.cutoffEvalueTextField.setText(String.valueOf(domClustCondition.getCutoffEvalue()));
        } else {
            this.cutoffEvalueTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffDp())) {
            this.cutoffDpTextField.setText(String.valueOf(domClustCondition.getCutoffDp()));
        } else {
            this.cutoffDpTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffPam())) {
            this.cutoffPamTextField.setText(String.valueOf(domClustCondition.getCutoffPam()));
        } else {
            this.cutoffPamTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIdentity())) {
            this.cutoffIdentityTextField.setText(String.valueOf(domClustCondition.getCutoffIdentity()));
        } else {
            this.cutoffIdentityTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIngroup())) {
            this.cutoffIngroupTextField.setText(String.valueOf(domClustCondition.getCutoffIngroup()));
        } else {
            this.cutoffIngroupTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverage())) {
            this.alignCoverageTextField.setText(String.valueOf(domClustCondition.getAlignCoverage()));
        } else {
            this.alignCoverageTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverageDomain())) {
            this.alignCoverageDomainTextField.setText(String.valueOf(domClustCondition.getAlignCoverageDomain()));
        } else {
            this.alignCoverageDomainTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreCutoffForDomain())) {
            this.scoreCutoffForDomainTextField.setText(String.valueOf(domClustCondition.getScoreCutoffForDomain()));
        } else {
            this.scoreCutoffForDomainTextField.setText("");
        }
        this.scoreRadioButton.setSelected(domClustCondition.isSimilarityOrthologyScore());
        this.pamRadioButton.setSelected(domClustCondition.isSimilarityOrthologyPam());
        this.identityRadioButton.setSelected(domClustCondition.isSimilarytiOrthologyIdentity());
        this.noneRadioButton.setSelected(domClustCondition.isBestHitCriterionNone());
        this.bidirecRadioButton.setSelected(domClustCondition.isBestHitCriterionBidirec());
        this.unidirecRadioButton.setSelected(domClustCondition.isBestHitCriterionUnidirec());
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffSocreBest())) {
            this.cutoffScoreBestTextField.setText(String.valueOf(domClustCondition.getCutoffSocreBest()));
        } else {
            this.cutoffScoreBestTextField.setText("");
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreMissingRelationship())) {
            this.scoreMissingRelationshipTextField.setText(String.valueOf(domClustCondition.getScoreMissingRelationship()));
        } else {
            this.scoreMissingRelationshipTextField.setText("");
        }
        this.combinedRadioButton.setSelected(domClustCondition.isClusteringModeCombined());
        this.orthologyRadioButton.setSelected(domClustCondition.isClusteringModeOrthology());
        this.homologyRadioButton.setSelected(domClustCondition.isClusteringModeHomology());
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffParalogTreeSplit())) {
            this.cutoffParalogTreeSplitTextField.setText(String.valueOf(domClustCondition.getCutoffParalogTreeSplit()));
        } else {
            this.cutoffParalogTreeSplitTextField.setText("");
        }
        double d = domClustCondition.getOverlapMergingCluster();
        if (DomClustCondition.isNoValue(d)) {
            this.overlapMergingClusterComboBox.setSelectedItem(NO_ITEM);
        } else {
            this.overlapMergingClusterComboBox.setSelectedItem(new Double(d));
        }
        double d2 = domClustCondition.getCoverageAbsorbingCluster();
        if (DomClustCondition.isNoValue(d2)) {
            this.coverageAbsorbingClusterComboBox.setSelectedItem(NO_ITEM);
        } else {
            this.coverageAbsorbingClusterComboBox.setSelectedItem(new Double(d2));
        }
        int n = (int)(domClustCondition.getHorizweight() * 100.0);
        if (DomClustCondition.isNoValue(n)) {
            this.horizWeightSliderTextPanel.setValue(0.0);
        } else {
            this.horizWeightSliderTextPanel.setValue(n);
        }
        this.useDumpCheckBox.setSelected(domClustCondition.isUseDump());
        this.otherOptionsTextField.setText(domClustCondition.getOtherOptions());
        this.setEnabledCutoffIngroup();
    }

    private void showParameterPanel() {
        this.optionContainer.setVisible(!this.optionContainer.isVisible());
        if (this.showOption) {
            this.parameterButton.setText(">>Parameters");
            this.showOption = false;
        } else {
            this.parameterButton.setText("<<Parameters");
            this.showOption = true;
        }
        this.pack();
    }

    @Override
    protected boolean check() {
        if (StringTool.isNull(this.getDomClustName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        String string = DomClustExecuter.getOutputFilePath(this.getDomClustName());
        if (new File(string).isDirectory()) {
            MessageManager.showErrorMessage((Component)this, string + " is directory.");
            return false;
        }
        if (new File(string).isFile() && !MessageManager.showConfirmOverwriteMessage(this, string)) {
            return false;
        }
        return super.check();
    }

    @Override
    protected boolean apply() {
        this.exportLastCondition();
        DomClustCondition domClustCondition = this.getSelectedDomClustCondition();
        OptionTbl optionTbl = OptionTbl.getInstance();
        optionTbl.getOptionValues().setDomClustConditionName(domClustCondition.getConditionName());
        return true;
    }

    private void setEnabledCutoffIngroup() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.parameterButton) {
            this.showParameterPanel();
        } else if (actionEvent.getSource() == this.domClustConditionSaveButton) {
            this.saveCondition();
        } else if (actionEvent.getSource() == this.domClustConditionDeleteButton) {
            this.deleteCondition();
        } else if (actionEvent.getSource() == this.scoreRadioButton || actionEvent.getSource() == this.pamRadioButton || actionEvent.getSource() == this.identityRadioButton) {
            this.setEnabledCutoffIngroup();
        }
    }

    private String getDomClustName() {
        return this.domClustNameTextField.getText();
    }

    private double getAlignCoverage() {
        return DomClustDialog.getDoubleValue(this.alignCoverageTextField.getText());
    }

    private double getAlignCoverageDomain() {
        return DomClustDialog.getDoubleValue(this.alignCoverageDomainTextField.getText());
    }

    private String getBestHitCriterion() {
        if (this.bidirecRadioButton.isSelected()) {
            return "bidirec";
        }
        if (this.unidirecRadioButton.isSelected()) {
            return "unidirec";
        }
        return "none";
    }

    private String getClusteringMode() {
        if (this.homologyRadioButton.isSelected()) {
            return "homology";
        }
        if (this.orthologyRadioButton.isSelected()) {
            return "orthology";
        }
        return "combined";
    }

    private int getCutoffDp() {
        return DomClustDialog.getIntValue(this.cutoffDpTextField.getText());
    }

    private int getCutoffPam() {
        return DomClustDialog.getIntValue(this.cutoffPamTextField.getText());
    }

    private double getCutoffEValue() {
        return DomClustDialog.getDoubleValue(this.cutoffEvalueTextField.getText());
    }

    private double getCutoffIdentity() {
        return DomClustDialog.getDoubleValue(this.cutoffIdentityTextField.getText());
    }

    private double getCutoffIngroup() {
        return DomClustDialog.getDoubleValue(this.cutoffIngroupTextField.getText());
    }

    private double getCutoffParalogTreeSplit() {
        return DomClustDialog.getDoubleValue(this.cutoffParalogTreeSplitTextField.getText());
    }

    private double getCutoffScoreBest() {
        return DomClustDialog.getDoubleValue(this.cutoffScoreBestTextField.getText());
    }

    private double getCoverageAbsorbingCluster() {
        Object object = this.coverageAbsorbingClusterComboBox.getSelectedItem();
        if (object.equals(NO_ITEM)) {
            return -2.147483648E9;
        }
        return (Double)object;
    }

    private double getOverlapMergingCluster() {
        Object object = this.overlapMergingClusterComboBox.getSelectedItem();
        if (object.equals(NO_ITEM)) {
            return -2.147483648E9;
        }
        return (Double)object;
    }

    private String getPhylogOrganism() {
        return (String)this.phylogOrganismComboBox.getSelectedItem();
    }

    private double getScoreCutoffForDomain() {
        return DomClustDialog.getDoubleValue(this.scoreCutoffForDomainTextField.getText());
    }

    private double getScoreMissingRelationship() {
        return DomClustDialog.getDoubleValue(this.scoreMissingRelationshipTextField.getText());
    }

    private String getSimilarityOrthology() {
        if (this.pamRadioButton.isSelected()) {
            return "pam";
        }
        if (this.identityRadioButton.isSelected()) {
            return "identity";
        }
        return "score";
    }

    private double getHorizweight() {
        return this.horizWeightSliderTextPanel.getValue() / 100.0;
    }

    private String getOtherOptions() {
        return this.otherOptionsTextField.getText();
    }

    private static double getDoubleValue(String string) {
        if (StringTool.isNull(string)) {
            return -2.147483648E9;
        }
        return Double.parseDouble(string);
    }

    private static int getIntValue(String string) {
        if (StringTool.isNull(string)) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(string);
    }

    public DomClustCondition getDomClustCondition() {
        DomClustCondition domClustCondition = new DomClustCondition();
        this.updateDomClustCondition(domClustCondition);
        return domClustCondition;
    }

    private void updateDomClustCondition(DomClustCondition domClustCondition) {
        domClustCondition.setDomClustName(this.getDomClustName());
        domClustCondition.setAlignCoverage(this.getAlignCoverage());
        domClustCondition.setAlignCoverageDomain(this.getAlignCoverageDomain());
        domClustCondition.setBestHitCriterion(this.getBestHitCriterion());
        domClustCondition.setClusteringMode(this.getClusteringMode());
        domClustCondition.setCutoffDp(this.getCutoffDp());
        domClustCondition.setCutoffPam(this.getCutoffPam());
        domClustCondition.setCutoffEvalue(this.getCutoffEValue());
        domClustCondition.setCutoffIdentity(this.getCutoffIdentity());
        domClustCondition.setCutoffIngroup(this.getCutoffIngroup());
        domClustCondition.setCutoffParalogTreeSplit(this.getCutoffParalogTreeSplit());
        domClustCondition.setCutoffSocreBest(this.getCutoffScoreBest());
        domClustCondition.setCoverageAbsorbingCluster(this.getCoverageAbsorbingCluster());
        domClustCondition.setOverlapMergingCluster(this.getOverlapMergingCluster());
        domClustCondition.setScoreCutoffForDomain(this.getScoreCutoffForDomain());
        domClustCondition.setScoreMissingRelationship(this.getScoreMissingRelationship());
        domClustCondition.setSimilarityOrthology(this.getSimilarityOrthology());
        domClustCondition.setHorizweight(this.getHorizweight());
        domClustCondition.setUseDump(this.useDumpCheckBox.isSelected());
        domClustCondition.setOtherOptions(this.getOtherOptions());
    }

    private void updateButtonStatus() {
        DomClustCondition domClustCondition = this.getSelectedDomClustCondition();
        this.domClustConditionDeleteButton.setEnabled(domClustCondition.isMutable());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (itemEvent.getSource() == this.domClustConditionComboBox) {
            this.setParameters(this.getSelectedDomClustCondition());
            this.updateButtonStatus();
        }
    }

    private void exportLastCondition() {
        try {
            DomClustCondition domClustCondition = DomClustCondition.createNewLastCondition();
            this.updateDomClustCondition(domClustCondition);
            DomClustConditionExporter domClustConditionExporter = new DomClustConditionExporter(domClustCondition);
            domClustConditionExporter.execute();
        }
        catch (IOException iOException) {
            String string = "Fail to save last condition.";
            MessageManager.showErrorMessage((Component)this, string);
            logger.warn(string, iOException);
        }
    }

    public void setParamEnabled() {
        Set set = OptionTbl.getInstance().getOptionValues().getEnableDomclustParam();
        for (int i = 0; i < paramNum; ++i) {
            if (set.contains(new Integer(i))) {
                this.setParamEnabled(i, true);
                continue;
            }
            this.setParamEnabled(i, false);
        }
    }

    private void setParamEnabled(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.cutoffEvalueTitleLabel.setEnabled(bl);
                this.cutoffEvalueTextField.setEnabled(bl);
                break;
            }
            case 1: {
                this.cutoffDpTitleLabel.setEnabled(bl);
                this.cutoffDpTextField.setEnabled(bl);
                break;
            }
            case 2: {
                this.cutoffPamTitleLabel.setEnabled(bl);
                this.cutoffPamTextField.setEnabled(bl);
                break;
            }
            case 3: {
                this.cutoffIdentityTitleLabel.setEnabled(bl);
                this.cutoffIdentityTextField.setEnabled(bl);
                break;
            }
            case 4: {
                this.alignCoverageTitleLabel.setEnabled(bl);
                this.alignCoverageTextField.setEnabled(bl);
                break;
            }
            case 5: {
                this.alignCoverageDomainTitleLabel.setEnabled(bl);
                this.alignCoverageDomainTextField.setEnabled(bl);
                break;
            }
            case 6: {
                this.scoreCutoffForDomainTitleLabel.setEnabled(bl);
                this.scoreCutoffForDomainTextField.setEnabled(bl);
                break;
            }
            case 7: {
                this.similarityOrthologyTitleLabel.setEnabled(bl);
                this.scoreRadioButton.setEnabled(bl);
                this.pamRadioButton.setEnabled(bl);
                this.identityRadioButton.setEnabled(bl);
                break;
            }
            case 8: {
                this.cutoffIngroupTitleLabel.setEnabled(bl);
                this.cutoffIngroupTextField.setEnabled(bl);
                break;
            }
            case 9: {
                this.bestHitTitleLabel.setEnabled(bl);
                this.noneRadioButton.setEnabled(bl);
                this.bidirecRadioButton.setEnabled(bl);
                this.unidirecRadioButton.setEnabled(bl);
                break;
            }
            case 10: {
                this.cutoffScoreBestTitleLabel.setEnabled(bl);
                this.cutoffScoreBestTextField.setEnabled(bl);
                break;
            }
            case 11: {
                this.scoreMissingRelationshipTitleLabel.setEnabled(bl);
                this.scoreMissingRelationshipTextField.setEnabled(bl);
                break;
            }
            case 12: {
                this.clusteringModeTitleLabel.setEnabled(bl);
                this.combinedRadioButton.setEnabled(bl);
                this.orthologyRadioButton.setEnabled(bl);
                this.homologyRadioButton.setEnabled(bl);
                break;
            }
            case 13: {
                this.cutoffParalogTreeSplitTitleLabel.setEnabled(bl);
                this.cutoffParalogTreeSplitTextField.setEnabled(bl);
                break;
            }
            case 14: {
                this.overlapMergingClusterTitleLabel.setEnabled(bl);
                this.overlapMergingClusterComboBox.setEnabled(bl);
                break;
            }
            case 15: {
                this.coverageAbsorbingClusterTitleLabel.setEnabled(bl);
                this.coverageAbsorbingClusterComboBox.setEnabled(bl);
                break;
            }
            case 16: {
                this.horizWeightTitleLabel.setEnabled(bl);
                this.horizWeightSliderTextPanel.setEnabledComponents(bl);
                break;
            }
            case 17: {
                this.useDumpCheckBox.setEnabled(bl);
            }
        }
    }

    private class DomClustConditionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List domClustConditionList;
        private DomClustCondition selectedCondition;

        public DomClustConditionComboBoxModel(List list) {
            this.domClustConditionList = list;
        }

        @Override
        public Object getSelectedItem() {
            if (this.selectedCondition == null) {
                return "";
            }
            return this.selectedCondition.getConditionName();
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedCondition != null && !this.selectedCondition.equals(object) || this.selectedCondition == null && object != null) {
                DomClustCondition domClustCondition;
                this.selectedCondition = domClustCondition = this.getDomClustCondition((String)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getElementAt(int n) {
            return ((DomClustCondition)this.domClustConditionList.get(n)).getConditionName();
        }

        @Override
        public int getSize() {
            return this.domClustConditionList.size();
        }

        private DomClustCondition getDomClustCondition(String string) {
            DomClustCondition domClustCondition = null;
            for (DomClustCondition domClustCondition2 : this.domClustConditionList) {
                if (!domClustCondition2.getConditionName().equals(string)) continue;
                domClustCondition = domClustCondition2;
                break;
            }
            return domClustCondition;
        }

        public DomClustCondition getSelectedCondition() {
            return this.selectedCondition;
        }
    }
}

