/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.filter.FilterThresholdDialog;
import cgdp.recog.filter.GeneCountFilterCondition;
import cgdp.recog.filter.OrganismCountFilterCondition;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.filter.TaxFilterConditionGroup;
import cgdp.recog.project.Project;
import cgdp.recog.property.PropertyTableCellRenderer;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FilterConditionManager
implements ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(FilterConditionManager.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private TaxFilterConditionGroup taxFilterConditionGroup = TaxFilterConditionGroup.getInstance();
    private CountFilterCondition geneCountFilterCondition = new GeneCountFilterCondition();
    private CountFilterCondition organismCountFilterCondition = new OrganismCountFilterCondition();
    private SetConditionGroup filterSetConditionGroup = new SetConditionGroup();
    private SetConditionGroup taxMapSetConditionGroup = new SetConditionGroup();
    private SetConditionGroup funcCatSetConditionGroup = new SetConditionGroup();

    public FilterConditionManager(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    public TaxFilterConditionGroup getTaxFilterConditionGroup() {
        return this.taxFilterConditionGroup;
    }

    private void clearFilterConditionGroup() {
        this.taxFilterConditionGroup = TaxFilterConditionGroup.getInstance();
        this.saveTaxFilterCondition();
    }

    public boolean setFilterCondition(long l, String string, int n, Map map) {
        boolean bl = this.taxFilterConditionGroup.setFilterCondition(l, string, n, map);
        this.saveTaxFilterCondition();
        return bl;
    }

    public boolean setFilterCondition(long l, String string, int n, Map map, TaxFilterCondition taxFilterCondition) {
        boolean bl = this.taxFilterConditionGroup.setFilterCondition(l, string, n, map, taxFilterCondition);
        this.saveTaxFilterCondition();
        return bl;
    }

    public boolean isAll(String string) {
        return this.taxFilterConditionGroup.isAll(string);
    }

    public boolean isNone(String string) {
        return this.taxFilterConditionGroup.isNone(string);
    }

    public boolean isAny(String string) {
        return this.taxFilterConditionGroup.isAny(string);
    }

    public void setAnyThreshold(boolean bl, boolean bl2, double d) {
        this.taxFilterConditionGroup.setAnyThresholdByMenu(bl, bl2, d);
        this.saveTaxFilterCondition();
    }

    public boolean removeFilterConditions(Collection collection) {
        boolean bl = this.taxFilterConditionGroup.removeFilterConditions(collection);
        this.saveTaxFilterCondition();
        return bl;
    }

    public boolean removeSpFromCondition(long l, Collection collection) {
        boolean bl = this.taxFilterConditionGroup.removeSpFromCondition(l, collection);
        this.saveTaxFilterCondition();
        return bl;
    }

    public void saveTaxFilterCondition() {
        if (StringTool.isNull(this.getDomClustId())) {
            return;
        }
        try {
            ApplicationPropertyFacade.saveProperty(this.getDomClustId(), this.taxFilterConditionGroup);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save taxonomy filter condition.", iOException);
        }
    }

    public boolean isTaxFilterMatch(Collection collection, Collection collection2) {
        return this.taxFilterConditionGroup.isMatch(collection, collection2);
    }

    public boolean setFilterCondition(Frame frame, Map map, int n, String string, long l) {
        boolean bl = false;
        if (TaxFilterCondition.isAnyNew(n, l)) {
            FilterThresholdDialog filterThresholdDialog = new FilterThresholdDialog(frame, this.mediator, true);
            TaxFilterCondition taxFilterCondition = TaxFilterCondition.createFilterCondition(string, n, map);
            taxFilterCondition.setName(string);
            filterThresholdDialog.setFilterCondition(taxFilterCondition);
            filterThresholdDialog.setUpdateMainFlag(false);
            filterThresholdDialog.setVisible(true);
            if (filterThresholdDialog.isCanceled()) {
                return bl;
            }
            bl = this.setFilterCondition(l, taxFilterCondition.getName(), n, map, taxFilterCondition);
            filterThresholdDialog.dispose();
        } else {
            bl = this.setFilterCondition(l, string, n, map);
        }
        return bl;
    }

    public boolean setAnyFilterCondition(Map map, String string, double d, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (bl) {
            int n = bl2 ? 0 : (int)d;
            int n2 = bl2 ? (int)d : 1;
            bl3 = this.setAnyCountFilterCondition(map, string, !bl2, bl2, n, n2);
        } else {
            double d2 = bl2 ? 0.0 : d;
            double d3 = bl2 ? d : 0.5;
            bl3 = this.setAnyPercentFilterCondition(map, string, !bl2, bl2, d2, d3);
        }
        return bl3;
    }

    private boolean setAnyCountFilterCondition(Map map, String string, boolean bl, boolean bl2, int n, int n2) {
        TaxFilterCondition taxFilterCondition = TaxFilterCondition.createAnyCountFilterCondition(string, map, bl, bl2, n, n2);
        int n3 = 2;
        long l = -1L;
        boolean bl3 = this.setFilterCondition(l, taxFilterCondition.getName(), n3, map, taxFilterCondition);
        return bl3;
    }

    private boolean setAnyPercentFilterCondition(Map map, String string, boolean bl, boolean bl2, double d, double d2) {
        TaxFilterCondition taxFilterCondition = TaxFilterCondition.createAnyPercentFilterCondition(string, map, bl, bl2, d, d2);
        int n = 2;
        long l = -1L;
        boolean bl3 = this.setFilterCondition(l, taxFilterCondition.getName(), n, map, taxFilterCondition);
        return bl3;
    }

    public List getAnyConditionList() {
        return this.taxFilterConditionGroup.getAnyConditionList();
    }

    public List getTaxFilterConditionList() {
        return this.taxFilterConditionGroup.getFilterConditionList();
    }

    public TaxFilterCondition getTaxFilterCondition(int n, long l) {
        return this.taxFilterConditionGroup.getFilterCondition(n, l);
    }

    public void setGeneCountFilterCondition(CountFilterCondition countFilterCondition) {
        this.geneCountFilterCondition = countFilterCondition;
    }

    public void setOrganismCountFilterCondition(CountFilterCondition countFilterCondition) {
        this.organismCountFilterCondition = countFilterCondition;
    }

    public boolean isExistGeneCountFilter() {
        return this.geneCountFilterCondition != null;
    }

    public boolean isEnableGeneCountFilter() {
        return this.isExistGeneCountFilter() && this.geneCountFilterCondition.isFilterActive();
    }

    public boolean isExistOrganismCountFilter() {
        return this.organismCountFilterCondition != null;
    }

    public boolean isEnableOrganismCountFilter() {
        return this.isExistOrganismCountFilter() && this.organismCountFilterCondition.isFilterActive();
    }

    public void saveOrganismGeneFilterCondition() {
        if (StringTool.isNull(this.getDomClustId())) {
            return;
        }
        try {
            ArrayList<CountFilterCondition> arrayList = new ArrayList<CountFilterCondition>();
            arrayList.add(this.geneCountFilterCondition);
            arrayList.add(this.organismCountFilterCondition);
            ApplicationPropertyFacade.saveProperty(this.getDomClustId(), arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save taxonomy filter condition.", iOException);
        }
    }

    public List getCountFilterConditionList() {
        ArrayList<CountFilterCondition> arrayList = new ArrayList<CountFilterCondition>();
        arrayList.add(this.getOrganismCountFilterCondition());
        arrayList.add(this.getGeneCountFilterCondition());
        return arrayList;
    }

    public List getMatchGeneCountCluster(List list) {
        return this.geneCountFilterCondition.getMatchCountCluster(list);
    }

    public List getMatchOrganismCountCluster(List list) {
        return this.organismCountFilterCondition.getMatchCountCluster(list);
    }

    public boolean isMatchGeneCount(Cluster cluster) {
        return this.geneCountFilterCondition.isMatchCount(cluster);
    }

    public boolean isMatchOrganismCount(Cluster cluster) {
        return this.organismCountFilterCondition.isMatchCount(cluster);
    }

    public void addSetCondition(SetCondition setCondition) {
        this.filterSetConditionGroup.addSetCondition(setCondition);
    }

    public void addSetCondition(Collection collection) {
        for (SetCondition setCondition : collection) {
            this.addSetCondition(setCondition);
            setCondition.setFilterActive(true);
        }
    }

    public void removeSetCondition(SetCondition setCondition) {
        this.filterSetConditionGroup.removeSetCondition(setCondition);
    }

    public void clearSetCondition() {
        this.filterSetConditionGroup.clearSetCondition();
    }

    public List getSetConditionList() {
        return this.filterSetConditionGroup.getSetConditionList();
    }

    public List getSetConditionList(int n) {
        return this.filterSetConditionGroup.getSetConditionList(n);
    }

    public SetConditionGroup getSetConditionGroup() {
        return this.filterSetConditionGroup;
    }

    public boolean isExistGeneSetCondition() {
        return this.filterSetConditionGroup.isExistGeneSetCondition();
    }

    public boolean isExistClusterSetCondition() {
        return this.filterSetConditionGroup.isExistClusterSetCondition();
    }

    public boolean isEnableSetColor() {
        return this.filterSetConditionGroup.isEnableColor();
    }

    public boolean isEnableSetFilter() {
        return this.filterSetConditionGroup.isEnableFilter();
    }

    public boolean isMatchSetFilter(Cluster cluster) {
        return this.filterSetConditionGroup.isMatchFilter(cluster);
    }

    public boolean isMatchSetFilter(Collection collection) {
        return this.filterSetConditionGroup.isMatchFilter(collection);
    }

    public void saveSetFilterCondition() {
        if (StringTool.isNull(this.getDomClustId())) {
            return;
        }
        try {
            ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
            arrayList.add(this.filterSetConditionGroup);
            arrayList.add(ColorFacade.getInstance().getColorDrawableManager());
            ApplicationPropertyFacade.saveProperty(this.getDomClustId(), arrayList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save taxonomy filter condition.", iOException);
        }
    }

    public boolean containsSetCondition(SetCondition setCondition) {
        List list = this.filterSetConditionGroup.getSetConditionList(setCondition.getSetType());
        for (SetCondition setCondition2 : list) {
            if (!setCondition2.equalsSetCondition(setCondition)) continue;
            return true;
        }
        return false;
    }

    public void setTaxMapSetCondition(SetCondition setCondition) {
        this.clearTaxMapSetCondition();
        this.getTaxMapSetConditionGroup().addSetCondition(setCondition);
    }

    public void removeTaxMapSetCondition(SetCondition setCondition) {
        this.getTaxMapSetConditionGroup().removeSetCondition(setCondition);
    }

    public void clearTaxMapSetCondition() {
        this.getTaxMapSetConditionGroup().clearSetCondition();
    }

    public SetConditionGroup getTaxMapSetConditionGroup() {
        return this.taxMapSetConditionGroup;
    }

    public boolean isEnableTaxMapFilter() {
        return this.getTaxMapSetConditionGroup().isEnableFilter();
    }

    public boolean isMatchTaxMapFilter(Cluster cluster) {
        return this.getTaxMapSetConditionGroup().isMatchFilter(cluster);
    }

    public boolean isMatchTaxMapFilter(Collection collection) {
        return this.getTaxMapSetConditionGroup().isMatchFilter(collection);
    }

    public boolean isExistTaxMapSetCondition() {
        return this.getTaxMapSetConditionGroup().isExistSetCondition();
    }

    public SetCondition getTaxMapSetCondition() {
        List list = this.getTaxMapSetConditionGroup().getSetConditionList();
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        SetCondition setCondition = (SetCondition)list.get(0);
        return setCondition;
    }

    public void setFuncCatSetCondition(SetCondition setCondition) {
        this.clearFuncCatSetCondition();
        this.getFuncCatSetConditionGroup().addSetCondition(setCondition);
    }

    public void removeFuncCatSetCondition(SetCondition setCondition) {
        this.getFuncCatSetConditionGroup().removeSetCondition(setCondition);
    }

    public void clearFuncCatSetCondition() {
        this.getFuncCatSetConditionGroup().clearSetCondition();
    }

    public SetConditionGroup getFuncCatSetConditionGroup() {
        return this.funcCatSetConditionGroup;
    }

    public boolean isEnableFuncCatFilter() {
        return this.getFuncCatSetConditionGroup().isEnableFilter();
    }

    public boolean isMatchFuncCatFilter(Cluster cluster) {
        return this.getFuncCatSetConditionGroup().isMatchFilter(cluster);
    }

    public boolean isMatchFuncCatFilter(Collection collection) {
        return this.getFuncCatSetConditionGroup().isMatchFilter(collection);
    }

    public boolean isExistFuncCatSetCondition() {
        return this.getFuncCatSetConditionGroup().isExistSetCondition();
    }

    public SetCondition getFuncCatSetCondition() {
        List list = this.getFuncCatSetConditionGroup().getSetConditionList();
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        SetCondition setCondition = (SetCondition)list.get(0);
        return setCondition;
    }

    public Map createPropertyMap() {
        CountFilterCondition countFilterCondition;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.taxFilterConditionGroup.isExistCondition() || this.isEnableOrganismCountFilter() || this.isEnableGeneCountFilter()) {
            hashMap.put(PropertyTableCellRenderer.addTitlePrefix("Filter"), "");
        }
        if (this.taxFilterConditionGroup.isExistCondition()) {
            hashMap.putAll(this.taxFilterConditionGroup.createDisplayOptionMap(this.clusterTbl));
        }
        if (this.isEnableOrganismCountFilter()) {
            countFilterCondition = this.getOrganismCountFilterCondition();
            hashMap.put(PropertyTableCellRenderer.addTitlePrefix("Organism Count Filter"), countFilterCondition.getConditionString());
        }
        if (this.isEnableGeneCountFilter()) {
            countFilterCondition = this.getGeneCountFilterCondition();
            hashMap.put(PropertyTableCellRenderer.addTitlePrefix("Gene Count Filter"), countFilterCondition.getConditionString());
        }
        return hashMap;
    }

    public CountFilterCondition getGeneCountFilterCondition() {
        return this.geneCountFilterCondition;
    }

    public CountFilterCondition getOrganismCountFilterCondition() {
        return this.organismCountFilterCondition;
    }

    public SetConditionGroup getFilterSetConditionGroup() {
        return this.filterSetConditionGroup;
    }

    public void clearCondition() {
        this.taxFilterConditionGroup = TaxFilterConditionGroup.getInstance();
        this.geneCountFilterCondition = new GeneCountFilterCondition();
        this.organismCountFilterCondition = new OrganismCountFilterCondition();
        this.filterSetConditionGroup = new SetConditionGroup();
        this.taxMapSetConditionGroup = new SetConditionGroup();
    }

    public List getFilterActivationList() {
        ArrayList<ApplicationPropertyAccessable> arrayList = new ArrayList<ApplicationPropertyAccessable>();
        arrayList.addAll(this.getTaxFilterConditionGroup().getFilterConditionList());
        if (this.isExistGeneCountFilter()) {
            arrayList.add(this.getGeneCountFilterCondition());
        }
        if (this.isExistOrganismCountFilter()) {
            arrayList.add(this.getOrganismCountFilterCondition());
        }
        if (this.isExistGeneSetCondition() || this.isExistClusterSetCondition()) {
            arrayList.add(this.getSetConditionGroup());
        }
        return arrayList;
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    private String getDomClustId() {
        return this.clusterTbl.getClusterId();
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.addAll(this.taxFilterConditionGroup.getPropertyList(project, string));
        arrayList.addAll(this.geneCountFilterCondition.getPropertyList(project, string));
        arrayList.addAll(this.organismCountFilterCondition.getPropertyList(project, string));
        String string2 = this.createSetCondition2Str(1);
        arrayList.add(ApplicationProperty.createProjectProperty("ColorFilterSet", "ColorFilterSetGeneFilterNameList", string2));
        String string3 = this.createSetCondition2Str(2);
        arrayList.add(ApplicationProperty.createProjectProperty("ColorFilterSet", "ColorFilterSetClusterFilterNameList", string3));
        return arrayList;
    }

    private String createSetCondition2Str(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getSetConditionList(n);
        if (CollectionUtil.isNull(list)) {
            return null;
        }
        for (SetCondition setCondition : list) {
            arrayList.add(setCondition.getName());
        }
        return StringTool.conbineStrList(arrayList, ",");
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2;
        HashSet hashSet;
        this.taxFilterConditionGroup.updateProperty(map, project, string);
        this.geneCountFilterCondition.updateProperty(map, project, string);
        this.organismCountFilterCondition.updateProperty(map, project, string);
        if (map.containsKey("ColorFilterSetGeneFilterNameList")) {
            hashSet = new HashSet();
            string2 = (String)map.get("ColorFilterSetGeneFilterNameList");
            hashSet.addAll(new ArrayList(StringTool.splitString(string2, ",")));
            for (SetCondition setCondition : this.clusterTbl.getSetConditionList(1)) {
                if (!hashSet.contains(setCondition.getName())) continue;
                this.addSetCondition(setCondition);
            }
        }
        if (map.containsKey("ColorFilterSetClusterFilterNameList")) {
            hashSet = new HashSet();
            string2 = (String)map.get("ColorFilterSetClusterFilterNameList");
            hashSet.addAll(new ArrayList(StringTool.splitString(string2, ",")));
            for (SetCondition setCondition : this.clusterTbl.getSetConditionList(2)) {
                if (!hashSet.contains(setCondition.getName())) continue;
                this.addSetCondition(setCondition);
            }
        }
    }
}

