/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FunctionCategoryFileAccesser;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FunctionCategoryExporter
extends FunctionCategoryFileAccesser {
    private static final String FUNCTION_CATEGORY_NAME = "function_category";
    private String type;
    private List functionCategoryList;
    private String outputDir;

    public FunctionCategoryExporter(String string, List list) {
        this.type = string;
        this.functionCategoryList = list;
        this.setOutputDir(AccessServer.getDataDir());
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public void execute() throws IOException {
        this.outputFile();
    }

    private void outputFile() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (FuncCat funcCat : this.functionCategoryList) {
            stringBuffer.append(funcCat.getFunctionCategoryNo());
            stringBuffer.append("\t");
            stringBuffer.append(funcCat.getColor());
            stringBuffer.append("\t");
            stringBuffer.append(funcCat.getName());
            stringBuffer.append("\t");
            stringBuffer.append(funcCat.isDefaultFlag() ? "1" : "");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        FileUtil.outputFile(stringBuffer.toString(), this.getFilepath());
    }

    private String getFilepath() {
        return new File(this.outputDir, FunctionCategoryExporter.getFilename(this.type)).getAbsolutePath();
    }

    public static String getFilename(String string) {
        if (FunctionCategoryType.isMBGD(string)) {
            return "function_category.dat";
        }
        return "function_category_" + string + ".dat";
    }
}

