/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.data.DataManager;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FunctionCategoryFileAccesser;
import cgdp.recog.funccat.FunctionCategoryNoComparator;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class FunctionCategoryImporter
extends FunctionCategoryFileAccesser {
    private String type;
    private Map functionCategoryMap = new TreeMap();

    public FunctionCategoryImporter(String string) {
        this.type = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            String string;
            fileInputStream = new FileInputStream(DataManager.getFunctionCategoryFilepath(this.type));
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                if (StringTool.isNull(string)) continue;
                object = this.getDelimiter(string);
                Vector vector = StringTool.splitString(string, (String)object);
                FuncCat funcCat = new FuncCat();
                funcCat.setFunctionCategoryNo((String)vector.get(0));
                funcCat.setColor((String)vector.get(1));
                funcCat.setName((String)vector.get(2));
                if (vector.size() >= 4) {
                    funcCat.setDefaultFlag(((String)vector.get(3)).equals("1"));
                    bl = false;
                }
                this.functionCategoryMap.put(funcCat.getFunctionCategoryNo(), funcCat);
            }
            if (bl) {
                object = (FuncCat)new ArrayList(this.functionCategoryMap.values()).get(this.functionCategoryMap.size() - 1);
                ((FuncCat)object).setDefaultFlag(true);
            }
            if (!this.containsDefaultFuncCat()) {
                this.setDummyDefaultFuncCat();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private boolean containsDefaultFuncCat() {
        for (FuncCat funcCat : this.functionCategoryMap.values()) {
            if (!funcCat.isDefaultFlag()) continue;
            return true;
        }
        return false;
    }

    private void setDummyDefaultFuncCat() {
        ArrayList arrayList = new ArrayList(this.functionCategoryMap.keySet());
        String string = (String)Collections.max(arrayList, new FunctionCategoryNoComparator());
        FuncCat funcCat = (FuncCat)this.functionCategoryMap.get(string);
        funcCat.setDefaultFlag(true);
    }

    public Map getFunctionCategoryMap() {
        return this.functionCategoryMap;
    }
}

