/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.InfoTitleKeyComparator;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoHeaderExporter;
import cgdp.recog.info.cluster.ClusterInfoKeyComparator;
import cgdp.recog.info.cluster.ClusterInfoListExporter;
import cgdp.recog.info.cluster.ClusterInfoListImporter;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterInfoEditExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoEditExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private List modifiedClusterInfoTitleList;
    private List errorList = new ArrayList();
    private Set newInfoTitleSet = new HashSet();
    private Set editInfoTitleSet = new HashSet();
    private Set deleteInfoTitleSet = new HashSet();

    ClusterInfoEditExecuter(Component component, MediatorImpl mediatorImpl, List list, Set set, Set set2, Set set3) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.modifiedClusterInfoTitleList = list;
        this.deleteInfoTitleSet = set3;
        this.editInfoTitleSet = set2;
        this.newInfoTitleSet = set;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setCount(29);
        progressImpl.increment();
        ClusterInfoFacade.removeCachedInfo(this.deleteInfoTitleSet);
        Map map = this.createLocationClusterInfoSetMap(this.deleteInfoTitleSet);
        this.errorList.addAll(this.removeCellInfo(map));
        progressImpl.setCount(49);
        progressImpl.increment();
        ClusterInfoFacade.removeCachedInfo(this.editInfoTitleSet);
        Map map2 = this.createLocationClusterInfoSetMap(this.editInfoTitleSet);
        this.errorList.addAll(this.editClusterInfo(map2));
        progressImpl.setCount(89);
        progressImpl.increment();
        try {
            Collections.sort(this.modifiedClusterInfoTitleList, new InfoTitleKeyComparator(ClusterInfoTitle.getSystemClusterInfoTitleKeyList()));
            ClusterInfoFacade.exportTitleList(this.modifiedClusterInfoTitleList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save gene_info file.", iOException);
        }
        progressImpl.setCount(99);
        progressImpl.increment();
    }

    private Map createLocationClusterInfoSetMap(Set set) {
        HashMap<String, HashSet<ClusterInfoTitle>> hashMap = new HashMap<String, HashSet<ClusterInfoTitle>>();
        for (ClusterInfoTitle clusterInfoTitle : set) {
            String string = clusterInfoTitle.getLocationName();
            if (LocationType.isNameSystem(string)) continue;
            HashSet<ClusterInfoTitle> hashSet = (HashSet<ClusterInfoTitle>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<ClusterInfoTitle>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(clusterInfoTitle);
        }
        return hashMap;
    }

    private List removeCellInfo(Map map) {
        ArrayList arrayList = new ArrayList();
        for (String string : map.keySet()) {
            Set set = (Set)map.get(string);
            if (CollectionUtil.isNull(set)) continue;
            arrayList.addAll(this.removeClusterInfo(string, set));
        }
        return arrayList;
    }

    private List removeClusterInfo(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.createDomClustIdCluterInfoTitleMap(set);
        Map map2 = ProjectAccesser.createNameProjectMap();
        for (String string2 : map.keySet()) {
            Set set2 = (Set)map.get(string2);
            Map map3 = ClusterInfoUtil.createInfoTypeCluterInfoTitleMap(set2);
            if (MapUtil.isNull(map3)) continue;
            Iterator iterator = map3.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Set set3 = (Set)map3.get(new Integer(n));
                String string3 = this.getClusterInfoFilepath(string2, string, n, map2);
                try {
                    ClusterInfoListImporter clusterInfoListImporter = new ClusterInfoListImporter(string3, n, string2);
                    clusterInfoListImporter.execute();
                    List list = clusterInfoListImporter.getInfoTitleList();
                    list.removeAll(set3);
                    if (list.size() == 1) {
                        FileUtil.delete(string3);
                        continue;
                    }
                    ArrayList<ClusterInfo> arrayList2 = new ArrayList<ClusterInfo>();
                    Map map4 = clusterInfoListImporter.getClusterInfoMap();
                    for (String string4 : map4.keySet()) {
                        ClusterInfo clusterInfo = (ClusterInfo)map4.get(string4);
                        clusterInfo.removeAllInfo(set3);
                        clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, string4);
                        arrayList2.add(clusterInfo);
                    }
                    Collections.sort(arrayList2, new ClusterInfoKeyComparator(n));
                    ClusterInfoListExporter clusterInfoListExporter = new ClusterInfoListExporter(string3, list, arrayList2);
                    clusterInfoListExporter.execute();
                }
                catch (Exception exception) {
                    logger.warn("Fail to delete cluster property. " + string2 + " " + n, exception);
                    arrayList.add(this.getErrorMessage(string2, set));
                }
            }
        }
        return arrayList;
    }

    private List editClusterInfo(Map map) {
        ArrayList arrayList = new ArrayList();
        for (String string : map.keySet()) {
            Set set = (Set)map.get(string);
            arrayList.addAll(this.editClusterInfo(string, set));
        }
        return arrayList;
    }

    private List editClusterInfo(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.createDomClustIdCluterInfoTitleMap(set);
        Map map2 = ProjectAccesser.createNameProjectMap();
        for (String string2 : map.keySet()) {
            Set set2 = (Set)map.get(string2);
            Map map3 = ClusterInfoUtil.createInfoTypeCluterInfoTitleMap(set2);
            if (MapUtil.isNull(map3)) continue;
            Iterator iterator = map3.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Set set3 = (Set)map3.get(new Integer(n));
                String string3 = this.getClusterInfoFilepath(string2, string, n, map2);
                try {
                    ClusterInfoHeaderExporter clusterInfoHeaderExporter = ClusterInfoHeaderExporter.createInstance(string3, n, set3, string2);
                    clusterInfoHeaderExporter.execute();
                }
                catch (Exception exception) {
                    logger.warn("Fail to edit cluster property file. " + string2 + " " + n, exception);
                    arrayList.add(this.getErrorMessage(string2, set));
                }
            }
        }
        return arrayList;
    }

    private Map createDomClustIdCluterInfoTitleMap(Set set) {
        HashMap<String, HashSet<ClusterInfoTitle>> hashMap = new HashMap<String, HashSet<ClusterInfoTitle>>();
        for (ClusterInfoTitle clusterInfoTitle : set) {
            Set set2 = clusterInfoTitle.getDomClustIdSet();
            for (String string : set2) {
                HashSet<ClusterInfoTitle> hashSet = (HashSet<ClusterInfoTitle>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<ClusterInfoTitle>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(clusterInfoTitle);
            }
        }
        return hashMap;
    }

    private String getClusterInfoFilepath(String string, String string2, int n, Map map) {
        if (LocationType.isNameGlobal(string2) || LocationType.isNameSystem(string2)) {
            return null;
        }
        Project project = (Project)map.get(string2);
        if (project == null) {
            return null;
        }
        String string3 = DataManager.getClusterInfoFilepath(project, string, n);
        return string3;
    }

    private String getErrorMessage(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClusterInfoTitle clusterInfoTitle : set) {
            arrayList.add(clusterInfoTitle.getName());
        }
        Collections.sort(arrayList);
        return string + "[" + StringTool.conbineStrList(arrayList, ",") + "]";
    }

    @Override
    public void done() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.deleteInfoTitleSet);
        hashSet.addAll(this.editInfoTitleSet);
        this.mediator.updateInfoTitle(hashSet);
    }
}

