/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.Const;
import cgdp.recog.data.Cluster;
import cgdp.recog.info.AbstractInfoConfImporter;
import cgdp.recog.info.AbstractInfoManager;
import cgdp.recog.info.InfoTitleComparator;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoConfExporter;
import cgdp.recog.info.cluster.ClusterInfoConfImporter;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.MapUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClusterInfoManager
extends AbstractInfoManager {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterInfoManager.class);
    private static final ClusterInfoManager CLUSTER_INFO_MANAGER = new ClusterInfoManager();
    private String domClustId;
    private Map homClusterInfoMap = new HashMap();
    private Map clusterInfoMap = new HashMap();
    private Map subClusterInfoMap = new HashMap();

    private ClusterInfoManager() {
    }

    public static ClusterInfoManager getInstance() {
        return CLUSTER_INFO_MANAGER;
    }

    @Override
    public void clear() {
        this.domClustId = null;
        this.homClusterInfoMap = new HashMap();
        this.clusterInfoMap = new HashMap();
        this.subClusterInfoMap = new HashMap();
        super.clear();
    }

    public List getUserClusterInfoTitleList(int n) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (ClusterInfoTitle clusterInfoTitle : this.getInfoTitleList()) {
            if (LocationType.isNameSystem(clusterInfoTitle.getLocationName()) || clusterInfoTitle.getType() != n) continue;
            arrayList.add(clusterInfoTitle);
        }
        return arrayList;
    }

    public void loadClusterInfo(ClusterInfoTitle clusterInfoTitle, String string) throws IOException {
        Map map = ClusterInfoFacade.importClusterInfo(clusterInfoTitle, string);
        this.addClusterInfo(map, clusterInfoTitle, clusterInfoTitle.getInfoType());
    }

    public boolean addClusterInfo(Map map, ClusterInfoTitle clusterInfoTitle, int n) {
        HashSet<ClusterInfoTitle> hashSet = new HashSet<ClusterInfoTitle>();
        hashSet.add(clusterInfoTitle);
        return this.addClusterInfo(map, hashSet, n);
    }

    public boolean addClusterInfo(Map map, Set set, int n) {
        Map map2 = this.getClusterInfoMap(n);
        if (map2 == null) {
            return false;
        }
        this.addClusterInfo(map, set, map2);
        this.addCachedInfoTitle(set);
        return true;
    }

    private void addClusterInfo(Map map, Set set, Map map2) {
        for (String string : map.keySet()) {
            ClusterInfo clusterInfo = (ClusterInfo)map.get(string);
            ClusterInfo clusterInfo2 = (ClusterInfo)map2.get(string);
            if (clusterInfo2 == null) {
                clusterInfo2 = new ClusterInfo();
                map2.put(string, clusterInfo2);
            }
            for (ClusterInfoTitle clusterInfoTitle : set) {
                Object object = clusterInfo.getInfo(clusterInfoTitle);
                if (object == null) continue;
                clusterInfo2.putInfo(clusterInfoTitle, object);
            }
        }
    }

    public Object getValue(ClusterInfoTitle clusterInfoTitle, Cluster cluster) {
        String string;
        Map map;
        ClusterInfo clusterInfo;
        if (!this.isCachedInfoTitle(clusterInfoTitle)) {
            try {
                this.loadClusterInfo(clusterInfoTitle, this.getDomClustId());
            }
            catch (IOException iOException) {
                logger.warn("Fail to load cluster properties. " + clusterInfoTitle, iOException);
            }
        }
        if ((clusterInfo = (ClusterInfo)(map = this.getClusterInfoMap(clusterInfoTitle.getInfoType())).get(string = ClusterInfoUtil.getClusterInfoKey(cluster, clusterInfoTitle.getInfoType()))) == null) {
            return null;
        }
        return clusterInfo.getInfo(clusterInfoTitle);
    }

    @Override
    public void removeCachedInfo(Collection collection) {
        Map map = ClusterInfoUtil.createInfoTypeCluterInfoTitleMap(collection);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Set set = (Set)map.get(new Integer(n));
            this.removeCachedInfo(set, n);
        }
        this.removeCachedInfoTitle(collection);
    }

    private void removeCachedInfo(Set set, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.getClusterInfoMap(n);
        if (MapUtil.isNull(map)) {
            return;
        }
        for (String string : map.keySet()) {
            ClusterInfo clusterInfo = (ClusterInfo)map.get(string);
            clusterInfo.removeAllInfo(set);
            if (clusterInfo.isExistValue()) continue;
            hashSet.add(string);
        }
        for (String string : hashSet) {
            map.remove(string);
        }
    }

    private Map getClusterInfoMap(int n) {
        Map map = null;
        if (ClusterInfoType.isCluster(n)) {
            map = this.clusterInfoMap;
        } else if (ClusterInfoType.isSubCluster(n)) {
            map = this.subClusterInfoMap;
        } else if (ClusterInfoType.isHomCluster(n)) {
            map = this.homClusterInfoMap;
        }
        return map;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    @Override
    public List getInfoTitleListByAnalysisKey(String string, String string2) {
        ArrayList<ClusterInfoTitle> arrayList = new ArrayList<ClusterInfoTitle>();
        for (ClusterInfoTitle clusterInfoTitle : this.getInfoTitleMap().values()) {
            if (!clusterInfoTitle.isUseAnalysis(string) || !StringTool.isNull(string2) && !clusterInfoTitle.containsDomClustId(string2) || clusterInfoTitle.isCacheNeed() && LocationType.isNameSystem(clusterInfoTitle.getLocationName()) && !this.isCachedInfoTitle(clusterInfoTitle)) continue;
            arrayList.add(clusterInfoTitle);
        }
        Collections.sort(arrayList, new InfoTitleComparator(2));
        return arrayList;
    }

    @Override
    protected FileExporter createInfoTitleExporter(List list) {
        return new ClusterInfoConfExporter(list);
    }

    @Override
    protected AbstractInfoConfImporter createInfoTitleImporter(String string) {
        return new ClusterInfoConfImporter(string);
    }

    @Override
    protected String getConfFilepath() {
        return Const.USER_CLUSTER_INFO_PATH;
    }
}

